/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.io.IOException;
import java.nio.channels.ByteChannel;
import java.sql.Timestamp;
import water.AutoBuffer;
import water.H2ONode;

public class ExternalFrameUtils {
    public static final byte EXPECTED_BOOL = 0;
    public static final byte EXPECTED_BYTE = 1;
    public static final byte EXPECTED_CHAR = 2;
    public static final byte EXPECTED_SHORT = 3;
    public static final byte EXPECTED_INT = 4;
    public static final byte EXPECTED_FLOAT = 5;
    public static final byte EXPECTED_LONG = 6;
    public static final byte EXPECTED_DOUBLE = 7;
    public static final byte EXPECTED_STRING = 8;
    public static final byte EXPECTED_TIMESTAMP = 9;

    public static ByteChannel getConnection(String h2oNodeHostname, int h2oNodeApiPort) throws IOException {
        return H2ONode.openChan((byte)3, null, h2oNodeHostname, h2oNodeApiPort + 1);
    }

    public static ByteChannel getConnection(String ipPort) throws IOException {
        String[] split = ipPort.split(":");
        return ExternalFrameUtils.getConnection(split[0], Integer.parseInt(split[1]));
    }

    public static byte[] vecTypesFromExpectedTypes(byte[] expectedTypes) {
        byte[] vecTypes = new byte[expectedTypes.length];
        block12: for (int i = 0; i < expectedTypes.length; ++i) {
            switch (expectedTypes[i]) {
                case 0: {
                    vecTypes[i] = 3;
                    continue block12;
                }
                case 1: {
                    vecTypes[i] = 3;
                    continue block12;
                }
                case 2: {
                    vecTypes[i] = 3;
                    continue block12;
                }
                case 3: {
                    vecTypes[i] = 3;
                    continue block12;
                }
                case 4: {
                    vecTypes[i] = 3;
                    continue block12;
                }
                case 6: {
                    vecTypes[i] = 3;
                    continue block12;
                }
                case 5: {
                    vecTypes[i] = 3;
                    continue block12;
                }
                case 7: {
                    vecTypes[i] = 3;
                    continue block12;
                }
                case 8: {
                    vecTypes[i] = 2;
                    continue block12;
                }
                case 9: {
                    vecTypes[i] = 5;
                    continue block12;
                }
                default: {
                    throw new IllegalArgumentException("Unknown expected type: " + expectedTypes[i]);
                }
            }
        }
        return vecTypes;
    }

    public static byte[] prepareExpectedTypes(Class[] javaClasses) {
        byte[] expectedTypes = new byte[javaClasses.length];
        for (int i = 0; i < javaClasses.length; ++i) {
            Class clazz = javaClasses[i];
            if (clazz == Boolean.class) {
                expectedTypes[i] = 0;
                continue;
            }
            if (clazz == Byte.class) {
                expectedTypes[i] = 1;
                continue;
            }
            if (clazz == Short.class) {
                expectedTypes[i] = 3;
                continue;
            }
            if (clazz == Character.class) {
                expectedTypes[i] = 2;
                continue;
            }
            if (clazz == Integer.class) {
                expectedTypes[i] = 4;
                continue;
            }
            if (clazz == Long.class) {
                expectedTypes[i] = 6;
                continue;
            }
            if (clazz == Float.class) {
                expectedTypes[i] = 5;
                continue;
            }
            if (clazz == Double.class) {
                expectedTypes[i] = 7;
                continue;
            }
            if (clazz == String.class) {
                expectedTypes[i] = 8;
                continue;
            }
            if (clazz == Timestamp.class) {
                expectedTypes[i] = 9;
                continue;
            }
            throw new IllegalArgumentException("Unknown java class " + clazz);
        }
        return expectedTypes;
    }

    static void sendBoolean(AutoBuffer ab, ByteChannel channel, boolean data) throws IOException {
        ExternalFrameUtils.sendBoolean(ab, channel, data ? (byte)1 : 0);
    }

    static void sendBoolean(AutoBuffer ab, ByteChannel channel, byte boolData) throws IOException {
        ab.put1(boolData);
        ExternalFrameUtils.putMarkerAndSend(ab, channel, boolData);
    }

    static void sendByte(AutoBuffer ab, ByteChannel channel, byte data) throws IOException {
        ab.put1(data);
        ExternalFrameUtils.putMarkerAndSend(ab, channel, data);
    }

    static void sendChar(AutoBuffer ab, ByteChannel channel, char data) throws IOException {
        ab.put2(data);
        ExternalFrameUtils.putMarkerAndSend(ab, channel, data);
    }

    static void sendShort(AutoBuffer ab, ByteChannel channel, short data) throws IOException {
        ab.put2s(data);
        ExternalFrameUtils.putMarkerAndSend(ab, channel, data);
    }

    static void sendInt(AutoBuffer ab, ByteChannel channel, int data) throws IOException {
        ab.putInt(data);
        ExternalFrameUtils.putMarkerAndSend(ab, channel, data);
    }

    static void sendLong(AutoBuffer ab, ByteChannel channel, long data) throws IOException {
        ab.put8(data);
        ExternalFrameUtils.putMarkerAndSend(ab, channel, data);
    }

    static void sendFloat(AutoBuffer ab, ByteChannel channel, float data) throws IOException {
        ab.put4f(data);
        ExternalFrameUtils.writeToChannel(ab, channel);
    }

    static void sendDouble(AutoBuffer ab, ByteChannel channel, double data) throws IOException {
        ab.put8d(data);
        ExternalFrameUtils.writeToChannel(ab, channel);
    }

    static void sendString(AutoBuffer ab, ByteChannel channel, String data) throws IOException {
        ab.putStr(data);
        if (data != null && data.equals("\u0080")) {
            ab.put1(0);
        }
        ExternalFrameUtils.writeToChannel(ab, channel);
    }

    static void sendTimestamp(AutoBuffer ab, ByteChannel channel, long time) throws IOException {
        ExternalFrameUtils.sendLong(ab, channel, time);
    }

    static void sendTimestamp(AutoBuffer ab, ByteChannel channel, Timestamp data) throws IOException {
        ExternalFrameUtils.sendLong(ab, channel, data.getTime());
    }

    static void sendNA(AutoBuffer ab, ByteChannel channel, byte expectedType) throws IOException {
        switch (expectedType) {
            case 0: 
            case 1: {
                ab.put1(127);
                ab.put1(1);
                ExternalFrameUtils.writeToChannel(ab, channel);
                break;
            }
            case 2: {
                ab.put2((short)127);
                ab.put1(1);
                ExternalFrameUtils.writeToChannel(ab, channel);
                break;
            }
            case 3: {
                ab.put2s((short)127);
                ab.put1(1);
                ExternalFrameUtils.writeToChannel(ab, channel);
                break;
            }
            case 4: {
                ab.putInt(127);
                ab.put1(1);
                ExternalFrameUtils.writeToChannel(ab, channel);
                break;
            }
            case 6: 
            case 9: {
                ab.put8(127L);
                ab.put1(1);
                ExternalFrameUtils.writeToChannel(ab, channel);
                break;
            }
            case 5: {
                ab.put4f(Float.NaN);
                ExternalFrameUtils.writeToChannel(ab, channel);
                break;
            }
            case 7: {
                ab.put8d(Double.NaN);
                ExternalFrameUtils.writeToChannel(ab, channel);
                break;
            }
            case 8: {
                ab.putStr("\u0080");
                ab.put1(1);
                ExternalFrameUtils.writeToChannel(ab, channel);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown expected type " + expectedType);
            }
        }
    }

    public static boolean isNA(AutoBuffer ab, boolean data) {
        return ExternalFrameUtils.isNA(ab, data ? 1L : 0L);
    }

    public static boolean isNA(AutoBuffer ab, long data) {
        return data == 127L && ab.get1() == 1;
    }

    public static boolean isNA(double data) {
        return Double.isNaN(data);
    }

    public static boolean isNA(AutoBuffer ab, Timestamp data) {
        return ExternalFrameUtils.isNA(ab, data.getTime());
    }

    public static boolean isNA(AutoBuffer ab, String data) {
        return data != null && data.equals("\u0080") && ab.get1() == 1;
    }

    private static void putMarkerAndSend(AutoBuffer ab, ByteChannel channel, long data) throws IOException {
        if (data == 127L) {
            ab.put1(0);
        }
        ExternalFrameUtils.writeToChannel(ab, channel);
    }

    static void writeToChannel(AutoBuffer ab, ByteChannel channel) throws IOException {
        ab.flipForReading();
        channel.write(ab._bb);
        ab.clearForWriting((byte)126);
    }
}

