/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import water.H2O;
import water.Key;
import water.api.Handler;
import water.api.schemas3.InitIDV3;
import water.api.schemas3.RapidsFrameV3;
import water.api.schemas3.RapidsFunctionV3;
import water.api.schemas3.RapidsHelpV3;
import water.api.schemas3.RapidsNumberV3;
import water.api.schemas3.RapidsNumbersV3;
import water.api.schemas3.RapidsSchemaV3;
import water.api.schemas3.RapidsStringV3;
import water.api.schemas3.RapidsStringsV3;
import water.api.schemas3.SchemaV3;
import water.exceptions.H2OIllegalArgumentException;
import water.rapids.Rapids;
import water.rapids.Session;
import water.rapids.Val;
import water.rapids.ast.AstRoot;
import water.util.Log;
import water.util.StringUtils;

public class RapidsHandler
extends Handler {
    public static HashMap<String, Session> SESSIONS = new HashMap();

    public RapidsSchemaV3 exec(int version, RapidsSchemaV3 rapids) {
        Val val;
        Session ses;
        if (rapids == null) {
            return null;
        }
        if (!StringUtils.isNullOrEmpty(rapids.id)) {
            throw new H2OIllegalArgumentException("Field RapidsSchemaV3.id is deprecated and should not be set " + rapids.id);
        }
        if (StringUtils.isNullOrEmpty(rapids.ast)) {
            return rapids;
        }
        if (StringUtils.isNullOrEmpty(rapids.session_id)) {
            rapids.session_id = "_specialSess";
        }
        if ((ses = SESSIONS.get(rapids.session_id)) == null) {
            ses = new Session(rapids.session_id);
            SESSIONS.put(rapids.session_id, ses);
        }
        try {
            val = Rapids.exec(rapids.ast, ses);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Throwable e) {
            Log.err(e);
            e.printStackTrace();
            throw e;
        }
        switch (val.type()) {
            case 1: {
                return new RapidsNumberV3(val.getNum());
            }
            case 2: {
                return new RapidsNumbersV3(val.getNums());
            }
            case 6: {
                return new RapidsNumbersV3(val.getRow());
            }
            case 3: {
                return new RapidsStringV3(val.getStr());
            }
            case 4: {
                return new RapidsStringsV3(val.getStrs());
            }
            case 5: {
                return new RapidsFrameV3(val.getFrame());
            }
            case 7: {
                return new RapidsFunctionV3(val.getFun().toString());
            }
        }
        throw H2O.fail();
    }

    public RapidsHelpV3 genHelp(int version, SchemaV3 noschema) {
        Reflections reflections = new Reflections("water.rapids", new Scanner[0]);
        RapidsHelpV3 res = new RapidsHelpV3();
        res.syntax = this.processAstClass(AstRoot.class, reflections);
        return res;
    }

    private RapidsHelpV3.RapidsExpressionV3 processAstClass(Class<? extends AstRoot> clz, Reflections refl) {
        ArrayList<RapidsHelpV3.RapidsExpressionV3> subs = new ArrayList<RapidsHelpV3.RapidsExpressionV3>();
        for (Class subclass : refl.getSubTypesOf(clz)) {
            if (subclass.getSuperclass() != clz) continue;
            subs.add(this.processAstClass(subclass, refl));
        }
        RapidsHelpV3.RapidsExpressionV3 target = new RapidsHelpV3.RapidsExpressionV3();
        target.name = clz.getSimpleName();
        target.is_abstract = Modifier.isAbstract(clz.getModifiers());
        if (!target.is_abstract) {
            try {
                AstRoot m = clz.newInstance();
                target.pattern = m.example();
                target.description = m.description();
            }
            catch (IllegalAccessException e) {
                throw H2O.fail("A");
            }
            catch (InstantiationException e) {
                throw H2O.fail("B");
            }
        }
        target.sub = subs.toArray(new RapidsHelpV3.RapidsExpressionV3[subs.size()]);
        return target;
    }

    public InitIDV3 startSession(int version, InitIDV3 p) {
        p.session_key = "_sid" + Key.make().toString().substring(0, 5);
        return p;
    }

    public InitIDV3 endSession(int version, InitIDV3 p) {
        if (SESSIONS.get(p.session_key) != null) {
            try {
                SESSIONS.get(p.session_key).end(null);
                SESSIONS.remove(p.session_key);
            }
            catch (Throwable ex) {
                throw SESSIONS.get(p.session_key).endQuietly(ex);
            }
        }
        return p;
    }
}

