/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.DKV;
import water.Futures;
import water.MemoryManager;
import water.Value;
import water.fvec.Chunk;
import water.fvec.NewChunk;
import water.util.UnsafeUtils;

public class C4VolatileChunk
extends Chunk {
    protected static final long _NA = Integer.MIN_VALUE;
    private transient int[] _is;

    C4VolatileChunk(int[] is) {
        this._is = is;
        this._mem = new byte[0];
        this._start = -1L;
        this._len = is.length;
    }

    @Override
    public boolean isVolatile() {
        return true;
    }

    public int[] getValues() {
        return this._is;
    }

    @Override
    protected final long at8_impl(int i) {
        long res = this._is[i];
        if (res == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("at8_abs but value is missing");
        }
        return res;
    }

    @Override
    protected final double atd_impl(int i) {
        long res = this._is[i];
        return res == Integer.MIN_VALUE ? Double.NaN : (double)res;
    }

    @Override
    protected final boolean isNA_impl(int i) {
        return (long)this._is[i] == Integer.MIN_VALUE;
    }

    @Override
    boolean set_impl(int idx, long l) {
        if (Integer.MIN_VALUE >= l || l > Integer.MAX_VALUE) {
            return false;
        }
        this._is[idx] = (int)l;
        return true;
    }

    @Override
    boolean set_impl(int i, double d) {
        return false;
    }

    @Override
    boolean set_impl(int i, float f) {
        return false;
    }

    @Override
    boolean setNA_impl(int idx) {
        this._is[idx] = Integer.MIN_VALUE;
        return true;
    }

    @Override
    public NewChunk inflate_impl(NewChunk nc) {
        nc.set_sparseLen(0);
        nc.set_len(0);
        int len = this._len;
        for (int i = 0; i < len; ++i) {
            int res = this._is[i];
            if ((long)res == Integer.MIN_VALUE) {
                nc.addNA();
                continue;
            }
            nc.addNum(res, 0);
        }
        return nc;
    }

    @Override
    public final void initFromBytes() {
        this._len = this._mem.length >> 2;
        this._is = MemoryManager.malloc4(this._len);
        for (int i = 0; i < this._is.length; ++i) {
            this._is[i] = UnsafeUtils.get4(this._mem, 4 * i);
        }
        this._mem = null;
    }

    @Override
    public Futures close(int cidx, Futures fs) {
        if (this.chk2() != null) {
            return this.chk2().close(cidx, fs);
        }
        Value v = new Value(this._vec.chunkKey(cidx), this, this._len * 4, 1);
        DKV.put(v._key, v, fs);
        return fs;
    }

    @Override
    public byte[] asBytes() {
        byte[] res = MemoryManager.malloc1(this._len * 4);
        for (int i = 0; i < this._len; ++i) {
            UnsafeUtils.set4(res, 4 * i, this._is[i]);
        }
        return res;
    }

    @Override
    public boolean hasFloat() {
        return false;
    }

    @Override
    public double[] getDoubles(double[] vals, int from, int to, double NA) {
        for (int i = from; i < to; ++i) {
            long res = this._is[i];
            vals[i - from] = res != Integer.MIN_VALUE ? (double)res : NA;
        }
        return vals;
    }

    @Override
    public double[] getDoubles(double[] vals, int[] ids) {
        int j = 0;
        for (int i : ids) {
            long res = this._is[i];
            vals[j++] = res != Integer.MIN_VALUE ? (double)res : Double.NaN;
        }
        return vals;
    }

    @Override
    public int[] getIntegers(int[] vals, int from, int to, int NA) {
        System.arraycopy(this._is, from, vals, 0, to - from);
        if ((long)NA != Integer.MIN_VALUE) {
            for (int i = 0; i < to - from; ++i) {
                if ((long)vals[i] != Integer.MIN_VALUE) continue;
                vals[i] = NA;
            }
        }
        return vals;
    }
}

