/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.DKV;
import water.Futures;
import water.H2O;
import water.MemoryManager;
import water.Value;
import water.fvec.Chunk;
import water.fvec.NewChunk;
import water.util.UnsafeUtils;

public final class C8DVolatileChunk
extends Chunk {
    private transient double[] _ds;

    C8DVolatileChunk(double[] ds) {
        this._start = -1L;
        this._len = ds.length;
        this._ds = ds;
    }

    public double[] getValues() {
        return this._ds;
    }

    @Override
    protected final long at8_impl(int i) {
        double res = this._ds[i];
        if (Double.isNaN(res)) {
            throw new IllegalArgumentException("at8_abs but value is missing");
        }
        return (long)res;
    }

    @Override
    protected final double atd_impl(int i) {
        return this._ds[i];
    }

    @Override
    protected final boolean isNA_impl(int i) {
        return Double.isNaN(this._ds[i]);
    }

    @Override
    boolean set_impl(int idx, long l) {
        double d = l;
        if (d != (double)l) {
            return false;
        }
        this._ds[idx] = d;
        return true;
    }

    @Override
    boolean set_impl(int i, double d) {
        this._ds[i] = d;
        return true;
    }

    @Override
    boolean set_impl(int i, float f) {
        this._ds[i] = f;
        return true;
    }

    @Override
    public boolean isVolatile() {
        return true;
    }

    @Override
    boolean setNA_impl(int idx) {
        UnsafeUtils.set8d(this._mem, idx << 3, Double.NaN);
        return true;
    }

    @Override
    public NewChunk inflate_impl(NewChunk nc) {
        nc.alloc_doubles(this._len);
        for (int i = 0; i < this._len; ++i) {
            nc.doubles()[i] = this._ds[i];
        }
        nc.set_sparseLen(nc.set_len(this._len));
        return nc;
    }

    @Override
    public final void initFromBytes() {
        this._len = this._mem.length >> 3;
        this._ds = MemoryManager.malloc8d(this._len);
        for (int i = 0; i < this._ds.length; ++i) {
            this._ds[i] = UnsafeUtils.get8d(this._mem, 8 * i);
        }
        this._mem = null;
    }

    @Override
    public byte[] asBytes() {
        byte[] res = MemoryManager.malloc1(this._len * 8);
        for (int i = 0; i < this._len; ++i) {
            UnsafeUtils.set8d(res, 8 * i, this._ds[i]);
        }
        return res;
    }

    @Override
    public Futures close(int cidx, Futures fs) {
        if (this.chk2() != null) {
            return this.chk2().close(cidx, fs);
        }
        Value v = new Value(this._vec.chunkKey(cidx), this, this._len * 8, 1);
        DKV.put(v._key, v, fs);
        return fs;
    }

    @Override
    public double[] getDoubles(double[] vals, int from, int to) {
        throw H2O.unimpl();
    }

    @Override
    public double[] getDoubles(double[] vals, int from, int to, double NA) {
        throw H2O.unimpl();
    }

    @Override
    public double[] getDoubles(double[] vals, int[] ids) {
        throw H2O.unimpl();
    }
}

