/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import java.util.Arrays;
import jsr166y.CountedCompleter;
import jsr166y.ForkJoinTask;
import water.DKV;
import water.DTask;
import water.Freezable;
import water.Futures;
import water.H2O;
import water.Iced;
import water.Key;
import water.MRTask;
import water.RPC;
import water.Value;
import water.fvec.C0DChunk;
import water.fvec.C1Chunk;
import water.fvec.C1NChunk;
import water.fvec.C1SChunk;
import water.fvec.C2Chunk;
import water.fvec.C2SChunk;
import water.fvec.C4Chunk;
import water.fvec.C4FChunk;
import water.fvec.C4SChunk;
import water.fvec.C8Chunk;
import water.fvec.C8DChunk;
import water.fvec.Chunk;
import water.fvec.InteractionWrappedVec;
import water.fvec.RollupStatsHelpers;
import water.fvec.Vec;
import water.nbhm.NonBlockingHashMap;
import water.parser.BufferedString;
import water.util.ArrayUtils;
import water.util.Log;

final class RollupStats
extends Iced {
    volatile transient ForkJoinTask _tsk;
    volatile long _naCnt;
    double _mean;
    double _sigma;
    long _rows;
    long _nzCnt;
    long _size;
    long _pinfs;
    long _ninfs;
    boolean _isInt = true;
    double[] _mins = new double[5];
    double[] _maxs = new double[5];
    long _checksum;
    private static final int MAX_SIZE = 1000;
    volatile long[] _bins;
    double[] _pctiles;
    private static NonBlockingHashMap<Key, RPC> _pendingRollups = new NonBlockingHashMap();

    public boolean hasHisto() {
        return this._bins != null;
    }

    boolean isMutating() {
        return this._naCnt == -2L;
    }

    private boolean isComputing() {
        return this._naCnt == -1L;
    }

    private boolean isReady() {
        return this._naCnt >= 0L;
    }

    private RollupStats(int mode) {
        Arrays.fill(this._mins, Double.MAX_VALUE);
        Arrays.fill(this._maxs, -1.7976931348623157E308);
        this._pctiles = new double[Vec.PERCENTILES.length];
        Arrays.fill(this._pctiles, Double.NaN);
        this._sigma = 0.0;
        this._mean = 0.0;
        this._size = 0L;
        this._naCnt = mode;
    }

    private static RollupStats makeComputing() {
        return new RollupStats(-1);
    }

    static RollupStats makeMutating() {
        return new RollupStats(-2);
    }

    private RollupStats map(Chunk c) {
        double max;
        this._size = c.byteSize();
        boolean isUUID = c._vec.isUUID();
        boolean isString = c._vec.isString();
        BufferedString tmpStr = new BufferedString();
        if (isString) {
            this._isInt = false;
        }
        long checksum = 0L;
        long start = c._start;
        long l = 81985529216486895L;
        double min = c.min();
        if (min == (max = c.max())) {
            double d = min;
            this._checksum = (c.hasFloat() ? Double.doubleToRawLongBits(d) : (long)d) * (long)c._len;
            Arrays.fill(this._mins, d);
            Arrays.fill(this._maxs, d);
            if (d == Double.POSITIVE_INFINITY) {
                ++this._pinfs;
            } else if (d == Double.NEGATIVE_INFINITY) {
                ++this._ninfs;
            } else {
                if (Double.isNaN(d)) {
                    this._naCnt = c._len;
                } else if (d != 0.0) {
                    this._nzCnt = c._len;
                }
                this._mean = d;
                this._rows = c._len;
            }
            this._isInt = (double)((long)d) == d;
            this._sigma = 0.0;
            return this;
        }
        if (c instanceof C0DChunk && c.isNA_impl(0)) {
            this._sigma = 0.0;
            this._mean = 0.0;
            this._naCnt = c._len;
            this._nzCnt = 0L;
            return this;
        }
        if (min == 0.0 && max == 1.0) {
            int i;
            int zs = c._len - c.sparseLenZero();
            int nans = 0;
            int i2 = c.nextNZ(-1);
            while (i2 < c._len) {
                if (c.isNA(i2)) {
                    ++nans;
                } else if (c.at8(i2) == 0L) {
                    ++zs;
                }
                i2 = c.nextNZ(i2);
            }
            int os = c._len - zs - nans;
            this._nzCnt += (long)os;
            this._naCnt += (long)nans;
            for (i = 0; i < Math.min(this._mins.length, zs); ++i) {
                this.min(0.0);
                this.max(0.0);
            }
            for (i = 0; i < Math.min(this._mins.length, os); ++i) {
                this.min(1.0);
                this.max(1.0);
            }
            this._rows += (long)(zs + os);
            this._mean = (double)os / (double)this._rows;
            this._sigma = (double)zs * (0.0 - this._mean) * (0.0 - this._mean) + (double)os * (1.0 - this._mean) * (1.0 - this._mean);
            return this;
        }
        if (isUUID) {
            int i = c.nextNZ(-1);
            while (i < c._len) {
                if (c.isNA(i)) {
                    ++this._naCnt;
                } else {
                    long lo = c.at16l(i);
                    long hi = c.at16h(i);
                    if (lo != 0L || hi != 0L) {
                        ++this._nzCnt;
                    }
                    l = lo ^ 37L * hi;
                }
                if (l != 0L) {
                    checksum ^= 17L * (start + (long)i) ^ 23L * l;
                }
                i = c.nextNZ(i);
            }
        } else if (isString) {
            int i = c.nextNZ(-1);
            while (i < c._len) {
                if (c.isNA(i)) {
                    ++this._naCnt;
                } else {
                    ++this._nzCnt;
                    l = c.atStr(tmpStr, i).hashCode();
                }
                if (l != 0L) {
                    checksum ^= 17L * (start + (long)i) ^ 23L * l;
                }
                i = c.nextNZ(i);
            }
        } else {
            int zeros;
            checksum = c instanceof C1Chunk ? new RollupStatsHelpers(this).numericChunkRollup((C1Chunk)c, start, checksum) : (c instanceof C1SChunk ? new RollupStatsHelpers(this).numericChunkRollup((C1SChunk)c, start, checksum) : (c instanceof C1NChunk ? new RollupStatsHelpers(this).numericChunkRollup((C1NChunk)c, start, checksum) : (c instanceof C2Chunk ? new RollupStatsHelpers(this).numericChunkRollup((C2Chunk)c, start, checksum) : (c instanceof C2SChunk ? new RollupStatsHelpers(this).numericChunkRollup((C2SChunk)c, start, checksum) : (c instanceof C4SChunk ? new RollupStatsHelpers(this).numericChunkRollup((C4SChunk)c, start, checksum) : (c instanceof C4FChunk ? new RollupStatsHelpers(this).numericChunkRollup((C4FChunk)c, start, checksum) : (c instanceof C4Chunk ? new RollupStatsHelpers(this).numericChunkRollup((C4Chunk)c, start, checksum) : (c instanceof C8Chunk ? new RollupStatsHelpers(this).numericChunkRollup((C8Chunk)c, start, checksum) : (c instanceof C8DChunk ? new RollupStatsHelpers(this).numericChunkRollup((C8DChunk)c, start, checksum) : new RollupStatsHelpers(this).numericChunkRollup(c, start, checksum))))))))));
            if (c.isSparseZero() && (zeros = c._len - c.sparseLenZero()) > 0) {
                for (int i = 0; i < Math.min(this._mins.length, zeros); ++i) {
                    this.min(0.0);
                    this.max(0.0);
                }
                double zeromean = 0.0;
                double zeroM2 = 0.0;
                double delta = this._mean - zeromean;
                this._mean = (this._mean * (double)this._rows + zeromean * (double)zeros) / (double)(this._rows + (long)zeros);
                this._sigma += zeroM2 + delta * delta * (double)this._rows * (double)zeros / (double)(this._rows + (long)zeros);
                this._rows += (long)zeros;
            }
        }
        this._checksum = checksum;
        if (isUUID || isString) {
            Arrays.fill(this._mins, Double.NaN);
            Arrays.fill(this._maxs, Double.NaN);
            this._sigma = Double.NaN;
            this._mean = Double.NaN;
        }
        return this;
    }

    private void reduce(RollupStats rs) {
        for (double d : rs._mins) {
            if (Double.isNaN(d)) continue;
            this.min(d);
        }
        for (double d : rs._maxs) {
            if (Double.isNaN(d)) continue;
            this.max(d);
        }
        this._naCnt += rs._naCnt;
        this._nzCnt += rs._nzCnt;
        this._pinfs += rs._pinfs;
        this._ninfs += rs._ninfs;
        if (this._rows == 0L) {
            this._mean = rs._mean;
            this._sigma = rs._sigma;
        } else if (rs._rows != 0L) {
            double delta = this._mean - rs._mean;
            this._mean = (this._mean * (double)this._rows + rs._mean * (double)rs._rows) / (double)(this._rows + rs._rows);
            this._sigma += rs._sigma + delta * delta * (double)this._rows * (double)rs._rows / (double)(this._rows + rs._rows);
        }
        this._rows += rs._rows;
        this._size += rs._size;
        this._isInt &= rs._isInt;
        this._checksum ^= rs._checksum;
    }

    double min(double d) {
        assert (!Double.isNaN(d));
        for (int i = 0; i < this._mins.length; ++i) {
            if (!(d < this._mins[i])) continue;
            double tmp = this._mins[i];
            this._mins[i] = d;
            d = tmp;
        }
        return this._mins[this._mins.length - 1];
    }

    double max(double d) {
        assert (!Double.isNaN(d));
        for (int i = 0; i < this._maxs.length; ++i) {
            if (!(d > this._maxs[i])) continue;
            double tmp = this._maxs[i];
            this._maxs[i] = d;
            d = tmp;
        }
        return this._maxs[this._maxs.length - 1];
    }

    static void start(Vec vec, Futures fs, boolean computeHisto) {
        Key rskey;
        RollupStats rs;
        if (vec instanceof InteractionWrappedVec) {
            return;
        }
        if (DKV.get(vec._key) == null) {
            throw new RuntimeException("Rollups not possible, because Vec was deleted: " + vec._key);
        }
        if (vec.isString()) {
            computeHisto = false;
        }
        if ((rs = RollupStats.getOrNull(vec, rskey = vec.rollupStatsKey())) == null || computeHisto && !rs.hasHisto()) {
            fs.add(new RPC<ComputeRollupsTask>(rskey.home_node(), new ComputeRollupsTask(vec, computeHisto)).addCompleter(new H2O.H2OCallback(){

                public void callback(H2O.H2OCountedCompleter h2OCountedCompleter) {
                    DKV.get(rskey);
                }
            }).call());
        }
    }

    static RollupStats get(Vec vec, boolean computeHisto) {
        if (DKV.get(vec._key) == null) {
            throw new RuntimeException("Rollups not possible, because Vec was deleted: " + vec._key);
        }
        if (vec.isString()) {
            computeHisto = false;
        }
        Key rskey = vec.rollupStatsKey();
        RollupStats rs = (RollupStats)DKV.getGet(rskey);
        while (rs == null || !rs.isReady() || computeHisto && !rs.hasHisto()) {
            if (rs != null && rs.isMutating()) {
                throw new IllegalArgumentException("Can not compute rollup stats while vec is being modified. (1)");
            }
            try {
                RPC<ComputeRollupsTask> rpcNew = new RPC<ComputeRollupsTask>(rskey.home_node(), new ComputeRollupsTask(vec, computeHisto));
                RPC<ComputeRollupsTask> rpcOld = _pendingRollups.putIfAbsent(rskey, rpcNew);
                if (rpcOld == null) {
                    rpcNew.call().get();
                    _pendingRollups.remove(rskey);
                } else {
                    rpcOld.get();
                }
            }
            catch (Throwable t) {
                System.err.println("Remote rollups failed with an exception, wrapping and rethrowing: " + t);
                throw new RuntimeException(t);
            }
            rs = (RollupStats)DKV.getGet(rskey);
        }
        return rs;
    }

    static RollupStats get(Vec vec) {
        return RollupStats.get(vec, false);
    }

    static RollupStats getOrNull(Vec vec, Key rskey) {
        Value val = DKV.get(rskey);
        if (val == null) {
            return vec.length() > 0L ? null : new RollupStats(0);
        }
        RollupStats rs = val.get(RollupStats.class);
        return rs.isReady() ? rs : null;
    }

    double h_base() {
        return this._mins[0];
    }

    double h_stride() {
        return this.h_stride(this._bins.length);
    }

    private double h_stride(int nbins) {
        return (this._maxs[0] - this._mins[0] + (double)(this._isInt ? 1 : 0)) / (double)nbins;
    }

    static final class ComputeRollupsTask
    extends DTask<ComputeRollupsTask> {
        final Key _vecKey;
        final Key _rsKey;
        final boolean _computeHisto;

        public ComputeRollupsTask(Vec v, boolean computeHisto) {
            super((byte)(Thread.currentThread() instanceof H2O.FJWThr ? ComputeRollupsTask.currThrPriority() + 1 : 116));
            this._vecKey = v._key;
            this._rsKey = v.rollupStatsKey();
            this._computeHisto = computeHisto;
        }

        private Value makeComputing() {
            RollupStats newRs = RollupStats.makeComputing();
            CountedCompleter cc = this.getCompleter();
            if (cc != null) assert (cc.getCompleter() == null);
            newRs._tsk = cc == null ? this : cc;
            return new Value(this._rsKey, (Freezable)newRs);
        }

        private void installResponse(Value nnn, RollupStats rs) {
            Futures fs = new Futures();
            Value old = DKV.DputIfMatch(this._rsKey, new Value(this._rsKey, (Freezable)rs), nnn, fs);
            assert (rs.isReady());
            if (old != nnn) {
                throw new IllegalArgumentException("Can not compute rollup stats while vec is being modified. (2)");
            }
            fs.blockForPending();
        }

        @Override
        public void compute2() {
            block12: {
                Value nnn;
                assert (this._rsKey.home());
                Vec vec = (Vec)DKV.getGet(this._vecKey);
                while (true) {
                    Value v;
                    RollupStats rs;
                    RollupStats rollupStats = rs = (v = DKV.get(this._rsKey)) == null ? null : (RollupStats)v.get();
                    if (rs != null) {
                        if (rs.isReady()) {
                            if (this._computeHisto && !rs.hasHisto()) {
                                CountedCompleter cc = this.getCompleter();
                                if (cc != null) assert (cc.getCompleter() == null);
                                Value nnn2 = this.makeComputing();
                                Futures fs = new Futures();
                                Value oldv = DKV.DputIfMatch(this._rsKey, nnn2, v, fs);
                                fs.blockForPending();
                                if (oldv != v) continue;
                                this.computeHisto(rs, vec, nnn2);
                            }
                            break block12;
                        }
                        if (rs.isComputing()) {
                            rs._tsk.join();
                            continue;
                        }
                        if (!rs.isMutating()) continue;
                        throw new IllegalArgumentException("Can not compute rollup stats while vec is being modified. (3)");
                    }
                    nnn = this.makeComputing();
                    Futures fs = new Futures();
                    Value oldv = DKV.DputIfMatch(this._rsKey, nnn, v, fs);
                    fs.blockForPending();
                    if (oldv == v) break;
                }
                try {
                    Roll r = (Roll)new Roll(null, this._rsKey).doAll(vec);
                    r._rs._checksum ^= vec.length();
                    if (this._computeHisto) {
                        this.computeHisto(r._rs, vec, nnn);
                    } else {
                        this.installResponse(nnn, r._rs);
                    }
                }
                catch (Exception e) {
                    Log.err(e);
                    if (this.cleanupStats(nnn)) {
                        throw e;
                    }
                    throw new IllegalStateException("Unable to clean up RollupStats after an exception (see cause). This could cause a key leakage, key=" + this._rsKey, e);
                }
            }
            this.tryComplete();
        }

        private boolean cleanupStats(Value current) {
            Futures fs = new Futures();
            Value old = DKV.DputIfMatch(this._rsKey, null, current, fs);
            boolean success = old != current;
            fs.blockForPending();
            return success;
        }

        final void computeHisto(RollupStats rs, Vec vec, Value nnn) {
            if (rs._naCnt == vec.length() || vec.isUUID()) {
                rs._bins = new long[0];
                this.installResponse(nnn, rs);
                return;
            }
            double span = rs._maxs[0] - rs._mins[0];
            long rows = vec.length() - rs._naCnt;
            assert (rows > 0L) : "rows = " + rows + ", vec.len() = " + vec.length() + ", naCnt = " + rs._naCnt;
            if (span == 0.0) {
                rs._bins = new long[]{rows};
                this.installResponse(nnn, rs);
                return;
            }
            int nbins = 1000;
            if (rs._isInt && span < 2.147483647E9) {
                nbins = (int)span + 1;
                int lim = vec.isCategorical() ? 10000000 : 1000;
                nbins = Math.min(lim, nbins);
            }
            Histo histo = (Histo)new Histo(null, rs, nbins).doAll(vec);
            assert (ArrayUtils.sum(histo._bins) == rows);
            rs._bins = histo._bins;
            rs._pctiles = new double[Vec.PERCENTILES.length];
            int j = 0;
            int k = 0;
            long hsum = 0L;
            double base = rs.h_base();
            double stride = rs.h_stride();
            double lastP = -1.0;
            for (int i = 0; i < Vec.PERCENTILES.length; ++i) {
                double P = Vec.PERCENTILES[i];
                assert (P >= 0.0 && P <= 1.0 && P >= lastP);
                lastP = P;
                double pdouble = 1.0 + P * (double)(rows - 1L);
                long pint = (long)pdouble;
                double h = pdouble - (double)pint;
                assert (P != 1.0 || h == 0.0 && pint == rows);
                while (hsum < pint) {
                    hsum += rs._bins[j++];
                }
                rs._pctiles[i] = base + stride * (double)(j - 1);
                if (!(h > 0.0) || pint != hsum) continue;
                if (k < j) {
                    k = j;
                }
                while (rs._bins[k] == 0L) {
                    ++k;
                }
                int n = i;
                rs._pctiles[n] = rs._pctiles[n] + h * stride * (double)(k - j + 1);
            }
            this.installResponse(nnn, rs);
        }
    }

    private static class Histo
    extends MRTask<Histo> {
        final double _base;
        final double _stride;
        final int _nbins;
        long[] _bins;

        Histo(H2O.H2OCountedCompleter cmp, RollupStats rs, int nbins) {
            super(cmp);
            this._base = rs.h_base();
            this._stride = rs.h_stride(nbins);
            this._nbins = nbins;
        }

        @Override
        public void map(Chunk c) {
            this._bins = new long[this._nbins];
            int i = c.nextNZ(-1);
            while (i < c._len) {
                double d = c.atd(i);
                if (!Double.isNaN(d)) {
                    int n = this.idx(d);
                    this._bins[n] = this._bins[n] + 1L;
                }
                i = c.nextNZ(i);
            }
            if (c.isSparseZero()) {
                int n = this.idx(0.0);
                this._bins[n] = this._bins[n] + (long)(c._len - c.sparseLenZero());
            }
        }

        private int idx(double d) {
            int idx = (int)((d - this._base) / this._stride);
            return Math.min(idx, this._bins.length - 1);
        }

        @Override
        public void reduce(Histo h) {
            ArrayUtils.add(this._bins, h._bins);
        }

        @Override
        public boolean logVerbose() {
            return false;
        }
    }

    private static class Roll
    extends MRTask<Roll> {
        final Key _rskey;
        RollupStats _rs;

        @Override
        protected boolean modifiesVolatileVecs() {
            return false;
        }

        Roll(H2O.H2OCountedCompleter cmp, Key rskey) {
            super(cmp);
            this._rskey = rskey;
        }

        @Override
        public void map(Chunk c) {
            this._rs = new RollupStats(0).map(c);
        }

        @Override
        public void reduce(Roll roll) {
            this._rs.reduce(roll._rs);
        }

        @Override
        public void postGlobal() {
            if (this._rs == null) {
                this._rs = new RollupStats(0);
            } else {
                this._rs._sigma = Math.sqrt(this._rs._sigma / (double)(this._rs._rows - 1L));
                if (this._rs._rows == 1L) {
                    this._rs._sigma = 0.0;
                }
                if (this._rs._rows < 5L) {
                    int i = 0;
                    while ((long)i < 5L - this._rs._rows) {
                        this._rs._maxs[4 - i] = Double.NaN;
                        this._rs._mins[4 - i] = Double.NaN;
                        ++i;
                    }
                }
            }
            Vec vec = this._fr.anyVec();
            String[] ss = vec.domain();
            if (vec.isCategorical() && ss.length > 2) {
                this._rs._sigma = Double.NaN;
                this._rs._mean = Double.NaN;
            }
            if (ss != null) {
                long dsz = (3 + ss.length) * 8;
                for (String s : vec.domain()) {
                    if (s == null) continue;
                    dsz += (long)(2 * s.length() + 56);
                }
                this._rs._size += dsz;
                int keysize = 56 + vec._key._kb.length;
                this._rs._size += (long)(vec.nChunks() * (keysize * 4));
            }
        }

        @Override
        public boolean logVerbose() {
            return false;
        }

        public String toString() {
            return "Roll(" + this._fr.anyVec()._key + ")";
        }
    }
}

