/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.Arrays;
import water.DKV;
import water.DTask;
import water.Futures;
import water.H2O;
import water.H2ONode;
import water.Iced;
import water.Key;
import water.MemoryManager;
import water.RPC;
import water.Value;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.SingleThreadRadixOrder;
import water.rapids.SplitByMSBLocal;
import water.util.ArrayUtils;

class BinaryMerge
extends DTask<BinaryMerge> {
    long _numRowsInResult = 0L;
    int[] _chunkSizes;
    double[] _timings;
    private transient long[][] _ret1st;
    private transient long[][] _retLen;
    final FFSB _leftSB;
    final FFSB _riteSB;
    private transient KeyOrder _leftKO;
    private transient KeyOrder _riteKO;
    private final int _numJoinCols;
    private transient long _leftFrom;
    private transient int _retBatchSize;
    private final boolean _allLeft;
    private final boolean _allRight;
    private transient boolean _oneToManyMatch = false;

    BinaryMerge(FFSB leftSB, FFSB riteSB, boolean allLeft) {
        assert (riteSB._msb != -1 || allLeft);
        this._leftSB = leftSB;
        this._riteSB = riteSB;
        this._numJoinCols = Math.min(this._leftSB._fieldSizes.length, this._riteSB._fieldSizes.length);
        this._allLeft = allLeft;
        this._allRight = false;
    }

    @Override
    public void compute2() {
        this._timings = new double[20];
        long t0 = System.nanoTime();
        SingleThreadRadixOrder.OXHeader leftSortedOXHeader = (SingleThreadRadixOrder.OXHeader)DKV.getGet(SingleThreadRadixOrder.getSortedOXHeaderKey(true, this._leftSB._msb));
        if (leftSortedOXHeader == null) {
            if (!this._allRight) {
                this.tryComplete();
                return;
            }
            throw H2O.unimpl();
        }
        this._leftKO = new KeyOrder(leftSortedOXHeader);
        SingleThreadRadixOrder.OXHeader rightSortedOXHeader = (SingleThreadRadixOrder.OXHeader)DKV.getGet(SingleThreadRadixOrder.getSortedOXHeaderKey(false, this._riteSB._msb));
        if (rightSortedOXHeader == null) {
            if (!this._allLeft) {
                this.tryComplete();
                return;
            }
            rightSortedOXHeader = new SingleThreadRadixOrder.OXHeader(0, 0L, 0);
        }
        this._riteKO = new KeyOrder(rightSortedOXHeader);
        this._leftKO.initKeyOrder(this._leftSB._msb, true);
        long leftN = leftSortedOXHeader._numRows;
        assert (leftN >= 1L);
        this._riteKO.initKeyOrder(this._riteSB._msb, false);
        long rightN = rightSortedOXHeader._numRows;
        this._timings[0] = this._timings[0] + (double)(System.nanoTime() - t0) / 1.0E9;
        long leftMin = this._leftSB.min();
        long leftMax = this._leftSB.max();
        long riteMin = this._riteSB._msb == -1 ? -1L : this._riteSB.min();
        long riteMax = this._riteSB._msb == -1 ? -1L : this._riteSB.max();
        this._leftFrom = this._riteSB._msb == -1 || leftMin >= riteMin || this._allLeft && this._riteSB._msb == 0 ? -1L : this.bsearchLeft(riteMin, true, leftN);
        long leftTo = this._riteSB._msb == -1 || leftMax <= riteMax || this._allLeft && this._riteSB._msb == 255 ? leftN : this.bsearchLeft(riteMax, false, leftN);
        long retSize = leftTo - this._leftFrom - 1L;
        assert (retSize >= 0L);
        if (retSize == 0L) {
            this.tryComplete();
            return;
        }
        this._retBatchSize = 0x10000000;
        int retNBatch = (int)((retSize - 1L) / (long)this._retBatchSize + 1L);
        int retLastSize = (int)(retSize - (long)((retNBatch - 1) * this._retBatchSize));
        this._ret1st = new long[retNBatch][];
        this._retLen = new long[retNBatch][];
        for (int b = 0; b < retNBatch; ++b) {
            this._ret1st[b] = MemoryManager.malloc8(b == retNBatch - 1 ? retLastSize : this._retBatchSize);
            this._retLen[b] = MemoryManager.malloc8(b == retNBatch - 1 ? retLastSize : this._retBatchSize);
        }
        t0 = System.nanoTime();
        this.bmerge_r(this._leftFrom, leftTo, -1L, rightN);
        this._timings[1] = this._timings[1] + (double)(System.nanoTime() - t0) / 1.0E9;
        if (this._allLeft) {
            assert (this._leftKO.numRowsToFetch() == retSize);
        } else {
            long tt = 0L;
            long[][] arr$ = this._ret1st;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                long[] retFirstx;
                for (long rF : retFirstx = arr$[i$]) {
                    tt += rF > 0L ? 1L : 0L;
                }
            }
            assert (tt <= retSize);
            assert (this._leftKO.numRowsToFetch() == tt);
        }
        if (this._numRowsInResult > 0L) {
            this.createChunksInDKV();
        }
        this.tryComplete();
    }

    private int keycmp(byte[][] xss, long xi, byte[][] yss, long yi) {
        byte[] xbatch = xss[(int)(xi / this._leftKO._batchSize)];
        byte[] ybatch = yss[(int)(yi / this._riteKO._batchSize)];
        int xoff = (int)(xi % this._leftKO._batchSize) * this._leftSB._keySize;
        int yoff = (int)(yi % this._riteKO._batchSize) * this._riteSB._keySize;
        long xval = 0L;
        long yval = 0L;
        for (int i = 0; i < this._numJoinCols && xval == yval; ++i) {
            int ylen = this._riteSB._fieldSizes[i];
            xval = (long)xbatch[xoff] & 0xFFL;
            for (int xlen = this._leftSB._fieldSizes[i]; xlen > 1; --xlen) {
                xval <<= 8;
                xval |= (long)xbatch[++xoff] & 0xFFL;
            }
            ++xoff;
            yval = (long)ybatch[yoff] & 0xFFL;
            while (ylen > 1) {
                yval <<= 8;
                yval |= (long)ybatch[++yoff] & 0xFFL;
                --ylen;
            }
            ++yoff;
            xval = xval == 0L ? Long.MIN_VALUE : xval - 1L + this._leftSB._base[i];
            yval = yval == 0L ? Long.MIN_VALUE : yval - 1L + this._riteSB._base[i];
        }
        long diff = xval - yval;
        if (xval > yval) {
            return diff < 0L | diff > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)diff;
        }
        return diff > 0L | diff < -2147483647L ? -2147483647 : (int)diff;
    }

    private long bsearchLeft(long x, boolean returnLow, long upp) {
        long low = -1L;
        while (low < upp - 1L) {
            long mid = low + (upp - low) / 2L;
            byte[] keyBatch = this._leftKO._key[(int)(mid / this._leftKO._batchSize)];
            int off = (int)(mid % this._leftKO._batchSize) * this._leftSB._keySize;
            long val = (long)keyBatch[off] & 0xFFL;
            for (int len = this._leftSB._fieldSizes[0]; len > 1; --len) {
                val <<= 8;
                val |= (long)keyBatch[++off] & 0xFFL;
            }
            long l = val = val == 0L ? Long.MIN_VALUE : val - 1L + this._leftSB._base[0];
            if (x < val || x == val && returnLow) {
                upp = mid;
                continue;
            }
            low = mid;
        }
        return returnLow ? low : upp;
    }

    private boolean leftKeyEqual(byte[][] x, long xi, long yi) {
        int i;
        byte[] xbatch = x[(int)(xi / this._leftKO._batchSize)];
        byte[] ybatch = x[(int)(yi / this._leftKO._batchSize)];
        int xoff = (int)(xi % this._leftKO._batchSize) * this._leftSB._keySize;
        int yoff = (int)(yi % this._leftKO._batchSize) * this._leftSB._keySize;
        for (i = 0; i < this._leftSB._keySize && xbatch[xoff++] == ybatch[yoff++]; ++i) {
        }
        return i == this._leftSB._keySize;
    }

    private void bmerge_r(long lLowIn, long lUppIn, long rLowIn, long rUppIn) {
        long tmpUpp;
        long tmpLow;
        long lLow = lLowIn;
        long lUpp = lUppIn;
        long rLow = rLowIn;
        long rUpp = rUppIn;
        long lr = lLow + (lUpp - lLow) / 2L;
        while (rLow < rUpp - 1L) {
            long mid = rLow + (rUpp - rLow) / 2L;
            int cmp = this.keycmp(this._leftKO._key, lr, this._riteKO._key, mid);
            if (cmp < 0) {
                rUpp = mid;
                continue;
            }
            if (cmp > 0) {
                rLow = mid;
                continue;
            }
            tmpLow = mid;
            tmpUpp = mid;
            while (tmpLow < rUpp - 1L) {
                mid = tmpLow + (rUpp - tmpLow) / 2L;
                if (this.keycmp(this._leftKO._key, lr, this._riteKO._key, mid) == 0) {
                    tmpLow = mid;
                    continue;
                }
                rUpp = mid;
            }
            while (rLow < tmpUpp - 1L) {
                mid = rLow + (tmpUpp - rLow) / 2L;
                if (this.keycmp(this._leftKO._key, lr, this._riteKO._key, mid) == 0) {
                    tmpUpp = mid;
                    continue;
                }
                rLow = mid;
            }
            break block0;
        }
        for (tmpLow = lr + 1L; tmpLow < lUpp && this.leftKeyEqual(this._leftKO._key, tmpLow, lr); ++tmpLow) {
        }
        lUpp = tmpLow;
        for (tmpUpp = lr - 1L; tmpUpp > lLow && this.leftKeyEqual(this._leftKO._key, tmpUpp, lr); --tmpUpp) {
        }
        lLow = tmpUpp;
        assert (lUpp - lLow >= 2L);
        long len = rUpp - rLow - 1L;
        if (len > 0L || this._allLeft) {
            long t0 = System.nanoTime();
            if (len > 1L) {
                this._oneToManyMatch = true;
            }
            this._numRowsInResult += Math.max(1L, len) * (lUpp - lLow - 1L);
            for (long j = lLow + 1L; j < lUpp; ++j) {
                long t00 = System.nanoTime();
                long globalRowNumber = this._leftKO.at8order(j);
                this._timings[17] = this._timings[17] + (double)(System.nanoTime() - t00) / 1.0E9;
                t00 = System.nanoTime();
                int chkIdx = this._leftSB._vec.elem2ChunkIdx(globalRowNumber);
                this._timings[15] = this._timings[15] + (double)(System.nanoTime() - t00) / 1.0E9;
                long[] lArray = this._leftKO._perNodeNumRowsToFetch;
                int n = this._leftSB._chunkNode[chkIdx];
                lArray[n] = lArray[n] + 1L;
                if (len == 0L) continue;
                long outLoc = j - (this._leftFrom + 1L);
                int jb2 = (int)(outLoc / (long)this._retBatchSize);
                int jo2 = (int)(outLoc % (long)this._retBatchSize);
                this._ret1st[jb2][jo2] = rLow + 2L;
                this._retLen[jb2][jo2] = len;
            }
            for (long i = 0L; i < len; ++i) {
                long loc = rLow + 1L + i;
                long t00 = System.nanoTime();
                long globalRowNumber = this._riteKO.at8order(loc);
                this._timings[18] = this._timings[18] + (double)(System.nanoTime() - t00) / 1.0E9;
                t00 = System.nanoTime();
                int chkIdx = this._riteSB._vec.elem2ChunkIdx(globalRowNumber);
                this._timings[16] = this._timings[16] + (double)(System.nanoTime() - t00) / 1.0E9;
                long[] lArray = this._riteKO._perNodeNumRowsToFetch;
                int n = this._riteSB._chunkNode[chkIdx];
                lArray[n] = lArray[n] + 1L;
            }
            this._timings[14] = this._timings[14] + (double)(System.nanoTime() - t0) / 1.0E9;
        }
        if (lLow > lLowIn && (rLow > rLowIn || this._allLeft)) {
            this.bmerge_r(lLowIn, lLow + 1L, rLowIn, rLow + 1L);
        }
        if (lUpp < lUppIn && (rUpp < rUppIn || this._allLeft)) {
            this.bmerge_r(lUpp - 1L, lUppIn, rUpp - 1L, rUppIn);
        }
    }

    private void createChunksInDKV() {
        long t0 = System.nanoTime();
        int cloudSize = H2O.CLOUD.size();
        long[][][] perNodeRightRows = new long[cloudSize][][];
        long[][][] perNodeLeftRows = new long[cloudSize][][];
        for (int i = 0; i < cloudSize; ++i) {
            perNodeRightRows[i] = this._riteKO.fillPerNodeRows(i);
            perNodeLeftRows[i] = this._leftKO.fillPerNodeRows(i);
        }
        long t1 = System.nanoTime();
        this._timings[2] = this._timings[2] + (double)(t1 - t0) / 1.0E9;
        t0 = t1;
        long[] perNodeRightLoc = new long[cloudSize];
        long[] perNodeLeftLoc = new long[cloudSize];
        this.chunksPopulatePerNode(perNodeLeftLoc, perNodeLeftRows, perNodeRightLoc, perNodeRightRows);
        t1 = System.nanoTime();
        this._timings[3] = this._timings[3] + (double)(t1 - t0) / 1.0E9;
        t0 = t1;
        int batchSizeUUID = 0x1000000;
        int nbatch = (int)((this._numRowsInResult - 1L) / 0x1000000L + 1L);
        assert (nbatch >= 1);
        int lastSize = (int)(this._numRowsInResult - (long)((nbatch - 1) * 0x1000000));
        assert (lastSize > 0);
        int numLeftCols = this._leftSB._frame.numCols();
        int numColsInResult = this._leftSB._frame.numCols() + this._riteSB._frame.numCols() - this._numJoinCols;
        double[][][] frameLikeChunks = new double[numColsInResult][nbatch][];
        this._chunkSizes = new int[nbatch];
        for (int col = 0; col < numColsInResult; ++col) {
            for (int b = 0; b < nbatch; ++b) {
                this._chunkSizes[b] = b == nbatch - 1 ? lastSize : 0x1000000;
                frameLikeChunks[col][b] = MemoryManager.malloc8d(this._chunkSizes[b]);
                Arrays.fill(frameLikeChunks[col][b], Double.NaN);
            }
        }
        t1 = System.nanoTime();
        this._timings[4] = this._timings[4] + (double)(t1 - t0) / 1.0E9;
        t0 = t1;
        GetRawRemoteRows[][] grrrsLeft = new GetRawRemoteRows[cloudSize][];
        GetRawRemoteRows[][] grrrsRite = new GetRawRemoteRows[cloudSize][];
        this.chunksGetRawRemoteRows(perNodeLeftRows, perNodeRightRows, grrrsLeft, grrrsRite);
        t1 = System.nanoTime();
        this._timings[6] = this._timings[6] + (double)(t1 - t0) / 1.0E9;
        t0 = t1;
        this.chunksPopulateRetFirst(numColsInResult, numLeftCols, perNodeLeftLoc, grrrsLeft, perNodeRightLoc, grrrsRite, frameLikeChunks);
        t1 = System.nanoTime();
        this._timings[10] = this._timings[10] + (double)(t1 - t0) / 1.0E9;
        t0 = t1;
        this.chunksCompressAndStore(nbatch, numColsInResult, frameLikeChunks);
        this._timings[11] = this._timings[11] + (double)(System.nanoTime() - t0) / 1.0E9;
    }

    private void chunksPopulatePerNode(long[] perNodeLeftLoc, long[][][] perNodeLeftRows, long[] perNodeRightLoc, long[][][] perNodeRightRows) {
        int batchSizeLong = 0x1000000;
        long prevf = -1L;
        long prevl = -1L;
        long leftLoc = this._leftFrom;
        for (int jb = 0; jb < this._ret1st.length; ++jb) {
            for (int jo = 0; jo < this._ret1st[jb].length; ++jo) {
                int ni;
                ++leftLoc;
                long f = this._ret1st[jb][jo];
                long l = this._retLen[jb][jo];
                if (f == 0L) {
                    assert (l == 0L);
                    if (!this._allLeft) continue;
                }
                long row = this._leftKO.at8order(leftLoc);
                int chkIdx = this._leftSB._vec.elem2ChunkIdx(row);
                int n = ni = this._leftSB._chunkNode[chkIdx];
                perNodeLeftLoc[n] = perNodeLeftLoc[n] + 1L;
                perNodeLeftRows[ni][(int)(pnl / 0x1000000L)][(int)(pnl % 0x1000000L)] = row;
                if (f == 0L) continue;
                assert (l > 0L);
                if (prevf == f && prevl == l) continue;
                prevf = f;
                prevl = l;
                int r = 0;
                while ((long)r < l) {
                    int ni2;
                    long loc = f + (long)r - 1L;
                    long row2 = this._riteKO.at8order(loc);
                    int chkIdx2 = this._riteSB._vec.elem2ChunkIdx(row2);
                    int n2 = ni2 = this._riteSB._chunkNode[chkIdx2];
                    perNodeRightLoc[n2] = perNodeRightLoc[n2] + 1L;
                    perNodeRightRows[ni2][(int)(pnl / 0x1000000L)][(int)(pnl % 0x1000000L)] = row2;
                    ++r;
                }
            }
        }
        Arrays.fill(perNodeLeftLoc, 0L);
        Arrays.fill(perNodeRightLoc, 0L);
    }

    private void chunksGetRawRemoteRows(long[][][] perNodeLeftRows, long[][][] perNodeRightRows, GetRawRemoteRows[][] grrrsLeft, GetRawRemoteRows[][] grrrsRite) {
        int b;
        int bUppLeft;
        int bUppRite;
        int ni;
        RPC[][] grrrsRiteRPC = new RPC[H2O.CLOUD.size()][];
        RPC[][] grrrsLeftRPC = new RPC[H2O.CLOUD.size()][];
        for (H2ONode node : H2O.CLOUD._memary) {
            ni = node.index();
            bUppRite = perNodeRightRows[ni] == null ? 0 : perNodeRightRows[ni].length;
            bUppLeft = perNodeLeftRows[ni] == null ? 0 : perNodeLeftRows[ni].length;
            grrrsRiteRPC[ni] = new RPC[bUppRite];
            grrrsLeftRPC[ni] = new RPC[bUppLeft];
            grrrsRite[ni] = new GetRawRemoteRows[bUppRite];
            grrrsLeft[ni] = new GetRawRemoteRows[bUppLeft];
            for (b = 0; b < bUppRite; ++b) {
                grrrsRiteRPC[ni][b] = new RPC<GetRawRemoteRows>(node, new GetRawRemoteRows(this._riteSB._frame, perNodeRightRows[ni][b])).call();
            }
            for (b = 0; b < bUppLeft; ++b) {
                grrrsLeftRPC[ni][b] = new RPC<GetRawRemoteRows>(node, new GetRawRemoteRows(this._leftSB._frame, perNodeLeftRows[ni][b])).call();
            }
        }
        for (H2ONode node : H2O.CLOUD._memary) {
            ni = node.index();
            bUppRite = perNodeRightRows[ni] == null ? 0 : perNodeRightRows[ni].length;
            for (int b2 = 0; b2 < bUppRite; ++b2) {
                GetRawRemoteRows getRawRemoteRows = (GetRawRemoteRows)grrrsRiteRPC[ni][b2].get();
                grrrsRite[ni][b2] = getRawRemoteRows;
                this._timings[5] = this._timings[5] + getRawRemoteRows.timeTaken;
            }
            bUppLeft = perNodeLeftRows[ni] == null ? 0 : perNodeLeftRows[ni].length;
            for (b = 0; b < bUppLeft; ++b) {
                GetRawRemoteRows getRawRemoteRows = (GetRawRemoteRows)grrrsLeftRPC[ni][b].get();
                grrrsLeft[ni][b] = getRawRemoteRows;
                this._timings[5] = this._timings[5] + getRawRemoteRows.timeTaken;
            }
        }
    }

    private void chunksPopulateRetFirst(int numColsInResult, int numLeftCols, long[] perNodeLeftLoc, GetRawRemoteRows[][] grrrsLeft, long[] perNodeRightLoc, GetRawRemoteRows[][] grrrsRite, double[][][] frameLikeChunks) {
        int batchSizeUUID = 0x1000000;
        long resultLoc = 0L;
        long leftLoc = this._leftFrom;
        long prevf = -1L;
        long prevl = -1L;
        for (int jb = 0; jb < this._ret1st.length; ++jb) {
            for (int jo = 0; jo < this._ret1st[jb].length; ++jo) {
                int r;
                int col;
                long pnl;
                int ni;
                ++leftLoc;
                long f = this._ret1st[jb][jo];
                long l = this._retLen[jb][jo];
                if (f == 0L && !this._allLeft) continue;
                long row = this._leftKO.at8order(leftLoc);
                int chkIdx = this._leftSB._vec.elem2ChunkIdx(row);
                int n = ni = this._leftSB._chunkNode[chkIdx];
                perNodeLeftLoc[n] = perNodeLeftLoc[n] + 1L;
                int b = (int)(pnl / 0x1000000L);
                int o = (int)(pnl % 0x1000000L);
                double[][] chks = grrrsLeft[ni][b]._chk;
                int l1 = Math.max((int)l, 1);
                for (int rep = 0; rep < l1; ++rep) {
                    long a = resultLoc + (long)rep;
                    int whichChunk = (int)(a / 0x1000000L);
                    int offset = (int)(a % 0x1000000L);
                    for (col = 0; col < chks.length; ++col) {
                        frameLikeChunks[col][whichChunk][offset] = chks[col][o];
                    }
                }
                if (f == 0L) {
                    ++resultLoc;
                    continue;
                }
                assert (l > 0L);
                if (prevf == f && prevl == l) {
                    r = 0;
                    while ((long)r < l) {
                        int toChunk = (int)(resultLoc / 0x1000000L);
                        int toOffset = (int)(resultLoc % 0x1000000L);
                        int fromChunk = (int)((resultLoc - l) / 0x1000000L);
                        int fromOffset = (int)((resultLoc - l) % 0x1000000L);
                        for (col = 0; col < numColsInResult - numLeftCols; ++col) {
                            frameLikeChunks[numLeftCols + col][toChunk][toOffset] = frameLikeChunks[numLeftCols + col][fromChunk][fromOffset];
                        }
                        ++resultLoc;
                        ++r;
                    }
                    continue;
                }
                prevf = f;
                prevl = l;
                r = 0;
                while ((long)r < l) {
                    int whichChunk = (int)(resultLoc / 0x1000000L);
                    int offset = (int)(resultLoc % 0x1000000L);
                    long loc = f + (long)r - 1L;
                    row = this._riteKO.at8order(loc);
                    chkIdx = this._riteSB._vec.elem2ChunkIdx(row);
                    int n2 = ni = this._riteSB._chunkNode[chkIdx];
                    perNodeRightLoc[n2] = perNodeRightLoc[n2] + 1L;
                    chks = grrrsRite[ni][(int)(pnl / 0x1000000L)]._chk;
                    o = (int)(pnl % 0x1000000L);
                    for (col = 0; col < numColsInResult - numLeftCols; ++col) {
                        frameLikeChunks[numLeftCols + col][whichChunk][offset] = chks[this._numJoinCols + col][o];
                    }
                    ++resultLoc;
                    ++r;
                }
            }
        }
    }

    private void chunksCompressAndStore(int nbatch, int numColsInResult, double[][][] frameLikeChunks) {
        Futures fs = new Futures();
        for (int col = 0; col < numColsInResult; ++col) {
            for (int b = 0; b < nbatch; ++b) {
                Chunk ck = new NewChunk(frameLikeChunks[col][b]).compress();
                DKV.put(BinaryMerge.getKeyForMSBComboPerCol(this._leftSB._msb, this._riteSB._msb, col, b), ck, fs, true);
                frameLikeChunks[col][b] = null;
            }
        }
        fs.blockForPending();
    }

    static Key getKeyForMSBComboPerCol(int leftMSB, int rightMSB, int col, int batch) {
        return Key.make("__binary_merge__Chunk_for_col" + col + "_batch" + batch + "_leftSB._msb" + leftMSB + "_riteSB._msb" + rightMSB, (byte)1, (byte)31, false, SplitByMSBLocal.ownerOfMSB(rightMSB == -1 ? leftMSB : rightMSB));
    }

    static class GetRawRemoteRows
    extends DTask<GetRawRemoteRows> {
        Frame _fr;
        long[] _rows;
        double[][] _chk;
        double timeTaken;

        GetRawRemoteRows(Frame fr, long[] rows) {
            this._rows = rows;
            this._fr = fr;
        }

        @Override
        public void compute2() {
            assert (this._rows != null);
            assert (this._chk == null);
            long t0 = System.nanoTime();
            this._chk = MemoryManager.malloc8d(this._fr.numCols(), this._rows.length);
            int[] cidx = MemoryManager.malloc4(this._rows.length);
            int[] offset = MemoryManager.malloc4(this._rows.length);
            Vec anyVec = this._fr.anyVec();
            assert (anyVec != null);
            for (int row = 0; row < this._rows.length; ++row) {
                cidx[row] = anyVec.elem2ChunkIdx(this._rows[row]);
                offset[row] = (int)(this._rows[row] - anyVec.espc()[cidx[row]]);
            }
            Chunk[] c = new Chunk[anyVec.nChunks()];
            for (int col = 0; col < this._fr.numCols(); ++col) {
                Vec v = this._fr.vec(col);
                for (int i = 0; i < c.length; ++i) {
                    c[i] = v.chunkKey(i).home() ? v.chunkForChunkIdx(i) : null;
                }
                for (int row = 0; row < this._rows.length; ++row) {
                    this._chk[col][row] = c[cidx[row]].atd(offset[row]);
                }
            }
            this._rows = null;
            this._fr = null;
            assert (this._chk != null);
            this.timeTaken = (double)(System.nanoTime() - t0) / 1.0E9;
            this.tryComplete();
        }
    }

    private static class KeyOrder {
        private final transient long _batchSize;
        private final transient byte[][] _key;
        private final transient long[][] _order;
        private final transient long[] _perNodeNumRowsToFetch;

        KeyOrder(SingleThreadRadixOrder.OXHeader sortedOXHeader) {
            this._batchSize = sortedOXHeader._batchSize;
            int nBatch = sortedOXHeader._nBatch;
            this._key = new byte[nBatch][];
            this._order = new long[nBatch][];
            this._perNodeNumRowsToFetch = new long[H2O.CLOUD.size()];
        }

        void initKeyOrder(int msb, boolean isLeft) {
            for (int b = 0; b < this._key.length; ++b) {
                Value v = DKV.get(SplitByMSBLocal.getSortedOXbatchKey(isLeft, msb, b));
                SplitByMSBLocal.OXbatch ox = (SplitByMSBLocal.OXbatch)v.get();
                v.freeMem();
                this._key[b] = ox._x;
                this._order[b] = ox._o;
            }
        }

        long numRowsToFetch() {
            return ArrayUtils.sum(this._perNodeNumRowsToFetch);
        }

        long at8order(long idx) {
            return this._order[(int)(idx / this._batchSize)][(int)(idx % this._batchSize)];
        }

        long[][] fillPerNodeRows(int i) {
            int batchSizeLong = 0x1000000;
            if (this._perNodeNumRowsToFetch[i] <= 0L) {
                return null;
            }
            int nbatch = (int)((this._perNodeNumRowsToFetch[i] - 1L) / 0x1000000L + 1L);
            assert (nbatch >= 1);
            int lastSize = (int)(this._perNodeNumRowsToFetch[i] - (long)((nbatch - 1) * 0x1000000));
            assert (lastSize > 0);
            long[][] res = new long[nbatch][];
            for (int b = 0; b < nbatch; ++b) {
                res[b] = MemoryManager.malloc8(b == nbatch - 1 ? lastSize : 0x1000000);
            }
            return res;
        }
    }

    static class FFSB
    extends Iced<FFSB> {
        private final Frame _frame;
        private final Vec _vec;
        private final int[] _chunkNode;
        final int _msb;
        private final int _shift;
        private final long[] _base;
        private final int[] _fieldSizes;
        private final int _keySize;

        FFSB(Frame frame, int msb, int shift, int[] fieldSizes, long[] base) {
            assert (-1 <= msb && msb <= 255);
            this._frame = frame;
            this._msb = msb;
            this._shift = shift;
            this._fieldSizes = fieldSizes;
            this._keySize = ArrayUtils.sum(fieldSizes);
            this._base = base;
            this._vec = frame.anyVec();
            Vec vec = this._vec;
            int[] nArray = this._chunkNode = vec == null ? null : new int[vec.nChunks()];
            if (vec == null) {
                return;
            }
            for (int i = 0; i < this._chunkNode.length; ++i) {
                this._chunkNode[i] = vec.chunkKey(i).home_node().index();
            }
        }

        long min() {
            return ((long)this._msb << this._shift) + this._base[0] - 1L;
        }

        long max() {
            return ((long)this._msb + 1L << this._shift) + this._base[0] - 2L;
        }
    }
}

