/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import water.DKV;
import water.Futures;
import water.Iced;
import water.Key;
import water.Value;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.Session;
import water.rapids.Val;
import water.rapids.ast.AstFunction;
import water.rapids.ast.AstParameter;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.params.AstConst;
import water.rapids.ast.prims.advmath.AstCorrelation;
import water.rapids.ast.prims.advmath.AstHist;
import water.rapids.ast.prims.advmath.AstImpute;
import water.rapids.ast.prims.advmath.AstKFold;
import water.rapids.ast.prims.advmath.AstKurtosis;
import water.rapids.ast.prims.advmath.AstMode;
import water.rapids.ast.prims.advmath.AstModuloKFold;
import water.rapids.ast.prims.advmath.AstQtile;
import water.rapids.ast.prims.advmath.AstRunif;
import water.rapids.ast.prims.advmath.AstSkewness;
import water.rapids.ast.prims.advmath.AstStratifiedKFold;
import water.rapids.ast.prims.advmath.AstStratifiedSplit;
import water.rapids.ast.prims.advmath.AstTable;
import water.rapids.ast.prims.advmath.AstUnique;
import water.rapids.ast.prims.advmath.AstVariance;
import water.rapids.ast.prims.assign.AstAppend;
import water.rapids.ast.prims.assign.AstAssign;
import water.rapids.ast.prims.assign.AstRectangleAssign;
import water.rapids.ast.prims.assign.AstRm;
import water.rapids.ast.prims.assign.AstTmpAssign;
import water.rapids.ast.prims.math.AstAbs;
import water.rapids.ast.prims.math.AstAcos;
import water.rapids.ast.prims.math.AstAcosh;
import water.rapids.ast.prims.math.AstAsin;
import water.rapids.ast.prims.math.AstAsinh;
import water.rapids.ast.prims.math.AstAtan;
import water.rapids.ast.prims.math.AstAtanh;
import water.rapids.ast.prims.math.AstCeiling;
import water.rapids.ast.prims.math.AstCos;
import water.rapids.ast.prims.math.AstCosPi;
import water.rapids.ast.prims.math.AstCosh;
import water.rapids.ast.prims.math.AstDiGamma;
import water.rapids.ast.prims.math.AstExp;
import water.rapids.ast.prims.math.AstExpm1;
import water.rapids.ast.prims.math.AstFloor;
import water.rapids.ast.prims.math.AstGamma;
import water.rapids.ast.prims.math.AstLGamma;
import water.rapids.ast.prims.math.AstLog;
import water.rapids.ast.prims.math.AstLog10;
import water.rapids.ast.prims.math.AstLog1P;
import water.rapids.ast.prims.math.AstLog2;
import water.rapids.ast.prims.math.AstNoOp;
import water.rapids.ast.prims.math.AstNot;
import water.rapids.ast.prims.math.AstRound;
import water.rapids.ast.prims.math.AstSgn;
import water.rapids.ast.prims.math.AstSignif;
import water.rapids.ast.prims.math.AstSin;
import water.rapids.ast.prims.math.AstSinPi;
import water.rapids.ast.prims.math.AstSinh;
import water.rapids.ast.prims.math.AstSqrt;
import water.rapids.ast.prims.math.AstTan;
import water.rapids.ast.prims.math.AstTanPi;
import water.rapids.ast.prims.math.AstTanh;
import water.rapids.ast.prims.math.AstTriGamma;
import water.rapids.ast.prims.math.AstTrunc;
import water.rapids.ast.prims.matrix.AstMMult;
import water.rapids.ast.prims.matrix.AstTranspose;
import water.rapids.ast.prims.misc.AstComma;
import water.rapids.ast.prims.misc.AstLs;
import water.rapids.ast.prims.mungers.AstAnyFactor;
import water.rapids.ast.prims.mungers.AstApply;
import water.rapids.ast.prims.mungers.AstAsCharacter;
import water.rapids.ast.prims.mungers.AstAsFactor;
import water.rapids.ast.prims.mungers.AstAsNumeric;
import water.rapids.ast.prims.mungers.AstCBind;
import water.rapids.ast.prims.mungers.AstColNames;
import water.rapids.ast.prims.mungers.AstColPySlice;
import water.rapids.ast.prims.mungers.AstColSlice;
import water.rapids.ast.prims.mungers.AstColumnsByType;
import water.rapids.ast.prims.mungers.AstCut;
import water.rapids.ast.prims.mungers.AstDdply;
import water.rapids.ast.prims.mungers.AstFilterNaCols;
import water.rapids.ast.prims.mungers.AstFlatten;
import water.rapids.ast.prims.mungers.AstGetrow;
import water.rapids.ast.prims.mungers.AstGroup;
import water.rapids.ast.prims.mungers.AstGroupedPermute;
import water.rapids.ast.prims.mungers.AstIsCharacter;
import water.rapids.ast.prims.mungers.AstIsFactor;
import water.rapids.ast.prims.mungers.AstIsNa;
import water.rapids.ast.prims.mungers.AstIsNumeric;
import water.rapids.ast.prims.mungers.AstLevels;
import water.rapids.ast.prims.mungers.AstMerge;
import water.rapids.ast.prims.mungers.AstNLevels;
import water.rapids.ast.prims.mungers.AstNaOmit;
import water.rapids.ast.prims.mungers.AstNcol;
import water.rapids.ast.prims.mungers.AstNrow;
import water.rapids.ast.prims.mungers.AstRBind;
import water.rapids.ast.prims.mungers.AstReLevel;
import water.rapids.ast.prims.mungers.AstRename;
import water.rapids.ast.prims.mungers.AstRowSlice;
import water.rapids.ast.prims.mungers.AstScale;
import water.rapids.ast.prims.mungers.AstSetDomain;
import water.rapids.ast.prims.mungers.AstSetLevel;
import water.rapids.ast.prims.mungers.AstSort;
import water.rapids.ast.prims.operators.AstAnd;
import water.rapids.ast.prims.operators.AstDiv;
import water.rapids.ast.prims.operators.AstEq;
import water.rapids.ast.prims.operators.AstGe;
import water.rapids.ast.prims.operators.AstGt;
import water.rapids.ast.prims.operators.AstIfElse;
import water.rapids.ast.prims.operators.AstIntDiv;
import water.rapids.ast.prims.operators.AstIntDivR;
import water.rapids.ast.prims.operators.AstLAnd;
import water.rapids.ast.prims.operators.AstLOr;
import water.rapids.ast.prims.operators.AstLe;
import water.rapids.ast.prims.operators.AstLt;
import water.rapids.ast.prims.operators.AstMod;
import water.rapids.ast.prims.operators.AstModR;
import water.rapids.ast.prims.operators.AstMul;
import water.rapids.ast.prims.operators.AstNe;
import water.rapids.ast.prims.operators.AstOr;
import water.rapids.ast.prims.operators.AstPlus;
import water.rapids.ast.prims.operators.AstPow;
import water.rapids.ast.prims.operators.AstSub;
import water.rapids.ast.prims.reducers.AstAll;
import water.rapids.ast.prims.reducers.AstAny;
import water.rapids.ast.prims.reducers.AstAnyNa;
import water.rapids.ast.prims.reducers.AstCumMax;
import water.rapids.ast.prims.reducers.AstCumMin;
import water.rapids.ast.prims.reducers.AstCumProd;
import water.rapids.ast.prims.reducers.AstCumSum;
import water.rapids.ast.prims.reducers.AstMad;
import water.rapids.ast.prims.reducers.AstMax;
import water.rapids.ast.prims.reducers.AstMaxNa;
import water.rapids.ast.prims.reducers.AstMean;
import water.rapids.ast.prims.reducers.AstMedian;
import water.rapids.ast.prims.reducers.AstMin;
import water.rapids.ast.prims.reducers.AstMinNa;
import water.rapids.ast.prims.reducers.AstNaCnt;
import water.rapids.ast.prims.reducers.AstProd;
import water.rapids.ast.prims.reducers.AstProdNa;
import water.rapids.ast.prims.reducers.AstSdev;
import water.rapids.ast.prims.reducers.AstSum;
import water.rapids.ast.prims.reducers.AstSumNa;
import water.rapids.ast.prims.repeaters.AstRepLen;
import water.rapids.ast.prims.repeaters.AstSeq;
import water.rapids.ast.prims.repeaters.AstSeqLen;
import water.rapids.ast.prims.search.AstMatch;
import water.rapids.ast.prims.search.AstWhich;
import water.rapids.ast.prims.string.AstCountMatches;
import water.rapids.ast.prims.string.AstCountSubstringsWords;
import water.rapids.ast.prims.string.AstEntropy;
import water.rapids.ast.prims.string.AstLStrip;
import water.rapids.ast.prims.string.AstRStrip;
import water.rapids.ast.prims.string.AstReplaceAll;
import water.rapids.ast.prims.string.AstReplaceFirst;
import water.rapids.ast.prims.string.AstStrLength;
import water.rapids.ast.prims.string.AstStrSplit;
import water.rapids.ast.prims.string.AstSubstring;
import water.rapids.ast.prims.string.AstToLower;
import water.rapids.ast.prims.string.AstToUpper;
import water.rapids.ast.prims.string.AstTrim;
import water.rapids.ast.prims.time.AstAsDate;
import water.rapids.ast.prims.time.AstDay;
import water.rapids.ast.prims.time.AstDayOfWeek;
import water.rapids.ast.prims.time.AstGetTimeZone;
import water.rapids.ast.prims.time.AstHour;
import water.rapids.ast.prims.time.AstListTimeZones;
import water.rapids.ast.prims.time.AstMillis;
import water.rapids.ast.prims.time.AstMinute;
import water.rapids.ast.prims.time.AstMktime;
import water.rapids.ast.prims.time.AstMoment;
import water.rapids.ast.prims.time.AstMonth;
import water.rapids.ast.prims.time.AstSecond;
import water.rapids.ast.prims.time.AstSetTimeZone;
import water.rapids.ast.prims.time.AstWeek;
import water.rapids.ast.prims.time.AstYear;
import water.rapids.ast.prims.timeseries.AstDiffLag1;
import water.rapids.ast.prims.timeseries.AstIsax;
import water.rapids.vals.ValFrame;
import water.rapids.vals.ValFun;

public class Env
extends Iced {
    public final Session _ses;
    public AstFunction _scope;
    private ArrayList<Frame> _stk = new ArrayList();
    private static final HashMap<String, AstPrimitive> PRIMS = new HashMap();
    private static final HashMap<String, AstParameter> CONSTS = new HashMap();

    static void init(AstPrimitive ast) {
        PRIMS.put(ast.str(), ast);
    }

    public Env(Session ses) {
        this._ses = ses;
    }

    public int sp() {
        return this._stk.size();
    }

    private Frame peek(int x) {
        return this._stk.get(this.sp() + x);
    }

    public StackHelp stk() {
        return new StackHelp();
    }

    public <V extends Val> V returning(V val) {
        if (val instanceof ValFrame) {
            this._ses.addRefCnt(val.getFrame(), 1);
        }
        return val;
    }

    public Val lookup(String id) {
        Val val;
        Val val2 = val = this._scope == null ? null : this._scope.lookup(id);
        if (val != null) {
            return val;
        }
        if (CONSTS.containsKey(id)) {
            return CONSTS.get(id).exec(this);
        }
        Value value = DKV.get(Key.make(this.expand(id)));
        if (value != null) {
            if (value.isFrame()) {
                return this.addGlobals((Frame)value.get());
            }
            throw new IllegalArgumentException("DKV name lookup of " + id + " yielded an instance of type " + value.className() + ", but only Frame is supported");
        }
        AstPrimitive ast = PRIMS.get(id);
        if (ast != null) {
            return new ValFun(ast);
        }
        throw new IllegalArgumentException("Name lookup of '" + id + "' failed");
    }

    public String expand(String id) {
        return id.startsWith("$") ? id.substring(1) + "~" + this._ses.id() : id;
    }

    ValFrame addGlobals(Frame fr) {
        this._ses.addGlobals(fr);
        return new ValFrame(new Frame((String[])fr._names.clone(), (Vec[])fr.vecs().clone()));
    }

    public String toString() {
        String s = "{";
        int sp = this.sp();
        for (int i = 0; i < sp; ++i) {
            s = s + this.peek(-sp + i).toString() + ",";
        }
        return s + "}";
    }

    static {
        CONSTS.put("FALSE", AstConst.FALSE);
        CONSTS.put("False", AstConst.FALSE);
        CONSTS.put("false", AstConst.FALSE);
        CONSTS.put("TRUE", AstConst.TRUE);
        CONSTS.put("True", AstConst.TRUE);
        CONSTS.put("true", AstConst.TRUE);
        CONSTS.put("NaN", AstConst.NAN);
        CONSTS.put("NA", AstConst.NAN);
        CONSTS.put("nan", AstConst.NAN);
        CONSTS.put("PI", AstConst.PI);
        CONSTS.put("Pi", AstConst.PI);
        CONSTS.put("null", null);
        Env.init(new AstAbs());
        Env.init(new AstAcos());
        Env.init(new AstAcosh());
        Env.init(new AstAsin());
        Env.init(new AstAsinh());
        Env.init(new AstAtan());
        Env.init(new AstAtanh());
        Env.init(new AstCeiling());
        Env.init(new AstCos());
        Env.init(new AstCosh());
        Env.init(new AstCosPi());
        Env.init(new AstDiGamma());
        Env.init(new AstExp());
        Env.init(new AstExpm1());
        Env.init(new AstFloor());
        Env.init(new AstGamma());
        Env.init(new AstLGamma());
        Env.init(new AstLog());
        Env.init(new AstLog1P());
        Env.init(new AstLog2());
        Env.init(new AstLog10());
        Env.init(new AstNoOp());
        Env.init(new AstNot());
        Env.init(new AstRound());
        Env.init(new AstSgn());
        Env.init(new AstSignif());
        Env.init(new AstSin());
        Env.init(new AstSinh());
        Env.init(new AstSinPi());
        Env.init(new AstSqrt());
        Env.init(new AstTan());
        Env.init(new AstTanh());
        Env.init(new AstTanPi());
        Env.init(new AstTriGamma());
        Env.init(new AstTrunc());
        Env.init(new AstAnd());
        Env.init(new AstDiv());
        Env.init(new AstEq());
        Env.init(new AstGe());
        Env.init(new AstGt());
        Env.init(new AstIntDiv());
        Env.init(new AstIntDivR());
        Env.init(new AstLAnd());
        Env.init(new AstLe());
        Env.init(new AstLOr());
        Env.init(new AstLt());
        Env.init(new AstMod());
        Env.init(new AstModR());
        Env.init(new AstMul());
        Env.init(new AstNe());
        Env.init(new AstOr());
        Env.init(new AstPlus());
        Env.init(new AstPow());
        Env.init(new AstSub());
        Env.init(new AstIfElse());
        Env.init(new AstIfElse());
        Env.init(new AstAll());
        Env.init(new AstAny());
        Env.init(new AstAnyNa());
        Env.init(new AstCumMax());
        Env.init(new AstCumMin());
        Env.init(new AstCumProd());
        Env.init(new AstCumSum());
        Env.init(new AstMad());
        Env.init(new AstMax());
        Env.init(new AstMaxNa());
        Env.init(new AstMean());
        Env.init(new AstMedian());
        Env.init(new AstMin());
        Env.init(new AstMinNa());
        Env.init(new AstNaCnt());
        Env.init(new AstProd());
        Env.init(new AstProdNa());
        Env.init(new AstSdev());
        Env.init(new AstSum());
        Env.init(new AstSumNa());
        Env.init(new AstAsDate());
        Env.init(new AstDay());
        Env.init(new AstDayOfWeek());
        Env.init(new AstGetTimeZone());
        Env.init(new AstHour());
        Env.init(new AstListTimeZones());
        Env.init(new AstMillis());
        Env.init(new AstMinute());
        Env.init(new AstMktime());
        Env.init(new AstMoment());
        Env.init(new AstMonth());
        Env.init(new AstSecond());
        Env.init(new AstSetTimeZone());
        Env.init(new AstWeek());
        Env.init(new AstYear());
        Env.init(new AstDiffLag1());
        Env.init(new AstIsax());
        Env.init(new AstCorrelation());
        Env.init(new AstHist());
        Env.init(new AstImpute());
        Env.init(new AstKFold());
        Env.init(new AstMode());
        Env.init(new AstSkewness());
        Env.init(new AstKurtosis());
        Env.init(new AstModuloKFold());
        Env.init(new AstQtile());
        Env.init(new AstRunif());
        Env.init(new AstSort());
        Env.init(new AstStratifiedKFold());
        Env.init(new AstStratifiedSplit());
        Env.init(new AstTable());
        Env.init(new AstUnique());
        Env.init(new AstVariance());
        Env.init(new AstAnyFactor());
        Env.init(new AstApply());
        Env.init(new AstAsFactor());
        Env.init(new AstAsCharacter());
        Env.init(new AstAsNumeric());
        Env.init(new AstCBind());
        Env.init(new AstColNames());
        Env.init(new AstColPySlice());
        Env.init(new AstColSlice());
        Env.init(new AstCut());
        Env.init(new AstDdply());
        Env.init(new AstFilterNaCols());
        Env.init(new AstFlatten());
        Env.init(new AstGetrow());
        Env.init(new AstGroup());
        Env.init(new AstGroupedPermute());
        Env.init(new AstIsCharacter());
        Env.init(new AstIsFactor());
        Env.init(new AstIsNa());
        Env.init(new AstIsNumeric());
        Env.init(new AstLevels());
        Env.init(new AstMerge());
        Env.init(new AstNaOmit());
        Env.init(new AstColumnsByType());
        Env.init(new AstNcol());
        Env.init(new AstNLevels());
        Env.init(new AstNrow());
        Env.init(new AstRBind());
        Env.init(new AstReLevel());
        Env.init(new AstRename());
        Env.init(new AstRowSlice());
        Env.init(new AstScale());
        Env.init(new AstSetDomain());
        Env.init(new AstSetLevel());
        Env.init(new AstAppend());
        Env.init(new AstAssign());
        Env.init(new AstRectangleAssign());
        Env.init(new AstRm());
        Env.init(new AstTmpAssign());
        Env.init(new AstTranspose());
        Env.init(new AstMMult());
        Env.init(new AstCountMatches());
        Env.init(new AstCountSubstringsWords());
        Env.init(new AstEntropy());
        Env.init(new AstLStrip());
        Env.init(new AstReplaceAll());
        Env.init(new AstReplaceFirst());
        Env.init(new AstRStrip());
        Env.init(new AstStrLength());
        Env.init(new AstStrSplit());
        Env.init(new AstSubstring());
        Env.init(new AstToLower());
        Env.init(new AstToUpper());
        Env.init(new AstTrim());
        Env.init(new AstComma());
        Env.init(new AstLs());
        Env.init(new AstMatch());
        Env.init(new AstWhich());
        Env.init(new AstRepLen());
        Env.init(new AstSeq());
        Env.init(new AstSeqLen());
    }

    public class StackHelp
    implements Closeable {
        final int _sp;

        public StackHelp() {
            this._sp = Env.this.sp();
        }

        public Val track(Val v) {
            if (v instanceof ValFrame) {
                this.track(v.getFrame());
            }
            return v;
        }

        public Frame track(Frame fr) {
            Env.this._stk.add(Env.this.sp(), new Frame(fr._names, (Vec[])fr.vecs().clone()));
            return fr;
        }

        @Override
        public void close() {
            Futures fs = null;
            int sp = Env.this.sp();
            while (sp > this._sp) {
                Frame fr = (Frame)Env.this._stk.remove(--sp);
                fs = Env.this._ses.downRefCnt(fr, fs);
            }
            if (fs != null) {
                fs.blockForPending();
            }
        }

        public Val untrack(Val vfr) {
            if (!vfr.isFrame()) {
                return vfr;
            }
            Frame fr = vfr.getFrame();
            Env.this._ses.addRefCnt(fr, -1);
            return vfr;
        }
    }
}

