/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.assign;

import java.util.Arrays;
import water.DKV;
import water.H2O;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.rapids.Env;
import water.rapids.Session;
import water.rapids.Val;
import water.rapids.ast.AstParameter;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.ast.params.AstNum;
import water.rapids.ast.params.AstNumList;
import water.rapids.ast.prims.mungers.AstColSlice;
import water.rapids.vals.ValFrame;

public class AstRectangleAssign
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"dst", "src", "col_expr", "row_expr"};
    }

    @Override
    public int nargs() {
        return 5;
    }

    @Override
    public String str() {
        return ":=";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame dst = stk.track(asts[1].exec(env)).getFrame();
        Val vsrc = stk.track(asts[2].exec(env));
        AstParameter col_list = (AstParameter)asts[3];
        AstNumList cols_numlist = new AstNumList(col_list.columns(dst.names()));
        if (cols_numlist.isEmpty()) {
            cols_numlist = new AstNumList(0L, dst.numCols());
        }
        int[] cols = AstColSlice.col_select(dst.names(), cols_numlist);
        dst = new Frame(dst._names, (Vec[])dst.vecs().clone());
        if (asts[4] instanceof AstNum || asts[4] instanceof AstNumList) {
            AstNumList rows;
            AstNumList astNumList = rows = asts[4] instanceof AstNum ? new AstNumList(((AstNum)asts[4]).getNum()) : (AstNumList)asts[4];
            if (rows.isEmpty()) {
                rows = new AstNumList(0L, dst.numRows());
            }
            switch (vsrc.type()) {
                case 1: {
                    this.assign_frame_scalar(dst, cols, rows, vsrc.getNum(), env._ses);
                    break;
                }
                case 3: {
                    this.assign_frame_scalar(dst, cols, rows, vsrc.getStr(), env._ses);
                    break;
                }
                case 5: {
                    this.assign_frame_frame(dst, cols, rows, vsrc.getFrame(), env._ses);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Source must be a Frame or Number, but found a " + vsrc.getClass());
                }
            }
        } else {
            Frame rows = stk.track(asts[4].exec(env)).getFrame();
            switch (vsrc.type()) {
                case 1: {
                    this.assign_frame_scalar(dst, cols, rows, (Object)vsrc.getNum(), env._ses);
                    break;
                }
                case 3: {
                    this.assign_frame_scalar(dst, cols, rows, (Object)vsrc.getStr(), env._ses);
                    break;
                }
                case 5: {
                    throw H2O.unimpl();
                }
                default: {
                    throw new IllegalArgumentException("Source must be a Frame or Number, but found a " + vsrc.getClass());
                }
            }
        }
        return new ValFrame(dst);
    }

    private void assign_frame_frame(Frame dst, int[] cols, AstNumList rows, Frame src, Session ses) {
        if (cols.length != src.numCols()) {
            throw new IllegalArgumentException("Source and destination frames must have the same count of columns");
        }
        long nrows = rows.cnt();
        if (src.numRows() != nrows) {
            throw new IllegalArgumentException("Requires same count of rows in the number-list (" + nrows + ") as in the source (" + src.numRows() + ")");
        }
        if (dst.numRows() == nrows && rows.isDense()) {
            for (int i = 0; i < cols.length; ++i) {
                dst.replace(cols[i], src.vecs()[i]);
            }
            if (dst._key != null) {
                DKV.put(dst);
            }
            return;
        }
        Vec[] dvecs = dst.vecs();
        Vec[] svecs = src.vecs();
        for (int col = 0; col < cols.length; ++col) {
            byte dtype = dvecs[cols[col]].get_type();
            if (dtype != svecs[col].get_type()) {
                throw new IllegalArgumentException("Columns must be the same type; column " + col + ", '" + dst._names[cols[col]] + "', is of type " + dvecs[cols[col]].get_type_str() + " and the source is " + svecs[col].get_type_str());
            }
            if (dtype != 4 || Arrays.equals(dvecs[cols[col]].domain(), svecs[col].domain())) continue;
            throw new IllegalArgumentException("Cannot assign to a categorical column with a different domain; source column " + src._names[col] + ", target column " + dst._names[cols[col]]);
        }
        if (nrows <= 1L || (long)cols.length * nrows <= 1000L) {
            dvecs = ses.copyOnWrite(dst, cols);
            long[] rownums = rows.expand8();
            for (int col = 0; col < svecs.length; ++col) {
                if (svecs[col].get_type() == 2) {
                    BufferedString bStr = new BufferedString();
                    for (int ridx = 0; ridx < rownums.length; ++ridx) {
                        BufferedString s = svecs[col].atStr(bStr, ridx);
                        dvecs[cols[col]].set(rownums[ridx], s != null ? s.toString() : null);
                    }
                    continue;
                }
                for (int ridx = 0; ridx < rownums.length; ++ridx) {
                    dvecs[cols[col]].set(rownums[ridx], svecs[col].at(ridx));
                }
            }
            return;
        }
        Vec[] vecs = ses.copyOnWrite(dst, cols);
        Vec[] vecs2 = new Vec[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            vecs2[i] = vecs[cols[i]];
        }
        rows.sort();
        new AssignFrameFrameTask(rows, svecs).doAll(vecs2);
    }

    private void assign_frame_scalar(Frame dst, int[] cols, AstNumList rows, double src, Session ses) {
        long nrows = rows.cnt();
        if (nrows == 1L) {
            Vec[] vecs = ses.copyOnWrite(dst, cols);
            long drow = (long)rows._bases[0];
            for (int col : cols) {
                vecs[col].set(drow, src);
            }
            return;
        }
        if (dst.numRows() == nrows && rows.isDense()) {
            Vec anyVec = dst.anyVec();
            assert (anyVec != null);
            Vec vsrc = anyVec.makeCon(src);
            for (int col : cols) {
                dst.replace(col, vsrc);
            }
            if (dst._key != null) {
                DKV.put(dst);
            }
            return;
        }
        Vec[] vecs = ses.copyOnWrite(dst, cols);
        Vec[] vecs2 = new Vec[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            vecs2[i] = vecs[cols[i]];
        }
        rows.sort();
        new AssignFrameScalarTask(rows, src).doAll(vecs2);
    }

    private void assign_frame_scalar(Frame dst, int[] cols, AstNumList rows, String src, Session ses) {
        Vec[] dvecs = dst.vecs();
        long nrows = rows.cnt();
        if (nrows == 1L) {
            long drow = (long)rows.expand()[0];
            for (Vec vec : dvecs) {
                vec.set(drow, src);
            }
            return;
        }
        Vec[] vecs = ses.copyOnWrite(dst, cols);
        Vec[] vecs2 = new Vec[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            vecs2[i] = vecs[cols[i]];
        }
        rows.sort();
        new AssignFrameStringScalarTask(rows, src).doAll(vecs2);
    }

    private boolean isScalarCompatible(Object scalar, Vec v) {
        if (scalar == null) {
            return true;
        }
        if (scalar instanceof Number) {
            return v.get_type() == 3 || v.get_type() == 5;
        }
        if (scalar instanceof String) {
            if (v.get_type() == 4) {
                for (String f : v.domain()) {
                    if (!f.equals(scalar)) continue;
                    return true;
                }
                return false;
            }
            return v.get_type() == 2 || v.get_type() == 1;
        }
        return false;
    }

    private void assign_frame_scalar(Frame dst, int[] cols, Frame rows, Object src, Session ses) {
        Vec bool = rows.vec(0);
        if (bool.isConst() && (int)bool.min() == 1 && src instanceof Number) {
            Vec anyVec = dst.anyVec();
            assert (anyVec != null);
            Vec vsrc = anyVec.makeCon((Double)src);
            for (int col : cols) {
                dst.replace(col, vsrc);
            }
            if (dst._key != null) {
                DKV.put(dst);
            }
            return;
        }
        for (int col : cols) {
            if (this.isScalarCompatible(src, dst.vec(col))) continue;
            throw new IllegalArgumentException("Cannot assign value " + src + " into a vector of type " + dst.vec(col).get_type_str() + ".");
        }
        Vec[] vecs = ses.copyOnWrite(dst, cols);
        Vec[] vecs2 = new Vec[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            vecs2[i] = vecs[cols[i]];
        }
        ConditionalAssignTask.doAssign(vecs2, src, rows.vec(0));
    }

    private static abstract class RowSliceTask
    extends MRTask<RowSliceTask> {
        final AstNumList _rows;

        RowSliceTask(AstNumList rows) {
            this._rows = rows;
        }

        @Override
        public void map(Chunk[] cs) {
            long start = cs[0].start();
            long end = start + (long)cs[0]._len;
            long min = (long)this._rows.min();
            long max = (long)this._rows.max() - 1L;
            if (max >= start && min <= end) {
                long startOffset = min > start ? min : start;
                int chkOffset = (int)(startOffset - start);
                this.mapChunkSlice(cs, chkOffset);
            }
        }

        abstract void mapChunkSlice(Chunk[] var1, int var2);
    }

    private static class ConditionalAssignTask
    extends MRTask<ConditionalAssignTask> {
        final Chunk.ValueSetter[] _setters;

        ConditionalAssignTask(Vec[] vecs, Object value) {
            this._setters = new Chunk.ValueSetter[vecs.length];
            for (int i = 0; i < this._setters.length; ++i) {
                this._setters[i] = Chunk.createValueSetter(vecs[i], value);
            }
        }

        @Override
        public void map(Chunk[] cs) {
            Chunk bool = cs[cs.length - 1];
            for (int row = 0; row < cs[0]._len; ++row) {
                if (bool.at8(row) != 1L) continue;
                for (int col = 0; col < cs.length - 1; ++col) {
                    this._setters[col].setValue(cs[col], row);
                }
            }
        }

        static void doAssign(Vec[] dst, Object src, Vec predicateVec) {
            Vec[] vecs = new Vec[dst.length + 1];
            System.arraycopy(dst, 0, vecs, 0, dst.length);
            vecs[vecs.length - 1] = predicateVec;
            new ConditionalAssignTask(dst, src).doAll(vecs);
        }
    }

    private static class AssignFrameStringScalarTask
    extends RowSliceTask {
        private String _src;

        private AssignFrameStringScalarTask(AstNumList rows, String src) {
            super(rows);
            this._src = src;
        }

        @Override
        void mapChunkSlice(Chunk[] cs, int chkOffset) {
            long start = cs[0].start();
            for (int i = chkOffset; i < cs[0]._len; ++i) {
                if (!this._rows.has(start + (long)i)) continue;
                for (Chunk chk : cs) {
                    chk.set(i, this._src);
                }
            }
        }
    }

    private static class AssignFrameScalarTask
    extends RowSliceTask {
        private double _src;

        private AssignFrameScalarTask(AstNumList rows, double src) {
            super(rows);
            this._src = src;
        }

        @Override
        void mapChunkSlice(Chunk[] cs, int chkOffset) {
            long start = cs[0].start();
            for (int i = chkOffset; i < cs[0]._len; ++i) {
                if (!this._rows.has(start + (long)i)) continue;
                for (Chunk chk : cs) {
                    chk.set(i, this._src);
                }
            }
        }
    }

    private static class AssignFrameFrameTask
    extends RowSliceTask {
        private Vec[] _svecs;

        private AssignFrameFrameTask(AstNumList rows, Vec[] svecs) {
            super(rows);
            this._svecs = svecs;
        }

        @Override
        void mapChunkSlice(Chunk[] cs, int chkOffset) {
            long start = cs[0].start();
            Chunk[] scs = null;
            for (int i = chkOffset; i < cs[0]._len; ++i) {
                long idx = this._rows.index(start + (long)i);
                if (idx < 0L) continue;
                if (scs == null || scs[0].start() < idx || idx >= scs[0].start() + (long)scs[0].len()) {
                    int sChkIdx = this._svecs[0].elem2ChunkIdx(idx);
                    scs = new Chunk[this._svecs.length];
                    for (int j = 0; j < this._svecs.length; ++j) {
                        scs[j] = this._svecs[j].chunkForChunkIdx(sChkIdx);
                    }
                }
                BufferedString bStr = new BufferedString();
                int si = (int)(idx - scs[0].start());
                for (int j = 0; j < cs.length; ++j) {
                    Chunk chk = cs[j];
                    Chunk schk = scs[j];
                    if (this._svecs[j].get_type() == 2) {
                        BufferedString s = schk.atStr(bStr, si);
                        chk.set(i, s != null ? s.toString() : null);
                        BufferedString bss = chk.atStr(new BufferedString(), i);
                        if (s != null || bss == null) continue;
                        chk.set(i, s != null ? s.toString() : null);
                        continue;
                    }
                    chk.set(i, schk.atd(si));
                }
            }
        }
    }
}

