/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.reducers;

import java.util.Arrays;
import water.H2O;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;
import water.util.ArrayUtils;

public abstract class AstCumu
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary", "axis"};
    }

    @Override
    public int nargs() {
        return 2;
    }

    @Override
    public String str() {
        throw H2O.unimpl();
    }

    public abstract double op(double var1, double var3);

    public abstract double init();

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame fr2;
        Frame f = stk.track(asts[1].exec(env)).getFrame();
        AstRoot axisAR = asts[2];
        for (Vec v : f.vecs()) {
            if (!v.isCategorical() && !v.isString() && !v.isUUID()) continue;
            throw new IllegalArgumentException("Cumulative functions not applicable to enum, string, or UUID values");
        }
        double axis = axisAR.exec(env).getNum();
        if (axis != 1.0 && axis != 0.0) {
            throw new IllegalArgumentException("Axis must be 0 or 1");
        }
        if (f.numCols() == 1) {
            if (axis == 0.0) {
                CumuTask t = new CumuTask(f.anyVec().nChunks(), this.init());
                t.doAll(new byte[]{3}, f.anyVec());
                final double[] chkCumu = t._chkCumu;
                Vec cumuVec = t.outputFrame().anyVec();
                new MRTask(){

                    @Override
                    public void map(Chunk c) {
                        if (c.cidx() != 0) {
                            double d = chkCumu[c.cidx() - 1];
                            for (int i = 0; i < c._len; ++i) {
                                c.set(i, AstCumu.this.op(c.atd(i), d));
                            }
                        }
                    }
                }.doAll(cumuVec);
                return new ValFrame(new Frame(cumuVec));
            }
            return new ValFrame(new Frame(f));
        }
        if (axis == 0.0) {
            CumuTaskWholeFrame t = new CumuTaskWholeFrame(f.anyVec().nChunks(), this.init(), f.numCols());
            fr2 = ((CumuTaskWholeFrame)t.doAll(f.numCols(), (byte)3, f)).outputFrame(null, f.names(), null);
            final double[][] chkCumu = t._chkCumu;
            new MRTask(){

                @Override
                public void map(Chunk[] cs) {
                    if (cs[0].cidx() != 0) {
                        for (int i = 0; i < cs.length; ++i) {
                            double d = chkCumu[i][cs[i].cidx() - 1];
                            for (int j = 0; j < cs[i]._len; ++j) {
                                cs[i].set(j, AstCumu.this.op(cs[i].atd(j), d));
                            }
                        }
                    }
                }
            }.doAll(fr2);
            return new ValFrame(new Frame(fr2));
        }
        CumuTaskAxis1 t = new CumuTaskAxis1(this.init());
        fr2 = ((CumuTaskAxis1)t.doAll(f.numCols(), (byte)3, f)).outputFrame(null, f.names(), null);
        return new ValFrame(new Frame(fr2));
    }

    protected class CumuTask
    extends MRTask<CumuTask> {
        final int _nchks;
        final double _init;
        double[] _chkCumu;

        CumuTask(int nchks, double init) {
            this._nchks = nchks;
            this._init = init;
        }

        @Override
        public void setupLocal() {
            this._chkCumu = new double[this._nchks];
        }

        @Override
        public void map(Chunk c, NewChunk nc) {
            double acc = this._init;
            for (int i = 0; i < c._len; ++i) {
                acc = AstCumu.this.op(acc, c.atd(i));
                nc.addNum(acc);
            }
            this._chkCumu[c.cidx()] = acc;
        }

        @Override
        public void reduce(CumuTask t) {
            if (this._chkCumu != t._chkCumu) {
                ArrayUtils.add(this._chkCumu, t._chkCumu);
            }
        }

        @Override
        public void postGlobal() {
            for (int i = 1; i < this._chkCumu.length; ++i) {
                this._chkCumu[i] = AstCumu.this.op(this._chkCumu[i], this._chkCumu[i - 1]);
            }
        }
    }

    protected class CumuTaskWholeFrame
    extends MRTask<CumuTaskWholeFrame> {
        final int _nchks;
        final double _init;
        final int _ncols;
        double[][] _chkCumu;

        CumuTaskWholeFrame(int nchks, double init, int ncols) {
            this._nchks = nchks;
            this._init = init;
            this._ncols = ncols;
        }

        @Override
        public void setupLocal() {
            this._chkCumu = new double[this._ncols][this._nchks];
        }

        @Override
        public void map(Chunk[] cs, NewChunk[] nc) {
            double[] acc = new double[cs.length];
            Arrays.fill(acc, this._init);
            for (int i = 0; i < cs.length; ++i) {
                for (int j = 0; j < cs[i]._len; ++j) {
                    acc[i] = AstCumu.this.op(acc[i], cs[i].atd(j));
                    nc[i].addNum(acc[i]);
                }
                this._chkCumu[i][cs[i].cidx()] = acc[i];
            }
        }

        @Override
        public void reduce(CumuTaskWholeFrame t) {
            if (this._chkCumu != t._chkCumu) {
                ArrayUtils.add(this._chkCumu, t._chkCumu);
            }
        }

        @Override
        public void postGlobal() {
            for (int i = 1; i < this._chkCumu.length; ++i) {
                for (int j = 1; j < this._chkCumu[i].length; ++j) {
                    this._chkCumu[i][j] = AstCumu.this.op(this._chkCumu[i][j], this._chkCumu[i][j - 1]);
                }
            }
        }
    }

    protected class CumuTaskAxis1
    extends MRTask<CumuTaskAxis1> {
        final double _init;

        CumuTaskAxis1(double init) {
            this._init = init;
        }

        @Override
        public void map(Chunk[] cs, NewChunk[] nc) {
            for (int i = 0; i < cs[0].len(); ++i) {
                for (int j = 0; j < cs.length; ++j) {
                    double preVal = j == 0 ? this._init : nc[j - 1].atd(i);
                    nc[j].addNum(AstCumu.this.op(preVal, cs[j].atd(i)));
                }
            }
        }
    }
}

