/*
 * Decompiled with CFR 0.152.
 */
package hex.createframe;

import hex.createframe.CreateFrameExecutor;
import java.util.Random;
import water.H2O;
import water.Iced;
import water.Job;
import water.Key;
import water.fvec.Frame;
import water.util.Log;

public abstract class CreateFrameRecipe<T extends CreateFrameRecipe<T>>
extends Iced<T> {
    protected Key<Frame> dest;
    protected long seed = -1L;

    protected abstract void checkParametersValidity();

    protected abstract void buildRecipe(CreateFrameExecutor var1);

    public Job<Frame> exec() {
        this.fillMissingParameters();
        Job<Frame> job = new Job<Frame>(this.dest, Frame.class.getName(), "CreateFrame:original");
        CreateFrameExecutor cfe = new CreateFrameExecutor(job);
        this.checkParametersValidity();
        this.buildRecipe(cfe);
        this.checkParametersValidity2(cfe);
        return job.start(cfe, cfe.workAmount());
    }

    protected void fillMissingParameters() {
        if (this.dest == null) {
            this.dest = Key.make();
        }
        if (this.seed == -1L) {
            this.seed = new Random().nextLong();
            Log.info("Generated seed: " + this.seed);
        }
    }

    protected void checkParametersValidity2(CreateFrameExecutor cfe) {
        long byteEstimate = cfe.estimatedByteSize();
        long clusterFreeMem = H2O.CLOUD.free_mem();
        double gb = 1.073741824E9;
        this.check(byteEstimate <= clusterFreeMem, String.format("Frame is expected to require %.3fGb, which will not fit into H2O's free memory of %.3fGb", (double)byteEstimate / gb, (double)clusterFreeMem / gb));
    }

    protected void check(boolean test, String msg) {
        if (!test) {
            throw new IllegalArgumentException(msg);
        }
    }
}

