/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import water.AutoBuffer;
import water.ExternalFrameUtils;
import water.fvec.ChunkUtils;
import water.fvec.NewChunk;

final class ExternalFrameWriterBackend {
    ExternalFrameWriterBackend() {
    }

    static void handleWriteToChunk(SocketChannel sock, AutoBuffer ab) throws IOException {
        String frameKey = ab.getStr();
        byte[] expectedTypes = ab.getA1();
        assert (expectedTypes != null);
        byte[] vecTypes = ExternalFrameUtils.vecTypesFromExpectedTypes(expectedTypes);
        int expectedNumRows = ab.getInt();
        int chunk_id = ab.getInt();
        NewChunk[] nchnk = ChunkUtils.createNewChunks(frameKey, vecTypes, chunk_id);
        assert (nchnk != null);
        for (int currentRowIdx = 0; currentRowIdx < expectedNumRows; ++currentRowIdx) {
            block11: for (int colIdx = 0; colIdx < expectedTypes.length; ++colIdx) {
                switch (expectedTypes[colIdx]) {
                    case 0: 
                    case 1: {
                        ExternalFrameWriterBackend.store(ab, nchnk[colIdx], ab.get1());
                        continue block11;
                    }
                    case 2: {
                        ExternalFrameWriterBackend.store(ab, nchnk[colIdx], ab.get2());
                        continue block11;
                    }
                    case 3: {
                        ExternalFrameWriterBackend.store(ab, nchnk[colIdx], ab.get2s());
                        continue block11;
                    }
                    case 4: {
                        ExternalFrameWriterBackend.store(ab, nchnk[colIdx], ab.getInt());
                        continue block11;
                    }
                    case 6: 
                    case 9: {
                        ExternalFrameWriterBackend.store(ab, nchnk[colIdx], ab.get8());
                        continue block11;
                    }
                    case 5: {
                        ExternalFrameWriterBackend.store(nchnk[colIdx], ab.get4f());
                        continue block11;
                    }
                    case 7: {
                        ExternalFrameWriterBackend.store(nchnk[colIdx], ab.get8d());
                        continue block11;
                    }
                    case 8: {
                        ExternalFrameWriterBackend.store(ab, nchnk[colIdx], ab.getStr());
                        continue block11;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown expected type: " + expectedTypes[colIdx]);
                    }
                }
            }
        }
        ChunkUtils.closeNewChunks(nchnk);
        AutoBuffer outputAb = new AutoBuffer();
        outputAb.put1(2);
        ExternalFrameUtils.writeToChannel(outputAb, sock);
    }

    private static void store(AutoBuffer ab, NewChunk chunk, long data) {
        if (ExternalFrameUtils.isNA(ab, data)) {
            chunk.addNA();
        } else {
            chunk.addNum(data);
        }
    }

    private static void store(NewChunk chunk, double data) {
        if (ExternalFrameUtils.isNA(data)) {
            chunk.addNA();
        } else {
            chunk.addNum(data);
        }
    }

    private static void store(AutoBuffer ab, NewChunk chunk, String data) {
        if (ExternalFrameUtils.isNA(ab, data)) {
            chunk.addNA();
        } else {
            chunk.addStr(data);
        }
    }
}

