/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.io.IOException;
import java.nio.channels.ByteChannel;
import java.nio.channels.SocketChannel;
import water.H2O;
import water.network.SSLContextException;
import water.network.SSLSocketChannelFactory;
import water.util.Log;

public class H2OSecurityManager {
    public boolean securityEnabled = false;
    private SSLSocketChannelFactory sslSocketChannelFactory;

    H2OSecurityManager() {
        try {
            if (null != H2O.ARGS.internal_security_conf) {
                this.sslSocketChannelFactory = new SSLSocketChannelFactory();
                this.securityEnabled = true;
            }
        }
        catch (SSLContextException e) {
            Log.err("Node initialized with SSL enabled but failed to create SSLContext. Node initialization aborted.");
            Log.err(e);
            H2O.exit(1);
        }
    }

    public ByteChannel wrapServerChannel(SocketChannel channel) throws IOException {
        return this.sslSocketChannelFactory.wrapServerChannel(channel);
    }

    public ByteChannel wrapClientChannel(SocketChannel channel, String host, int port) throws IOException {
        return this.sslSocketChannelFactory.wrapClientChannel(channel, host, port);
    }
}

