/*
 * Decompiled with CFR 0.152.
 */
package water.network;

import java.io.IOException;
import java.nio.channels.ByteChannel;
import java.nio.channels.SocketChannel;
import water.H2OSecurityManager;
import water.network.SSLSocketChannel;

public class SocketChannelFactory {
    private H2OSecurityManager sm;

    public SocketChannelFactory(H2OSecurityManager sm) {
        this.sm = sm;
    }

    public ByteChannel serverChannel(ByteChannel channel) throws IOException {
        if (this.sm.securityEnabled && !(channel instanceof SSLSocketChannel)) {
            return this.sm.wrapServerChannel((SocketChannel)channel);
        }
        return channel;
    }

    public ByteChannel clientChannel(ByteChannel channel, String host, int port) throws IOException {
        if (this.sm.securityEnabled && !(channel instanceof SSLSocketChannel)) {
            return this.sm.wrapClientChannel((SocketChannel)channel, host, port);
        }
        return channel;
    }
}

