/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import water.fvec.Frame;
import water.rapids.Session;
import water.rapids.Val;
import water.rapids.ast.AstExec;
import water.rapids.ast.AstFunction;
import water.rapids.ast.AstParameter;
import water.rapids.ast.AstRoot;
import water.rapids.ast.params.AstId;
import water.rapids.ast.params.AstNum;
import water.rapids.ast.params.AstNumList;
import water.rapids.ast.params.AstStr;
import water.rapids.ast.params.AstStrList;
import water.util.CollectionUtils;
import water.util.StringUtils;

public class Rapids {
    private final String _str;
    private int _x;
    private static Set<Character> invalidTokenCharacters = StringUtils.toCharacterSet("({[]}) \t\r\n\\\"'");
    private static Set<Character> validNumberCharacters = StringUtils.toCharacterSet("0123456789.-+eEnNaA");
    private static Map<Character, Character> simpleEscapeSequences = CollectionUtils.createMap(StringUtils.toCharacterArray("ntrfb'\"\\"), StringUtils.toCharacterArray("\n\t\r\f\b'\"\\"));

    public static AstRoot parse(String rapids) {
        Rapids r = new Rapids(rapids);
        AstRoot res = r.parseNext();
        if (r.skipWS() != ' ') {
            throw new IllegalASTException("Syntax error: illegal Rapids expression `" + rapids + "`");
        }
        return res;
    }

    public static Val exec(String rapids) {
        Session session = new Session();
        try {
            AstRoot ast = Rapids.parse(rapids);
            Val val = session.exec(ast, null);
            return session.end(val);
        }
        catch (Throwable ex) {
            throw session.endQuietly(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Val exec(String rapids, Session session) {
        AstRoot ast = Rapids.parse(rapids);
        Session session2 = session;
        synchronized (session2) {
            Val val = session.exec(ast, null);
            if (val.isFrame()) {
                Frame frame = val.getFrame();
                assert (frame._key != null) : "Returned frame has no key";
                session.addRefCnt(frame, -1);
            }
            return val;
        }
    }

    private Rapids(String rapidsStr) {
        this._str = rapidsStr;
        this._x = 0;
    }

    private AstRoot parseNext() {
        switch (this.skipWS()) {
            case '(': {
                return this.parseFunctionApplication();
            }
            case '{': {
                return this.parseFunctionDefinition();
            }
            case '[': {
                return this.parseList();
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return new AstNum(this.number());
            }
            case '-': {
                return this.peek(1) >= '0' && this.peek(1) <= '9' ? new AstNum(this.number()) : new AstId(this.token());
            }
            case '\"': 
            case '\'': {
                return new AstStr(this.string());
            }
            case ' ': {
                throw new IllegalASTException("Expected an expression but ran out of text");
            }
        }
        return new AstId(this.token());
    }

    private AstExec parseFunctionApplication() {
        this.eatChar('(');
        ArrayList<AstRoot> asts = new ArrayList<AstRoot>();
        while (this.skipWS() != ')') {
            asts.add(this.parseNext());
        }
        this.eatChar(')');
        AstExec res = new AstExec(asts);
        if (this.peek(0) == '-') {
            this.eatChar('-');
            this.eatChar('>');
            AstId tmpid = new AstId(this.token());
            res = new AstExec(new AstRoot[]{new AstId("tmp="), tmpid, res});
        }
        return res;
    }

    private AstFunction parseFunctionDefinition() {
        this.eatChar('{');
        ArrayList<String> ids = new ArrayList<String>();
        ids.add("");
        while (this.skipWS() != '.') {
            String id = this.token();
            if (!Character.isJavaIdentifierStart(id.charAt(0))) {
                throw new IllegalASTException("variable must be a valid Java identifier: " + id);
            }
            for (char c : id.toCharArray()) {
                if (Character.isJavaIdentifierPart(c)) continue;
                throw new IllegalASTException("variable must be a valid Java identifier: " + id);
            }
            ids.add(id);
        }
        this.eatChar('.');
        AstRoot body = this.parseNext();
        if (this.skipWS() != '}') {
            throw new IllegalASTException("Expected the end of the function, but found '" + this.peek(0) + "'");
        }
        this.eatChar('}');
        return new AstFunction(ids, body);
    }

    private AstParameter parseList() {
        this.eatChar('[');
        char nextChar = this.skipWS();
        AstParameter res = Rapids.isQuote(nextChar) ? this.parseStringList() : this.parseNumList();
        this.eatChar(']');
        return res;
    }

    private AstStrList parseStringList() {
        ArrayList<String> strs = new ArrayList<String>(10);
        while (Rapids.isQuote(this.skipWS())) {
            strs.add(this.string());
            if (this.skipWS() != ',') continue;
            this.eatChar(',');
        }
        return new AstStrList(strs);
    }

    private AstNumList parseNumList() {
        ArrayList<Double> bases = new ArrayList<Double>();
        ArrayList<Double> strides = new ArrayList<Double>();
        ArrayList<Long> counts = new ArrayList<Long>();
        while (this.skipWS() != ']') {
            double base = this.number();
            double count = 1.0;
            double stride = 1.0;
            if (this.skipWS() == ':') {
                this.eatChar(':');
                this.skipWS();
                count = this.number();
                if (count < 1.0 || (double)((long)count) != count) {
                    throw new IllegalASTException("Count must be a positive integer, got " + count);
                }
            }
            if (this.skipWS() == ':') {
                this.eatChar(':');
                this.skipWS();
                stride = this.number();
                if (stride < 0.0 || Double.isNaN(stride)) {
                    throw new IllegalASTException("Stride must be positive, got " + stride);
                }
            }
            if (count == 1.0 && stride != 1.0) {
                throw new IllegalASTException("If count is 1, then stride must be one (and ignored)");
            }
            bases.add(base);
            counts.add((long)count);
            strides.add(stride);
            if (this.skipWS() != ',') continue;
            this.eatChar(',');
        }
        return new AstNumList(bases, strides, counts);
    }

    private char peek(int offset) {
        return this._x + offset < this._str.length() ? this._str.charAt(this._x + offset) : (char)' ';
    }

    private void eatChar(char c) {
        if (this.peek(0) != c) {
            throw new IllegalASTException("Expected '" + c + "'. Got: '" + this.peek(0));
        }
        ++this._x;
    }

    private char skipWS() {
        char c = ' ';
        while (this._x < this._str.length() && Rapids.isWS(c = this.peek(0))) {
            ++this._x;
        }
        return c;
    }

    private String token() {
        int start = this._x;
        while (!invalidTokenCharacters.contains(Character.valueOf(this.peek(0)))) {
            ++this._x;
        }
        if (start == this._x) {
            throw new IllegalASTException("Missing token");
        }
        return this._str.substring(start, this._x);
    }

    private double number() {
        int start = this._x;
        while (validNumberCharacters.contains(Character.valueOf(this.peek(0)))) {
            ++this._x;
        }
        if (start == this._x) {
            throw new IllegalASTException("Missing a number");
        }
        String s = this._str.substring(start, this._x);
        if (s.toLowerCase().equals("nan")) {
            return Double.NaN;
        }
        try {
            return Double.valueOf(s);
        }
        catch (NumberFormatException e) {
            throw new IllegalASTException(e.toString());
        }
    }

    private String string() {
        char quote = this.peek(0);
        int start = ++this._x;
        boolean has_escapes = false;
        while (this._x < this._str.length()) {
            char c = this.peek(0);
            if (c == '\\') {
                has_escapes = true;
                char cc = this.peek(1);
                if (simpleEscapeSequences.containsKey(Character.valueOf(cc))) {
                    this._x += 2;
                    continue;
                }
                if (cc == 'x') {
                    this._x += 4;
                    continue;
                }
                if (cc == 'u') {
                    this._x += 6;
                    continue;
                }
                if (cc == 'U') {
                    this._x += 10;
                    continue;
                }
                throw new IllegalASTException("Invalid escape sequence \\" + cc);
            }
            if (c == quote) {
                ++this._x;
                if (has_escapes) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = start; i < this._x - 1; ++i) {
                        char ch = this._str.charAt(i);
                        if (ch == '\\') {
                            char cc;
                            if (simpleEscapeSequences.containsKey(Character.valueOf(cc = this._str.charAt(++i)))) {
                                sb.append(simpleEscapeSequences.get(Character.valueOf(cc)));
                                continue;
                            }
                            int n = cc == 'x' ? 2 : (cc == 'u' ? 4 : (cc == 'U' ? 8 : -1));
                            int hex = -1;
                            try {
                                hex = StringUtils.unhex(this._str.substring(i + 1, i + 1 + n));
                            }
                            catch (NumberFormatException e) {
                                throw new IllegalASTException(e.toString());
                            }
                            if (hex > 0x10FFFF) {
                                throw new IllegalASTException("Illegal unicode codepoint " + hex);
                            }
                            sb.append(Character.toChars(hex));
                            i += n;
                            continue;
                        }
                        sb.append(ch);
                    }
                    return sb.toString();
                }
                return this._str.substring(start, this._x - 1);
            }
            ++this._x;
        }
        throw new IllegalASTException("Unterminated string at " + start);
    }

    private static boolean isWS(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r';
    }

    private static boolean isQuote(char c) {
        return c == '\'' || c == '\"';
    }

    public static class IllegalASTException
    extends IllegalArgumentException {
        public IllegalASTException(String s) {
            super(s);
        }
    }
}

