/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast;

import java.util.ArrayList;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFun;
import water.util.SB;

public class AstExec
extends AstRoot {
    public final AstRoot[] _asts;

    public AstExec() {
        this((AstRoot[])null);
    }

    public AstExec(AstRoot[] asts) {
        this._asts = asts;
    }

    public AstExec(ArrayList<AstRoot> asts) {
        this._asts = asts.toArray(new AstRoot[asts.size()]);
    }

    @Override
    public String str() {
        SB sb = new SB().p('(');
        for (AstRoot ast : this._asts) {
            sb.p(ast.toString()).p(' ');
        }
        return sb.p(')').toString();
    }

    @Override
    public String example() {
        return "(func ...args)";
    }

    @Override
    public String description() {
        return "List of whitespace-separated tokens within parenthesis is interpreted as a function application. The first argument must be a function name (or an expression returning a function), all other tokens are passed to the function as arguments. For example: `(sqrt 16)`, `(+ 2 3)`, `(getTimeZone)`, etc.";
    }

    @Override
    public Val exec(Env env) {
        Val fun = this._asts[0].exec(env);
        if (!fun.isFun()) {
            throw new IllegalArgumentException("Expected a function but found " + fun.getClass());
        }
        AstPrimitive ast = fun.getFun();
        int nargs = ast.nargs();
        if (nargs != -1 && nargs != this._asts.length) {
            throw new IllegalArgumentException("Incorrect number of arguments; '" + ast + "' expects " + (nargs - 1) + " but was passed " + (this._asts.length - 1));
        }
        Env.StackHelp stk = env.stk();
        Throwable throwable = null;
        try {
            Val val = env.returning(ast.apply(env, stk, this._asts));
            return val;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (stk != null) {
                if (throwable != null) {
                    try {
                        stk.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                } else {
                    stk.close();
                }
            }
        }
    }

    public String[] getArgs() {
        return ((ValFun)this._asts[0].exec(new Env(null))).getArgs();
    }
}

