/*
 * Decompiled with CFR 0.152.
 */
package water.udf.fp;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import water.udf.fp.Function;
import water.udf.fp.Unfoldable;

public class Functions {
    public static <X, Y, Z> Function<X, Z> compose(Function<Y, Z> g, Function<X, Y> f) {
        return new Composition<X, Y, Z>(f, g);
    }

    public static <X> Function<X, X> identity() {
        return new Function<X, X>(){

            @Override
            public X apply(X x) {
                return x;
            }
        };
    }

    public static <T> Function<Long, T> onList(final List<T> list) {
        return new Function<Long, T>(){

            @Override
            public T apply(Long i) {
                return list.get(i.intValue());
            }
        };
    }

    public static <X, Y> Iterable<Y> map(Iterable<X> xs, Function<X, Y> f) {
        LinkedList<Y> ys = new LinkedList<Y>();
        for (X x : xs) {
            ys.add(f.apply(x));
        }
        return ys;
    }

    public static <X, Y> Function<X, Y> constant(final Y y) {
        return new Function<X, Y>(){

            @Override
            public Y apply(X x) {
                return y;
            }
        };
    }

    public static Unfoldable<String, String> splitBy(String separator) {
        return new StringSplitter(separator);
    }

    public static int hashCode(Object x) {
        return x == null ? 0 : x.hashCode();
    }

    public static boolean equal(Object x, Object y) {
        return x == null ? y == null : x.equals(y);
    }

    static class StringSplitter
    implements Unfoldable<String, String> {
        private final String separator;

        StringSplitter(String separator) {
            this.separator = separator;
        }

        @Override
        public List<String> apply(String s) {
            return Arrays.asList(s.split(this.separator));
        }

        public int hashCode() {
            return 211 + this.separator.hashCode() * 7;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StringSplitter)) {
                return false;
            }
            StringSplitter other = (StringSplitter)obj;
            return Functions.equal(this.separator, other.separator);
        }
    }

    static class Composition<X, Y, Z>
    implements Function<X, Z> {
        private final Function<X, Y> f;
        private final Function<Y, Z> g;

        Composition(Function<X, Y> f, Function<Y, Z> g) {
            this.f = f;
            this.g = g;
        }

        public int hashCode() {
            return this.f.hashCode() * 211 + this.g.hashCode() * 79;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Composition)) {
                return false;
            }
            Composition other = (Composition)obj;
            return Functions.equal(this.f, other.f) && Functions.equal(this.g, other.g);
        }

        @Override
        public Z apply(X x) {
            return this.g.apply(this.f.apply(x));
        }
    }
}

