/*
 * Decompiled with CFR 0.152.
 */
package water.udf.specialized;

import water.fvec.Chunk;
import water.fvec.Vec;
import water.udf.ColumnFactory;
import water.udf.DataChunk;
import water.udf.DataColumn;
import water.udf.DataColumns;

public class Doubles
extends DataColumns.BaseFactory<Double> {
    public static final Doubles Doubles = new Doubles();

    public Doubles() {
        super((byte)3, "Doubles");
    }

    @Override
    public DataChunk<Double> apply(Chunk c) {
        return new DoubleChunk(c);
    }

    @Override
    public DataColumn<Double> newColumn(Vec vec) {
        if (vec.get_type() != 3) {
            throw new IllegalArgumentException("Expected type T_NUM, got " + vec.get_type_str());
        }
        return new Column(vec, this);
    }

    static class Column
    extends DataColumn<Double> {
        public Column() {
        }

        Column(Vec vec, ColumnFactory<Double> factory) {
            super(vec, factory);
        }

        @Override
        public Double get(long idx) {
            return this.vec().at(idx);
        }

        @Override
        public Double apply(Long idx) {
            return this.get(idx);
        }

        @Override
        public Double apply(long idx) {
            return this.get(idx);
        }

        @Override
        public void set(long idx, Double value) {
            if (value == null) {
                this.vec().setNA(idx);
            } else {
                this.vec().set(idx, value);
            }
        }

        @Override
        public void set(long idx, double value) {
            this.vec().set(idx, value);
        }
    }

    static class DoubleChunk
    extends DataChunk<Double> {
        public DoubleChunk() {
        }

        DoubleChunk(Chunk c) {
            super(c);
        }

        @Override
        public Double get(int idx) {
            return this.c.isNA(idx) ? null : Double.valueOf(this.c.atd(idx));
        }

        @Override
        public void set(int idx, Double value) {
            if (value == null) {
                this.c.setNA(idx);
            } else {
                this.c.set(idx, value);
            }
        }

        @Override
        public void set(int idx, double value) {
            this.c.set(idx, value);
        }
    }
}

