/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import water.AutoBuffer;
import water.ExternalFrameReaderBackend;
import water.ExternalFrameWriterBackend;

final class ExternalFrameHandler {
    static final byte NUM_MARKER_NEXT_BYTE_FOLLOWS = 127;
    static final String STR_MARKER_NEXT_BYTE_FOLLOWS = "\u0080";
    static final byte MARKER_ORIGINAL_VALUE = 0;
    static final byte MARKER_NA = 1;
    static final byte INIT_BYTE = 42;
    static final byte CONFIRM_READING_DONE = 1;
    static final byte CONFIRM_WRITING_DONE = 2;
    static final byte CREATE_FRAME = 0;
    static final byte DOWNLOAD_FRAME = 1;

    ExternalFrameHandler() {
    }

    void process(SocketChannel sock, AutoBuffer ab) throws IOException {
        byte requestType = ab.get1();
        switch (requestType) {
            case 0: {
                ExternalFrameWriterBackend.handleWriteToChunk(sock, ab);
                break;
            }
            case 1: {
                ExternalFrameReaderBackend.handleReadingFromChunk(sock, ab);
            }
        }
    }
}

