/*
 * Decompiled with CFR 0.152.
 */
package water;

import water.AutoBuffer;
import water.H2O;
import water.H2ONode;
import water.Iced;
import water.UDP;

public class UDPClientEvent
extends UDP {
    @Override
    AutoBuffer call(AutoBuffer ab) {
        if (ab._h2o != H2O.SELF && !H2O.ARGS.client && H2O.isFlatfileEnabled()) {
            ClientEvent ce = (ClientEvent)new ClientEvent().read(ab);
            if (ce.type == ClientEvent.Type.CONNECT) {
                H2O.addNodeToFlatfile(ce.clientNode);
            }
        }
        return ab;
    }

    public static class ClientEvent
    extends Iced<ClientEvent> {
        public Type type;
        public H2ONode clientNode;

        public ClientEvent() {
        }

        public ClientEvent(Type type, H2ONode clientNode) {
            this.type = type;
            this.clientNode = clientNode;
        }

        public static enum Type {
            CONNECT,
            DISCONNECT;


            public void broadcast(H2ONode clientNode) {
                ClientEvent ce = new ClientEvent(this, clientNode);
                ce.write(new AutoBuffer(H2O.SELF, UDP.udp.client_event._prior).putUdp(UDP.udp.client_event)).close();
            }
        }
    }
}

