/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import water.DKV;
import water.Job;
import water.Key;
import water.Value;
import water.api.Handler;
import water.api.SchemaServer;
import water.api.schemas3.JobV3;
import water.api.schemas3.JobsV3;
import water.exceptions.H2ONotFoundArgumentException;

public class JobsHandler
extends Handler {
    public JobsV3 list(int version, JobsV3 s) {
        Job[] jobs = Job.jobs();
        s.jobs = new JobV3[jobs.length];
        int i = 0;
        for (Job j : jobs) {
            try {
                s.jobs[i] = (JobV3)SchemaServer.schema(version, j).fillFromImpl(j);
            }
            catch (H2ONotFoundArgumentException e) {
                s.jobs[i] = new JobV3().fillFromImpl(j);
            }
            ++i;
        }
        return s;
    }

    public JobsV3 fetch(int version, JobsV3 s) {
        Key key = s.job_id.key();
        Value val = DKV.get(key);
        if (null == val) {
            throw new IllegalArgumentException("Job is missing");
        }
        Object ice = val.get();
        if (!(ice instanceof Job)) {
            throw new IllegalArgumentException("Must be a Job not a " + ice.getClass());
        }
        Job j = (Job)ice;
        s.jobs = new JobV3[1];
        try {
            s.jobs[0] = (JobV3)SchemaServer.schema(version, j).fillFromImpl(j);
        }
        catch (H2ONotFoundArgumentException e) {
            s.jobs[0] = new JobV3().fillFromImpl(j);
        }
        return s;
    }

    public JobsV3 cancel(int version, JobsV3 c) {
        Job j = (Job)DKV.getGet(c.job_id.key());
        if (j == null) {
            throw new IllegalArgumentException("No job with key " + c.job_id.key());
        }
        j.stop();
        return c;
    }
}

