/*
 * Decompiled with CFR 0.152.
 */
package water.api.schemas4.output;

import java.io.PrintWriter;
import java.io.StringWriter;
import water.Job;
import water.Key;
import water.Keyed;
import water.TypeMap;
import water.api.API;
import water.api.schemas3.KeyV3;
import water.api.schemas4.OutputSchemaV4;

public class JobV4
extends OutputSchemaV4<Job<?>, JobV4> {
    @API(help="Job key")
    public KeyV3.JobKeyV3 key;
    @API(help="Job status", values={"RUNNING", "DONE", "STOPPING", "CANCELLED", "FAILED"})
    public Status status;
    @API(help="Current progress, a number going from 0 to 1")
    public float progress;
    @API(help="Current progress status description")
    public String progress_msg;
    @API(help="Start time")
    public long start_time;
    @API(help="Runtime in milliseconds")
    public long duration;
    @API(help="Key of the target object (being created by this Job)")
    public KeyV3 dest;
    @API(help="Exception message, if an exception occurred")
    public String exception;
    @API(help="Stacktrace")
    public String stacktrace;
    @API(help="ready for view")
    public boolean ready_for_view;

    @Override
    public JobV4 fillFromImpl(Job<?> job) {
        if (job == null) {
            return this;
        }
        this.key = new KeyV3.JobKeyV3((Key<Job>)job._key);
        this.progress = job.progress();
        this.progress_msg = job.progress_msg();
        this.duration = job.msec();
        this.ready_for_view = job.readyForView();
        this.status = job.isRunning() ? (job.stop_requested() ? Status.STOPPING : Status.RUNNING) : (job.stop_requested() ? Status.CANCELLED : Status.DONE);
        Throwable ex = job.ex();
        if (ex != null) {
            this.status = Status.FAILED;
            this.exception = ex.toString();
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            this.stacktrace = sw.toString();
        }
        Keyed dest_type = (Keyed)TypeMap.theFreezable(job._typeid);
        this.dest = job._result == null ? null : KeyV3.make(dest_type.makeSchema(), job._result);
        return this;
    }

    public static enum Status {
        RUNNING,
        DONE,
        STOPPING,
        CANCELLED,
        FAILED;

    }
}

