/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import java.util.Arrays;
import java.util.HashMap;
import water.MemoryManager;
import water.fvec.Chunk;
import water.fvec.NewChunk;
import water.parser.BufferedString;
import water.util.UnsafeUtils;

public class CStrChunk
extends Chunk {
    static final int NA = -1;
    protected static final int _OFF = 5;
    private int _valstart;
    public boolean _isAllASCII = false;

    public CStrChunk() {
    }

    public CStrChunk(int sslen, byte[] ss, int sparseLen, int idxLen, int[] id, int[] is, boolean isAllASCII) {
        this._start = -1L;
        this._valstart = this.idx(idxLen);
        this._isAllASCII = isAllASCII;
        this._len = idxLen;
        this._mem = MemoryManager.malloc1(this._valstart + sslen, false);
        UnsafeUtils.set4(this._mem, 0, this._valstart);
        UnsafeUtils.set1(this._mem, 4, (byte)(isAllASCII ? 1 : 0));
        Arrays.fill(this._mem, 5, this._valstart, (byte)-1);
        for (int i = 0; i < sparseLen; ++i) {
            UnsafeUtils.set4(this._mem, this.idx(id == null ? i : id[i]), is[i]);
        }
        UnsafeUtils.copyMemory(ss, 0L, this._mem, this._valstart, sslen);
    }

    private int idx(int i) {
        return 5 + (i << 2);
    }

    @Override
    public boolean setNA_impl(int idx) {
        return false;
    }

    @Override
    public boolean set_impl(int idx, float f) {
        if (Float.isNaN(f)) {
            return false;
        }
        throw new IllegalArgumentException("Operation not allowed on string vector.");
    }

    @Override
    public boolean set_impl(int idx, double d) {
        if (Double.isNaN(d)) {
            return false;
        }
        throw new IllegalArgumentException("Operation not allowed on string vector.");
    }

    @Override
    public boolean set_impl(int idx, long l) {
        throw new IllegalArgumentException("Operation not allowed on string vector.");
    }

    @Override
    public boolean set_impl(int idx, String str) {
        return false;
    }

    @Override
    public boolean isNA_impl(int idx) {
        int off = UnsafeUtils.get4(this._mem, this.idx(idx));
        return off == -1;
    }

    @Override
    public long at8_impl(int idx) {
        throw new IllegalArgumentException("Operation not allowed on string vector.");
    }

    @Override
    public double atd_impl(int idx) {
        throw new IllegalArgumentException("Operation not allowed on string vector.");
    }

    @Override
    public BufferedString atStr_impl(BufferedString bStr, int idx) {
        int off = UnsafeUtils.get4(this._mem, this.idx(idx));
        if (off == -1) {
            return null;
        }
        int len = 0;
        while (this._mem[this._valstart + off + len] != 0) {
            ++len;
        }
        return bStr.set(this._mem, this._valstart + off, len);
    }

    @Override
    protected final void initFromBytes() {
        this._start = -1L;
        this._cidx = -1;
        this._valstart = UnsafeUtils.get4(this._mem, 0);
        byte b = UnsafeUtils.get1(this._mem, 4);
        this._isAllASCII = b != 0;
        this.set_len(this._valstart - 5 >> 2);
    }

    @Override
    public NewChunk inflate_impl(NewChunk nc) {
        nc.set_sparseLen(nc.set_len(this._len));
        nc._isAllASCII = this._isAllASCII;
        int[] ids = nc.alloc_str_indices(this._len);
        for (int i = 0; i < this._len; ++i) {
            ids[i] = UnsafeUtils.get4(this._mem, this.idx(i));
        }
        nc._sslen = this._mem.length - this._valstart;
        nc._ss = MemoryManager.malloc1(nc._sslen);
        System.arraycopy(this._mem, this._valstart, nc._ss, 0, nc._sslen);
        return nc;
    }

    public NewChunk asciiToLower(NewChunk nc) {
        nc = this.inflate_impl(nc);
        for (int i = 0; i < nc._sslen; ++i) {
            if (nc._ss[i] <= 64 || nc._ss[i] >= 91) continue;
            int n = i;
            nc._ss[n] = (byte)(nc._ss[n] + 32);
        }
        return nc;
    }

    public NewChunk asciiToUpper(NewChunk nc) {
        nc = this.inflate_impl(nc);
        for (int i = 0; i < nc._sslen; ++i) {
            if (nc._ss[i] <= 96 || nc._ss[i] >= 123) continue;
            int n = i;
            nc._ss[n] = (byte)(nc._ss[n] - 32);
        }
        return nc;
    }

    public NewChunk asciiTrim(NewChunk nc) {
        nc = this.inflate_impl(nc);
        for (int i = 0; i < this._len; ++i) {
            int j = 0;
            int off = UnsafeUtils.get4(this._mem, this.idx(i));
            if (off == -1) continue;
            while (this._mem[this._valstart + off + j] > 0 && this._mem[this._valstart + off + j] < 33) {
                ++j;
            }
            if (j > 0) {
                nc.set_is(i, off + j);
            }
            while (this._mem[this._valstart + off + j] != 0) {
                ++j;
            }
            --j;
            while (this._mem[this._valstart + off + j] > 0 && this._mem[this._valstart + off + j] < 33) {
                nc._ss[off + j] = 0;
                --j;
            }
        }
        return nc;
    }

    public NewChunk asciiSubstring(NewChunk nc, int startIndex, int endIndex) {
        nc = this.inflate_impl(nc);
        for (int i = 0; i < this._len; ++i) {
            int off = UnsafeUtils.get4(this._mem, this.idx(i));
            if (off == -1) continue;
            int len = 0;
            while (this._mem[this._valstart + off + len] != 0) {
                ++len;
            }
            nc.set_is(i, startIndex < len ? off + startIndex : off + len);
            while (len > endIndex - 1) {
                nc._ss[off + len] = 0;
                --len;
            }
        }
        return nc;
    }

    public NewChunk asciiLength(NewChunk nc) {
        nc.alloc_mantissa(this._len);
        nc.alloc_exponent(this._len);
        for (int i = 0; i < this._len; ++i) {
            int off = UnsafeUtils.get4(this._mem, this.idx(i));
            int len = 0;
            if (off != -1) {
                while (this._mem[this._valstart + off + len] != 0) {
                    ++len;
                }
                nc.addNum(len, 0);
                continue;
            }
            nc.addNA();
        }
        return nc;
    }

    public NewChunk asciiEntropy(NewChunk nc) {
        nc.alloc_doubles(this._len);
        for (int i = 0; i < this._len; ++i) {
            int off = UnsafeUtils.get4(this._mem, this.idx(i));
            if (off != -1) {
                HashMap<Byte, Integer> freq = new HashMap<Byte, Integer>();
                int j = 0;
                while (this._mem[this._valstart + off + j] != 0) {
                    Integer count = (Integer)freq.get(this._mem[this._valstart + off + j]);
                    if (count == null) {
                        freq.put(this._mem[this._valstart + off + j], 1);
                    } else {
                        freq.put(this._mem[this._valstart + off + j], count + 1);
                    }
                    ++j;
                }
                double sume = 0.0;
                int N = j;
                for (Byte b : freq.keySet()) {
                    double n = ((Integer)freq.get(b)).intValue();
                    sume += -n / (double)N * Math.log(n / (double)N) / Math.log(2.0);
                }
                nc.addNum(sume);
                continue;
            }
            nc.addNA();
        }
        return nc;
    }

    public NewChunk asciiLStrip(NewChunk nc, String set) {
        nc = this.inflate_impl(nc);
        for (int i = 0; i < this._len; ++i) {
            int j = 0;
            int off = UnsafeUtils.get4(this._mem, this.idx(i));
            if (off == -1) continue;
            while (this.intersects(this._mem[this._valstart + off + j], set)) {
                ++j;
            }
            if (j <= 0) continue;
            nc.set_is(i, off + j);
        }
        return nc;
    }

    public NewChunk asciiRStrip(NewChunk nc, String set) {
        nc = this.inflate_impl(nc);
        for (int i = 0; i < this._len; ++i) {
            int j = 0;
            int off = UnsafeUtils.get4(this._mem, this.idx(i));
            if (off == -1) continue;
            while (this._mem[this._valstart + off + j] != 0) {
                ++j;
            }
            --j;
            while (this.intersects(this._mem[this._valstart + off + j], set)) {
                nc._ss[off + j] = 0;
                --j;
            }
        }
        return nc;
    }

    private boolean intersects(byte c, String set) {
        for (int i = 0; i < set.length(); ++i) {
            if (c != set.charAt(i)) continue;
            return true;
        }
        return false;
    }
}

