/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import java.util.Iterator;
import water.H2O;
import water.fvec.CXIChunk;
import water.fvec.NewChunk;
import water.util.UnsafeUtils;

public final class CX0Chunk
extends CXIChunk {
    protected CX0Chunk(int len, byte[] buf) {
        super(len, 0, buf);
    }

    @Override
    protected final long at8_impl(int idx) {
        return this.getId(this.findOffset(idx)) == idx ? 1L : 0L;
    }

    @Override
    protected final double atd_impl(int idx) {
        return this.at8_impl(idx);
    }

    @Override
    protected final boolean isNA_impl(int i) {
        return false;
    }

    @Override
    double min() {
        return 0.0;
    }

    @Override
    double max() {
        return 1.0;
    }

    @Override
    public boolean hasNA() {
        return false;
    }

    @Override
    public int asSparseDoubles(double[] vals, int[] ids, double NA) {
        if (vals.length < this._sparseLen) {
            throw new IllegalArgumentException();
        }
        int off = 6;
        int inc = this._ridsz;
        if (this._ridsz == 2) {
            int i = 0;
            while (i < this._sparseLen) {
                ids[i] = UnsafeUtils.get2(this._mem, off) & 0xFFFF;
                vals[i] = 1.0;
                ++i;
                off += inc;
            }
        } else if (this._ridsz == 4) {
            int i = 0;
            while (i < this._sparseLen) {
                ids[i] = UnsafeUtils.get4(this._mem, off);
                vals[i] = 1.0;
                ++i;
                off += inc;
            }
        } else {
            throw H2O.unimpl();
        }
        return this.sparseLenZero();
    }

    @Override
    public NewChunk inflate_impl(NewChunk nc) {
        nc.alloc_mantissa(this._sparseLen);
        nc.alloc_exponent(this._sparseLen);
        nc.alloc_indices(this._sparseLen);
        for (int i = 0; i < this._sparseLen; ++i) {
            nc.addNum(1L, 0);
        }
        this.nonzeros(nc.indices());
        nc.set_len(this._len);
        assert (nc._sparseLen == this._sparseLen);
        return nc;
    }

    @Override
    public Iterator<CXIChunk.Value> values() {
        return new CXIChunk.SparseIterator(new CXIChunk.Value(){

            @Override
            public final long asLong() {
                return 1L;
            }

            @Override
            public final double asDouble() {
                return 1.0;
            }

            @Override
            public final boolean isNA() {
                return false;
            }
        });
    }
}

