/*
 * Decompiled with CFR 0.152.
 */
package water.init;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import water.util.FileUtils;

public abstract class AbstractBuildVersion {
    static String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    static int TOO_OLD_THRESHOLD = 100;
    static String LATEST_STABLE_URL = " http://h2o-release.s3.amazonaws.com/h2o/latest_stable";
    static Pattern VERSION_EXTRACT_PATTERN = Pattern.compile(".*h2o-(.*).zip");
    public static final AbstractBuildVersion UNKNOWN_VERSION = new AbstractBuildVersion(){

        @Override
        public String projectVersion() {
            return "(unknown)";
        }

        @Override
        public String lastCommitHash() {
            return "(unknown)";
        }

        @Override
        public String describe() {
            return "(unknown)";
        }

        @Override
        public String compiledOn() {
            return "(unknown)";
        }

        @Override
        public String compiledBy() {
            return "(unknown)";
        }

        @Override
        public String branchName() {
            return "(unknown)";
        }
    };

    public abstract String branchName();

    public abstract String lastCommitHash();

    public abstract String describe();

    public abstract String projectVersion();

    public abstract String compiledOn();

    public abstract String compiledBy();

    public String toString() {
        return "H2O v" + this.projectVersion() + " (" + this.branchName() + " - " + this.lastCommitHash() + ")";
    }

    public String buildNumber() {
        String pv = this.projectVersion();
        if (pv.equals("(unknown")) {
            return "(unknown)";
        }
        String[] split_pv = pv.split("\\.");
        String bn = split_pv[split_pv.length - 1];
        return bn;
    }

    public final Date compiledOnDate() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        try {
            return dateFormat.parse(this.compiledOn());
        }
        catch (ParseException e) {
            return null;
        }
    }

    public final boolean isTooOld() {
        Date compileTime = this.compiledOnDate();
        if (compileTime == null) {
            return false;
        }
        long timeDiff = System.currentTimeMillis() - compileTime.getTime();
        long days = timeDiff / 86400000L;
        return days > (long)TOO_OLD_THRESHOLD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLatestH2OVersion() {
        String string;
        InputStream is = null;
        try {
            URL url = new URL(LATEST_STABLE_URL);
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(1000);
            conn.setReadTimeout(1000);
            is = conn.getInputStream();
            string = AbstractBuildVersion.extractVersionFromUrl(IOUtils.toString((InputStream)is));
        }
        catch (Exception e) {
            String string2;
            try {
                string2 = "unknown";
            }
            catch (Throwable throwable) {
                FileUtils.close(is);
                throw throwable;
            }
            FileUtils.close(is);
            return string2;
        }
        FileUtils.close(is);
        return string;
    }

    private static String extractVersionFromUrl(String downloadUrl) {
        Matcher m = VERSION_EXTRACT_PATTERN.matcher(downloadUrl);
        if (m.find()) {
            return m.group(1);
        }
        return "unknown";
    }
}

