/*
 * Decompiled with CFR 0.152.
 */
package water.udf;

import water.fvec.Chunk;
import water.fvec.RawChunk;
import water.fvec.Vec;
import water.udf.Column;
import water.udf.DependentChunk;
import water.udf.FunColumnBase;
import water.udf.TypedChunk;
import water.udf.fp.Function2;
import water.udf.fp.Functions;

public class Fun2Column<X, Y, Z>
extends FunColumnBase<Z> {
    private final Function2<X, Y, Z> f;
    private final Column<X> xs;
    private final Column<Y> ys;

    @Override
    public int rowLayout() {
        return this.xs.rowLayout();
    }

    public Fun2Column() {
        this.f = null;
        this.xs = null;
        this.ys = null;
    }

    public Fun2Column(Function2<X, Y, Z> f, Column<X> xs, Column<Y> ys) {
        super(xs);
        this.f = f;
        this.xs = xs;
        this.ys = ys;
        assert (xs.isCompatibleWith(ys)) : "Columns must be compatible: " + xs + ", " + ys;
    }

    @Override
    public Z get(long idx) {
        return this.isNA(idx) ? null : (Z)this.f.apply(this.xs.apply(idx), this.ys.apply(idx));
    }

    @Override
    public TypedChunk<Z> chunkAt(int i) {
        return new FunChunk(this.xs.chunkAt(i), this.ys.chunkAt(i));
    }

    @Override
    public boolean isNA(long idx) {
        return this.xs.isNA(idx) || this.ys.isNA(idx);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Fun2Column) {
            Fun2Column other = (Fun2Column)o;
            return Functions.equal(this.f, other.f) && this.xs.equals(other.xs);
        }
        return false;
    }

    public int hashCode() {
        return 61 * this.xs.hashCode() + Functions.hashCode(this.f);
    }

    public String toString() {
        return "Fun2Column(" + this.f.getClass().getSimpleName() + "," + this.xs + "," + this.ys + ")";
    }

    public class FunChunk
    extends DependentChunk<Z> {
        private final TypedChunk<X> cx;
        private final TypedChunk<Y> cy;
        private RawChunk myChunk;

        @Override
        public Chunk rawChunk() {
            return this.myChunk;
        }

        @Override
        public Vec vec() {
            return Fun2Column.this.vec();
        }

        public FunChunk(TypedChunk<X> cx, TypedChunk<Y> cy) {
            super(cx);
            this.myChunk = new RawChunk(this);
            this.cx = cx;
            this.cy = cy;
        }

        @Override
        public boolean isNA(int i) {
            return this.cx.isNA(i) || this.cy.isNA(i);
        }

        @Override
        public Z get(int i) {
            return Fun2Column.this.f.apply(this.cx.get(i), this.cy.get(i));
        }
    }
}

