/*
 * Decompiled with CFR 0.152.
 */
package water.udf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import water.H2O;
import water.udf.Column;
import water.udf.FunColumnBase;
import water.udf.TypedChunk;
import water.udf.fp.Functions;
import water.udf.fp.Unfoldable;

public class UnfoldingColumn<X, Y>
extends FunColumnBase<List<Y>> {
    private final Unfoldable<X, Y> f;
    private final Column<X> column;
    private int requiredSize;

    @Override
    public long size() {
        return this.column.size();
    }

    @Override
    public int rowLayout() {
        return this.column.rowLayout();
    }

    public UnfoldingColumn() {
        this.f = null;
        this.column = null;
    }

    public UnfoldingColumn(Unfoldable<X, Y> f, Column<X> column) {
        super(column);
        this.f = f;
        this.column = column;
        this.requiredSize = 0;
    }

    public UnfoldingColumn(Unfoldable<X, Y> f, Column<X> column, int requiredSize) {
        super(column);
        this.f = f;
        this.column = column;
        this.requiredSize = requiredSize;
    }

    @Override
    public List<Y> get(long idx) {
        List raw;
        List list = raw = this.isNA(idx) ? Collections.emptyList() : (List)this.f.apply(this.column.apply(idx));
        if (this.requiredSize == 0 || raw.size() == this.requiredSize) {
            return raw;
        }
        List result = raw.subList(0, Math.min(raw.size(), this.requiredSize));
        if (result.size() < this.requiredSize) {
            ArrayList fullResult = new ArrayList(this.requiredSize);
            fullResult.addAll(result);
            for (int i = result.size(); i < this.requiredSize; ++i) {
                fullResult.add(null);
            }
            return fullResult;
        }
        return result;
    }

    @Override
    public List<Y> apply(long idx) {
        return this.get(idx);
    }

    @Override
    public List<Y> apply(Long idx) {
        return this.get(idx);
    }

    @Override
    public TypedChunk<List<Y>> chunkAt(int i) {
        throw H2O.unimpl("Will have to think how to implement multi-string chunks...");
    }

    @Override
    public boolean isNA(long idx) {
        return this.column.isNA(idx);
    }

    public static String join(String delimiter, Iterable<?> xs) {
        StringBuilder sb = new StringBuilder();
        for (Object x : xs) {
            if (sb.length() > 0) {
                sb.append(delimiter);
            }
            sb.append(x);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof UnfoldingColumn) {
            UnfoldingColumn that = (UnfoldingColumn)o;
            return this.requiredSize == that.requiredSize && Functions.equal(this.f, that.f) && this.column.equals(that.column);
        }
        return false;
    }

    public int hashCode() {
        int result = 61 * this.column.hashCode() + Functions.hashCode(this.f);
        return 19 * result + this.requiredSize;
    }
}

