/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import water.AutoBuffer;
import water.Freezable;
import water.H2O;
import water.Iced;
import water.nbhm.NonBlockingHashMap;
import water.util.IcedHashMapBase;

public class IcedHashMap<K, V>
extends IcedHashMapBase<K, V>
implements ConcurrentMap<K, V> {
    transient NonBlockingHashMap<K, V> _map;

    public IcedHashMap() {
        this.init();
    }

    @Override
    protected Map<K, V> map() {
        return this._map;
    }

    @Override
    protected Map<K, V> init() {
        this._map = new NonBlockingHashMap();
        return this._map;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this._map.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this._map.remove(key, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this._map.replace(key, oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        return this._map.replace(key, value);
    }

    public K getk(K key) {
        return this._map.getk(key);
    }

    @Override
    protected void writeMap(AutoBuffer ab, int mode) {
        Object[] kvs = this._map.raw_array();
        switch (mode) {
            case 1: {
                for (int i = 2; i < kvs.length; i += 2) {
                    if (!(kvs[i] instanceof String) || !(kvs[i + 1] instanceof String)) continue;
                    ab.putStr((String)kvs[i]).putStr((String)kvs[i + 1]);
                }
                break;
            }
            case 2: {
                for (int i = 2; i < kvs.length; i += 2) {
                    if (!(kvs[i] instanceof String) || !(kvs[i + 1] instanceof Iced)) continue;
                    ab.putStr((String)kvs[i]).put((Freezable)kvs[i + 1]);
                }
                break;
            }
            case 3: {
                for (int i = 2; i < kvs.length; i += 2) {
                    if (!(kvs[i] instanceof Iced) || !(kvs[i + 1] instanceof String)) continue;
                    ab.put((Freezable)kvs[i]).putStr((String)kvs[i + 1]);
                }
                break;
            }
            case 4: {
                for (int i = 2; i < kvs.length; i += 2) {
                    if (!(kvs[i] instanceof Freezable) || !(kvs[i + 1] instanceof Freezable)) continue;
                    ab.put((Freezable)kvs[i]).put((Freezable)kvs[i + 1]);
                }
                break;
            }
            case 5: {
                for (int i = 2; i < kvs.length; i += 2) {
                    if (!(kvs[i] instanceof String) || !(kvs[i + 1] instanceof Freezable[])) continue;
                    Freezable[] vals = (Freezable[])kvs[i + 1];
                    ab.putStr((String)kvs[i]).put4(vals.length);
                    for (Freezable v : vals) {
                        ab.put(v);
                    }
                }
                break;
            }
            case 6: {
                for (int i = 2; i < kvs.length; i += 2) {
                    if (!(kvs[i] instanceof Freezable) || !(kvs[i + 1] instanceof Freezable[])) continue;
                    Freezable[] vals = (Freezable[])kvs[i + 1];
                    ab.put((Freezable)kvs[i]).put4(vals.length);
                    for (Freezable v : vals) {
                        ab.put(v);
                    }
                }
                break;
            }
            default: {
                throw H2O.fail();
            }
        }
    }
}

