/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import water.H2O;
import water.Iced;
import water.MRTask;

public class ProfileCollectorTask
extends MRTask<ProfileCollectorTask> {
    public final int _stack_depth;
    public NodeProfile[] _result;

    public ProfileCollectorTask(int stack_depth) {
        super((byte)119);
        this._stack_depth = stack_depth;
    }

    @Override
    public void reduce(ProfileCollectorTask that) {
        for (int i = 0; i < this._result.length; ++i) {
            if (this._result[i] != null) continue;
            this._result[i] = that._result[i];
        }
    }

    @Override
    public void setupLocal() {
        int i;
        int idx = H2O.SELF.index();
        this._result = new NodeProfile[H2O.CLOUD.size()];
        HashMap<String, Integer> countedStackTraces = new HashMap<String, Integer>();
        int repeats = 100;
        for (i = 0; i < 100; ++i) {
            Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
            for (Map.Entry<Thread, StackTraceElement[]> el : allStackTraces.entrySet()) {
                StringBuilder sb = new StringBuilder();
                int j = 0;
                for (StackTraceElement stackTraceElement : el.getValue()) {
                    String val = stackTraceElement.toString();
                    if (j == 0 && (val.equals("sun.misc.Unsafe.park(Native Method)") || val.equals("java.lang.Object.wait(Native Method)") || val.equals("java.lang.Thread.sleep(Native Method)") || val.equals("java.lang.Thread.yield(Native Method)") || val.equals("java.net.PlainSocketImpl.socketAccept(Native Method)") || val.equals("sun.nio.ch.ServerSocketChannelImpl.accept0(Native Method)") || val.equals("sun.nio.ch.DatagramChannelImpl.receive0(Native Method)") || val.equals("java.lang.Thread.dumpThreads(Native Method)"))) break;
                    sb.append(stackTraceElement.toString());
                    sb.append("\n");
                    if (++j == this._stack_depth) break;
                }
                String st = sb.toString();
                boolean found = false;
                for (Map.Entry entry : countedStackTraces.entrySet()) {
                    if (!((String)entry.getKey()).equals(st)) continue;
                    entry.setValue((Integer)entry.getValue() + 1);
                    found = true;
                    break;
                }
                if (found) continue;
                countedStackTraces.put(st, 1);
            }
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        i = 0;
        this._result[idx] = new NodeProfile(countedStackTraces.size());
        this._result[idx].node_name = H2O.getIpPortString();
        this._result[idx].timestamp = System.currentTimeMillis();
        for (Map.Entry entry : countedStackTraces.entrySet()) {
            this._result[idx].stacktraces[i] = (String)entry.getKey();
            this._result[idx].counts[i] = (Integer)entry.getValue();
            ++i;
        }
        TreeMap sorted = new TreeMap(Collections.reverseOrder());
        for (int j = 0; j < this._result[idx].counts.length; ++j) {
            if (this._result[idx].stacktraces[j] == null || this._result[idx].stacktraces[j].length() <= 0) continue;
            sorted.put(this._result[idx].counts[j], this._result[idx].stacktraces[j]);
        }
        String[] sorted_stacktraces = new String[sorted.entrySet().size()];
        int[] sorted_counts = new int[sorted.entrySet().size()];
        i = 0;
        for (Map.Entry e : sorted.entrySet()) {
            sorted_stacktraces[i] = (String)e.getValue();
            sorted_counts[i] = (Integer)e.getKey();
            ++i;
        }
        this._result[idx].stacktraces = sorted_stacktraces;
        this._result[idx].counts = sorted_counts;
    }

    public static class NodeProfile
    extends Iced {
        public String node_name;
        public long timestamp;
        public String[] stacktraces;
        public int[] counts;

        NodeProfile(int len) {
            this.stacktraces = new String[len];
            this.counts = new int[len];
        }
    }
}

