/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collections;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.plus.jaas.JAASLoginService;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.bio.SocketConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import water.H2O;
import water.H2OError;
import water.Iced;
import water.api.DatasetServlet;
import water.api.NpsBinServlet;
import water.api.PostFileServlet;
import water.api.RequestServer;
import water.api.schemas3.H2OErrorV3;
import water.exceptions.H2OAbstractRuntimeException;
import water.exceptions.H2OFailException;
import water.util.HttpResponseStatus;
import water.util.Log;

public class JettyHTTPD {
    private static final ThreadLocal<Long> _startMillis = new ThreadLocal();
    private static final ThreadLocal<Integer> _status = new ThreadLocal();
    private static final ThreadLocal<String> _userAgent = new ThreadLocal();
    private static volatile boolean _acceptRequests = false;
    private String _ip;
    private int _port;
    private Server _server;

    private static void startRequestLifecycle() {
        _startMillis.set(System.currentTimeMillis());
        _status.set(999);
    }

    private static void setStatus(int sc) {
        _status.set(sc);
    }

    private static int getStatus() {
        return _status.get();
    }

    protected static long getStartMillis() {
        return _startMillis.get();
    }

    public static void startTransaction(String userAgent) {
        _userAgent.set(userAgent);
    }

    public static void endTransaction() {
        _userAgent.remove();
    }

    public static String getUserAgent() {
        return _userAgent.get();
    }

    public static void setResponseStatus(HttpServletResponse response, int sc) {
        JettyHTTPD.setStatus(sc);
        response.setStatus(sc);
    }

    public static void sendResponseError(HttpServletResponse response, int sc, String msg) throws IOException {
        JettyHTTPD.setStatus(sc);
        response.sendError(sc, msg);
    }

    public String getScheme() {
        if (H2O.ARGS.jks != null) {
            return "https";
        }
        return "http";
    }

    public int getPort() {
        return this._port;
    }

    public String getIp() {
        return this._ip;
    }

    public Server getServer() {
        return this._server;
    }

    public void setServer(Server value) {
        this._server = value;
    }

    public void setup(String ip, int port) {
        this._ip = ip;
        this._port = port;
        System.setProperty("org.eclipse.jetty.server.Request.maxFormContentSize", Integer.toString(Integer.MAX_VALUE));
    }

    public void start(String ip, int port) throws Exception {
        this.setup(ip, port);
        if (H2O.ARGS.jks != null) {
            this.startHttps();
        } else {
            this.startHttp();
        }
    }

    public void acceptRequests() {
        _acceptRequests = true;
    }

    protected void createServer(Connector connector) throws Exception {
        this._server.setConnectors(new Connector[]{connector});
        if (H2O.ARGS.hash_login || H2O.ARGS.ldap_login || H2O.ARGS.kerberos_login) {
            HashLoginService loginService;
            if (H2O.ARGS.login_conf == null) {
                Log.err("Must specify -login_conf argument");
                H2O.exit(1);
            }
            if (H2O.ARGS.hash_login) {
                Log.info("Configuring HashLoginService");
                loginService = new HashLoginService("H2O", H2O.ARGS.login_conf);
            } else if (H2O.ARGS.ldap_login) {
                Log.info("Configuring JAASLoginService (with LDAP)");
                System.setProperty("java.security.auth.login.config", H2O.ARGS.login_conf);
                loginService = new JAASLoginService("ldaploginmodule");
            } else if (H2O.ARGS.kerberos_login) {
                Log.info("Configuring JAASLoginService (with Kerberos)");
                System.setProperty("java.security.auth.login.config", H2O.ARGS.login_conf);
                loginService = new JAASLoginService("krb5loginmodule");
            } else {
                throw H2O.fail();
            }
            DefaultIdentityService identityService = new DefaultIdentityService();
            loginService.setIdentityService((IdentityService)identityService);
            this._server.addBean((Object)loginService);
            ConstraintSecurityHandler security = new ConstraintSecurityHandler();
            Constraint constraint = new Constraint();
            constraint.setName("auth");
            constraint.setAuthenticate(true);
            security.setStrict(false);
            constraint.setRoles(new String[]{"*"});
            ConstraintMapping mapping = new ConstraintMapping();
            mapping.setPathSpec("/*");
            mapping.setConstraint(constraint);
            security.setConstraintMappings(Collections.singletonList(mapping));
            security.setAuthenticator((Authenticator)new BasicAuthenticator());
            security.setLoginService((LoginService)loginService);
            this.registerHandlers((HandlerWrapper)security);
            this._server.setHandler((Handler)security);
        } else {
            this.registerHandlers((HandlerWrapper)this._server);
        }
        this._server.start();
    }

    protected void startHttp() throws Exception {
        this._server = new Server();
        SocketConnector connector = new SocketConnector();
        connector.setHost(this._ip);
        connector.setPort(this._port);
        this.createServer((Connector)connector);
    }

    private void startHttps() throws Exception {
        this._server = new Server();
        SslContextFactory sslContextFactory = new SslContextFactory(H2O.ARGS.jks);
        sslContextFactory.setKeyStorePassword(H2O.ARGS.jks_pass);
        SslSocketConnector httpsConnector = new SslSocketConnector(sslContextFactory);
        if (this.getIp() != null) {
            httpsConnector.setHost(this.getIp());
        }
        httpsConnector.setPort(this.getPort());
        this.createServer((Connector)httpsConnector);
    }

    public void stop() throws Exception {
        if (this._server != null) {
            this._server.stop();
        }
    }

    public void registerHandlers(HandlerWrapper handlerWrapper) {
        ServletContextHandler context = new ServletContextHandler(3);
        if (null != H2O.ARGS.context_path && !H2O.ARGS.context_path.isEmpty()) {
            context.setContextPath(H2O.ARGS.context_path);
        } else {
            context.setContextPath("/");
        }
        context.addServlet(NpsBinServlet.class, "/3/NodePersistentStorage.bin/*");
        context.addServlet(PostFileServlet.class, "/3/PostFile.bin");
        context.addServlet(PostFileServlet.class, "/3/PostFile");
        context.addServlet(DatasetServlet.class, "/3/DownloadDataset");
        context.addServlet(DatasetServlet.class, "/3/DownloadDataset.bin");
        context.addServlet(RequestServer.class, "/");
        HandlerCollection hc = new HandlerCollection();
        hc.setHandlers(new Handler[]{new GateHandler(), new AuthenticationHandler(), new ExtensionHandler1(), context});
        handlerWrapper.setHandler((Handler)hc);
    }

    protected void handle1(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
    }

    public static InputStream extractPartInputStream(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String ct = request.getContentType();
        if (!ct.startsWith("multipart/form-data")) {
            JettyHTTPD.setResponseStatus(response, 400);
            response.getWriter().write("Content type must be multipart/form-data");
            return null;
        }
        int idx = ct.indexOf("boundary=");
        if (idx < 0) {
            JettyHTTPD.setResponseStatus(response, 400);
            response.getWriter().write("Boundary missing");
            return null;
        }
        String boundaryString = ct.substring(idx + "boundary=".length());
        byte[] boundary = boundaryString.getBytes();
        ServletInputStream is = request.getInputStream();
        String line = JettyHTTPD.readLine((InputStream)is);
        while (line != null && line.trim().length() > 0) {
            line = JettyHTTPD.readLine((InputStream)is);
        }
        return new InputStreamWrapper((InputStream)is, boundary);
    }

    public static boolean validKeyName(String name) {
        byte[] arr;
        for (byte b : arr = name.getBytes()) {
            if (b == 34) {
                return false;
            }
            if (b != 92) continue;
            return false;
        }
        return true;
    }

    public static void sendErrorResponse(HttpServletResponse response, Exception e, String uri) {
        if (e instanceof H2OFailException) {
            H2OFailException ee = (H2OFailException)e;
            H2OError error = ee.toH2OError(uri);
            Log.fatal("Caught exception (fatal to the cluster): " + error.toString());
            throw H2O.fail(error.toString());
        }
        if (e instanceof H2OAbstractRuntimeException) {
            H2OAbstractRuntimeException ee = (H2OAbstractRuntimeException)e;
            H2OError error = ee.toH2OError(uri);
            Log.warn("Caught exception: " + error.toString());
            JettyHTTPD.setResponseStatus(response, 500);
            try {
                String s = ((Iced)new H2OErrorV3().fillFromImpl(error)).toJsonString();
                response.getWriter().write(s);
            }
            catch (Exception ignore) {
                ignore.printStackTrace();
            }
        } else {
            H2OError error = new H2OError(e, uri);
            if (e instanceof IllegalArgumentException) {
                error._http_status = HttpResponseStatus.BAD_REQUEST.getCode();
            } else if (e instanceof FileNotFoundException) {
                error._http_status = HttpResponseStatus.BAD_REQUEST.getCode();
            } else if (e instanceof MalformedURLException) {
                error._http_status = HttpResponseStatus.BAD_REQUEST.getCode();
            }
            JettyHTTPD.setResponseStatus(response, error._http_status);
            Log.warn("Caught exception: " + error.toString());
            try {
                String s = ((Iced)new H2OErrorV3().fillFromImpl(error)).toJsonString();
                response.getWriter().write(s);
            }
            catch (Exception ignore) {
                ignore.printStackTrace();
            }
        }
    }

    public static String getDecodedUri(HttpServletRequest request) {
        try {
            return URLDecoder.decode(request.getRequestURI(), "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void setCommonResponseHttpHeaders(HttpServletResponse response) {
        response.setHeader("X-h2o-build-project-version", H2O.ABV.projectVersion());
        response.setHeader("X-h2o-rest-api-version-max", Integer.toString(3));
        response.setHeader("X-h2o-cluster-id", Long.toString(H2O.CLUSTER_ID));
        response.setHeader("X-h2o-cluster-good", Boolean.toString(H2O.CLOUD.healthy()));
        response.setHeader("X-h2o-context-path", JettyHTTPD.sanatizeContextPath(H2O.ARGS.context_path));
    }

    private static String sanatizeContextPath(String context_path) {
        if (null == context_path || context_path.isEmpty()) {
            return "/";
        }
        return context_path + "/";
    }

    public static void logRequest(String method, HttpServletRequest request, HttpServletResponse response) {
        Log.httpd(method, request.getRequestURI(), JettyHTTPD.getStatus(), System.currentTimeMillis() - JettyHTTPD.getStartMillis());
    }

    private static String readLine(InputStream in) throws IOException {
        int sz;
        StringBuilder sb = new StringBuilder();
        byte[] mem = new byte[1024];
        do {
            sz = JettyHTTPD.readBufOrLine(in, mem);
            sb.append(new String(mem, 0, sz));
        } while (sz >= mem.length && mem[sz - 1] != 10);
        if (sb.length() == 0) {
            return null;
        }
        String line = sb.toString();
        if (line.endsWith("\r\n")) {
            line = line.substring(0, line.length() - 2);
        } else if (line.endsWith("\n")) {
            line = line.substring(0, line.length() - 1);
        }
        return line;
    }

    private static int readBufOrLine(InputStream in, byte[] mem) throws IOException {
        byte[] bb = new byte[1];
        int sz = 0;
        while (sz != mem.length) {
            byte b2;
            byte b;
            try {
                in.read(bb, 0, 1);
                b = bb[0];
                mem[sz++] = b;
            }
            catch (EOFException e) {
                break;
            }
            if (b == 10 || sz == mem.length) break;
            if (b != 13) continue;
            try {
                in.read(bb, 0, 1);
                b2 = bb[0];
                mem[sz++] = b2;
            }
            catch (EOFException e) {
                break;
            }
            if (b2 != 10) continue;
            break;
        }
        return sz;
    }

    private static final class InputStreamWrapper
    extends InputStream {
        static final byte[] BOUNDARY_PREFIX = new byte[]{13, 10, 45, 45};
        final InputStream _wrapped;
        final byte[] _boundary;
        final byte[] _lookAheadBuf;
        int _lookAheadLen;

        public InputStreamWrapper(InputStream is, byte[] boundary) {
            this._wrapped = is;
            this._boundary = Arrays.copyOf(BOUNDARY_PREFIX, BOUNDARY_PREFIX.length + boundary.length);
            System.arraycopy(boundary, 0, this._boundary, BOUNDARY_PREFIX.length, boundary.length);
            this._lookAheadBuf = new byte[this._boundary.length];
            this._lookAheadLen = 0;
        }

        @Override
        public void close() throws IOException {
            this._wrapped.close();
        }

        @Override
        public int available() throws IOException {
            return this._wrapped.available();
        }

        @Override
        public long skip(long n) throws IOException {
            return this._wrapped.skip(n);
        }

        @Override
        public void mark(int readlimit) {
            this._wrapped.mark(readlimit);
        }

        @Override
        public void reset() throws IOException {
            this._wrapped.reset();
        }

        @Override
        public boolean markSupported() {
            return this._wrapped.markSupported();
        }

        @Override
        public int read() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int pos;
            if (this._lookAheadLen == -1) {
                return -1;
            }
            int readLen = this.readInternal(b, off, len);
            if (readLen != -1 && (pos = this.findBoundary(b, off, readLen)) != -1) {
                this._lookAheadLen = -1;
                return pos - off;
            }
            return readLen;
        }

        private int readInternal(byte[] b, int off, int len) throws IOException {
            if (len < this._lookAheadLen) {
                System.arraycopy(this._lookAheadBuf, 0, b, off, len);
                this._lookAheadLen -= len;
                System.arraycopy(this._lookAheadBuf, len, this._lookAheadBuf, 0, this._lookAheadLen);
                return len;
            }
            if (this._lookAheadLen > 0) {
                System.arraycopy(this._lookAheadBuf, 0, b, off, this._lookAheadLen);
                int r = Math.max(this._wrapped.read(b, off += this._lookAheadLen, len -= this._lookAheadLen), 0) + this._lookAheadLen;
                this._lookAheadLen = 0;
                return r;
            }
            return this._wrapped.read(b, off, len);
        }

        private int findBoundary(byte[] b, int off, int len) throws IOException {
            int bidx = -1;
            int idx = 0;
            for (int i = off; i < off + len; ++i) {
                if (this._boundary[idx] != b[i]) {
                    idx = 0;
                    bidx = -1;
                }
                if (this._boundary[idx] != b[i]) continue;
                if (idx == 0) {
                    bidx = i;
                }
                if (++idx != this._boundary.length) continue;
                return bidx;
            }
            if (bidx != -1) {
                assert (this._lookAheadLen == 0);
                this._lookAheadLen = this._boundary.length - idx;
                int readLen = this._wrapped.read(this._lookAheadBuf, 0, this._lookAheadLen);
                if (readLen < this._boundary.length - idx) {
                    this._lookAheadLen = readLen;
                    return -1;
                }
                for (int i = 0; i < this._boundary.length - idx; ++i) {
                    if (this._boundary[i + idx] == this._lookAheadBuf[i]) continue;
                    return -1;
                }
            }
            return bidx;
        }
    }

    public class AuthenticationHandler
    extends AbstractHandler {
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (!H2O.ARGS.ldap_login && !H2O.ARGS.kerberos_login) {
                return;
            }
            String loginName = request.getUserPrincipal().getName();
            if (!loginName.equals(H2O.ARGS.user_name)) {
                Log.warn("Login name (" + loginName + ") does not match cluster owner name (" + H2O.ARGS.user_name + ")");
                JettyHTTPD.sendResponseError(response, 401, "Login name does not match cluster owner name");
                baseRequest.setHandled(true);
            }
        }
    }

    public class ExtensionHandler1
    extends AbstractHandler {
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            H2O.getJetty().handle1(target, baseRequest, request, response);
        }
    }

    public class GateHandler
    extends AbstractHandler {
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) {
            JettyHTTPD.startRequestLifecycle();
            while (!_acceptRequests) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception ignore) {}
            }
            JettyHTTPD.setCommonResponseHttpHeaders(response);
        }
    }
}

