/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import jsr166y.ForkJoinPool;
import water.Cleaner;
import water.H2O;
import water.UDPRebooted;
import water.util.Log;
import water.util.PrettyPrint;

public abstract class MemoryManager {
    private static volatile long oomLastLogTimestamp = 0L;
    private static final long SIXTY_SECONDS_IN_MILLIS = 60000L;
    public static final long MEM_MAX = Runtime.getRuntime().maxMemory();
    static final HeapUsageMonitor HEAP_USAGE_MONITOR = new HeapUsageMonitor();
    static long MEM_CRITICAL;
    static volatile boolean CAN_ALLOC;
    private static volatile boolean MEM_LOW_CRITICAL;
    private static Object _lock;
    static final AtomicLong _taskMem;
    private static Object _taskMemLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setMemGood() {
        if (CAN_ALLOC) {
            return;
        }
        Object object = _lock;
        synchronized (object) {
            CAN_ALLOC = true;
            _lock.notifyAll();
        }
        Log.warn("Continuing after swapping");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setMemLow() {
        if (!H2O.ARGS.cleaner) {
            return;
        }
        if (!CAN_ALLOC) {
            return;
        }
        Object object = _lock;
        synchronized (object) {
            CAN_ALLOC = false;
        }
        Log.warn("Pausing to swap to disk; more memory may help");
    }

    static boolean canAlloc() {
        return CAN_ALLOC;
    }

    static void set_goals(String msg, boolean oom) {
        MemoryManager.set_goals(msg, oom, 0L);
    }

    static void set_goals(String msg, boolean oom, long bytes) {
        long heapUsedGC = Cleaner.HEAP_USED_AT_LAST_GC;
        long timeGC = Cleaner.TIME_AT_LAST_GC;
        long freeHeap = MEM_MAX - heapUsedGC;
        assert (freeHeap >= 0L) : "I am really confused about the heap usage; MEM_MAX=" + MEM_MAX + " heapUsedGC=" + heapUsedGC;
        long cacheUsageGC = Cleaner.KV_USED_AT_LAST_GC;
        long pojoUsedGC = Math.max(heapUsedGC - cacheUsageGC, 0L);
        long d = MEM_CRITICAL;
        long p = pojoUsedGC;
        long age = System.currentTimeMillis() - timeGC;
        age = Math.min(age, 600000L);
        while ((age -= 5000L) > 0L) {
            p -= p >> 3;
        }
        d -= 2L * p - bytes;
        d = Math.max(d, MEM_MAX >> 3);
        if (Cleaner.DESIRED != -1L) {
            Cleaner.DESIRED = d;
        }
        long cacheUsageNow = Cleaner.Histo.cached();
        boolean skipThisLogMessageToAvoidSpammingTheLogs = false;
        String m = "";
        if (cacheUsageNow > Cleaner.DESIRED) {
            String string = m = CAN_ALLOC ? "Swapping!  " : "blocked:   ";
            if (oom) {
                MemoryManager.setMemLow();
            }
            Cleaner.kick_store_cleaner();
        } else {
            MemoryManager.setMemGood();
            if (oom) {
                m = "Unblock allocations; cache below desired, but also OOM: ";
                long now = System.currentTimeMillis();
                if (now - oomLastLogTimestamp >= 60000L) {
                    oomLastLogTimestamp = now;
                } else {
                    skipThisLogMessageToAvoidSpammingTheLogs = true;
                }
            } else {
                m = "MemGood:   ";
            }
        }
        if (skipThisLogMessageToAvoidSpammingTheLogs) {
            return;
        }
        String s = m + msg + ", (K/V:" + PrettyPrint.bytes(cacheUsageGC) + " + POJO:" + PrettyPrint.bytes(pojoUsedGC) + " + FREE:" + PrettyPrint.bytes(freeHeap) + " == MEM_MAX:" + PrettyPrint.bytes(MEM_MAX) + "), desiredKV=" + PrettyPrint.bytes(Cleaner.DESIRED) + (oom ? " OOM!" : " NO-OOM");
        if (CAN_ALLOC) {
            if (oom) {
                Log.warn(s);
            } else {
                Log.debug(s);
            }
        } else {
            System.err.println(s);
        }
    }

    static Object malloc(int elems, long bytes, int type, Object orig, int from) {
        return MemoryManager.malloc(elems, bytes, type, orig, from, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object malloc(int elems, long bytes, int type, Object orig, int from, boolean force) {
        while (true) {
            if (!(MEM_LOW_CRITICAL || force || CAN_ALLOC || bytes <= 256L || Thread.currentThread() instanceof Cleaner)) {
                Object object = _lock;
                synchronized (object) {
                    try {
                        _lock.wait(300000L);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
            }
            try {
                switch (type) {
                    case 1: {
                        return new byte[elems];
                    }
                    case 2: {
                        return new short[elems];
                    }
                    case 4: {
                        return new int[elems];
                    }
                    case 8: {
                        return new long[elems];
                    }
                    case 5: {
                        return new float[elems];
                    }
                    case 9: {
                        return new double[elems];
                    }
                    case 0: {
                        return new boolean[elems];
                    }
                    case 10: {
                        return new Object[elems];
                    }
                    case -1: {
                        return Arrays.copyOfRange((byte[])orig, from, elems);
                    }
                    case -4: {
                        return Arrays.copyOfRange((int[])orig, from, elems);
                    }
                    case -8: {
                        return Arrays.copyOfRange((long[])orig, from, elems);
                    }
                    case -9: {
                        return Arrays.copyOfRange((double[])orig, from, elems);
                    }
                }
                throw H2O.fail();
            }
            catch (OutOfMemoryError e) {
                if (Cleaner.isDiskFull()) {
                    UDPRebooted.suicide(UDPRebooted.T.oom, H2O.SELF);
                }
                MemoryManager.set_goals("OOM", true, bytes);
                continue;
            }
            break;
        }
    }

    public static byte[] malloc1(int size) {
        return MemoryManager.malloc1(size, false);
    }

    public static byte[] malloc1(int size, boolean force) {
        return (byte[])MemoryManager.malloc(size, size * 1, 1, null, 0, force);
    }

    public static short[] malloc2(int size) {
        return (short[])MemoryManager.malloc(size, (long)size * 2L, 2, null, 0);
    }

    public static int[] malloc4(int size) {
        return (int[])MemoryManager.malloc(size, (long)size * 4L, 4, null, 0);
    }

    public static long[] malloc8(int size) {
        return (long[])MemoryManager.malloc(size, (long)size * 8L, 8, null, 0);
    }

    public static float[] malloc4f(int size) {
        return (float[])MemoryManager.malloc(size, (long)size * 4L, 5, null, 0);
    }

    public static double[] malloc8d(int size) {
        if (size < 32) {
            try {
                return new double[size];
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
        }
        return (double[])MemoryManager.malloc(size, (long)size * 8L, 9, null, 0);
    }

    public static double[][] malloc8d(int m, int n) {
        double[][] res = new double[m][];
        for (int i = 0; i < m; ++i) {
            res[i] = MemoryManager.malloc8d(n);
        }
        return res;
    }

    public static boolean[] mallocZ(int size) {
        return (boolean[])MemoryManager.malloc(size, size, 0, null, 0);
    }

    public static Object[] mallocObj(int size) {
        return (Object[])MemoryManager.malloc(size, (long)size * 8L, 10, null, 0, false);
    }

    public static byte[] arrayCopyOfRange(byte[] orig, int from, int sz) {
        return (byte[])MemoryManager.malloc(sz, sz - from, -1, orig, from);
    }

    public static int[] arrayCopyOfRange(int[] orig, int from, int sz) {
        return (int[])MemoryManager.malloc(sz, (sz - from) * 4, -4, orig, from);
    }

    public static long[] arrayCopyOfRange(long[] orig, int from, int sz) {
        return (long[])MemoryManager.malloc(sz, (sz - from) * 8, -8, orig, from);
    }

    public static double[] arrayCopyOfRange(double[] orig, int from, int sz) {
        return (double[])MemoryManager.malloc(sz, (sz - from) * 8, -9, orig, from);
    }

    public static byte[] arrayCopyOf(byte[] orig, int sz) {
        return MemoryManager.arrayCopyOfRange(orig, 0, sz);
    }

    public static int[] arrayCopyOf(int[] orig, int sz) {
        return MemoryManager.arrayCopyOfRange(orig, 0, sz);
    }

    public static long[] arrayCopyOf(long[] orig, int sz) {
        return MemoryManager.arrayCopyOfRange(orig, 0, sz);
    }

    public static double[] arrayCopyOf(double[] orig, int sz) {
        return MemoryManager.arrayCopyOfRange(orig, 0, sz);
    }

    static boolean tryReserveTaskMem(long m) {
        if (!CAN_ALLOC) {
            return false;
        }
        if (m == 0L) {
            return true;
        }
        assert (m >= 0L) : "m < 0: " + m;
        long current = _taskMem.addAndGet(-m);
        if (current < 0L) {
            _taskMem.addAndGet(m);
            return false;
        }
        return true;
    }

    static void reserveTaskMem(long m) {
        final long bytes = m;
        while (!MemoryManager.tryReserveTaskMem(bytes)) {
            try {
                ForkJoinPool.managedBlock(new ForkJoinPool.ManagedBlocker(){

                    @Override
                    public boolean isReleasable() {
                        return _taskMem.get() >= bytes;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public boolean block() throws InterruptedException {
                        Object object = _taskMemLock;
                        synchronized (object) {
                            try {
                                _taskMemLock.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        return this.isReleasable();
                    }
                });
            }
            catch (InterruptedException e) {
                Log.throwErr(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void freeTaskMem(long m) {
        if (m == 0L) {
            return;
        }
        _taskMem.addAndGet(m);
        Object object = _taskMemLock;
        synchronized (object) {
            _taskMemLock.notifyAll();
        }
    }

    static {
        CAN_ALLOC = true;
        MEM_LOW_CRITICAL = false;
        _lock = new Object();
        _taskMem = new AtomicLong(MEM_MAX - (MEM_MAX >> 2));
        _taskMemLock = new Object();
    }

    private static class HeapUsageMonitor
    implements NotificationListener {
        MemoryMXBean _allMemBean = ManagementFactory.getMemoryMXBean();

        HeapUsageMonitor() {
            int c = 0;
            for (MemoryPoolMXBean m : ManagementFactory.getMemoryPoolMXBeans()) {
                if (m.getType() != MemoryType.HEAP || !m.isCollectionUsageThresholdSupported() || !m.isUsageThresholdSupported()) continue;
                long gc_callback = MEM_MAX;
                while (true) {
                    try {
                        m.setCollectionUsageThreshold(gc_callback);
                    }
                    catch (IllegalArgumentException iae) {
                        gc_callback -= gc_callback >> 3;
                        continue;
                    }
                    break;
                }
                m.setCollectionUsageThreshold(1L);
                NotificationEmitter emitter = (NotificationEmitter)((Object)this._allMemBean);
                emitter.addNotificationListener(this, null, m);
                ++c;
                MEM_CRITICAL = gc_callback;
            }
            assert (c == 1);
        }

        @Override
        public void handleNotification(Notification notification, Object handback) {
            String notifType = notification.getType();
            if (!notifType.equals("java.management.memory.collection.threshold.exceeded")) {
                return;
            }
            Cleaner.TIME_AT_LAST_GC = System.currentTimeMillis();
            Cleaner.HEAP_USED_AT_LAST_GC = this._allMemBean.getHeapMemoryUsage().getUsed();
            Cleaner.KV_USED_AT_LAST_GC = Cleaner.Histo.cached();
            MEM_LOW_CRITICAL = (double)Cleaner.HEAP_USED_AT_LAST_GC > 0.75 * (double)MEM_MAX;
            Log.debug("GC CALLBACK: " + Cleaner.TIME_AT_LAST_GC + ", USED:" + PrettyPrint.bytes(Cleaner.HEAP_USED_AT_LAST_GC) + ", CRIT: " + MEM_LOW_CRITICAL);
            MemoryManager.set_goals("GC CALLBACK", MEM_LOW_CRITICAL);
        }
    }
}

