/*
 * Decompiled with CFR 0.152.
 */
package water;

import water.H2O;
import water.H2ONode;
import water.RPC;
import water.util.Log;

public class UDPTimeOutThread
extends Thread {
    public UDPTimeOutThread() {
        super("UDPTimeout");
    }

    @Override
    public void run() {
        Thread.currentThread().setPriority(5);
        while (true) {
            long currentTime = System.currentTimeMillis();
            for (H2ONode n : H2O.CLOUD._memary) {
                if (n == H2O.SELF) continue;
                for (RPC t : n.tasks()) {
                    if (H2O.CLOUD.contains(t._target) || t._target._heartbeat._client && t._retry < 1000L) {
                        if (currentTime <= t._started + t._retry || t.isDone() || t._nack) continue;
                        if (++t._resendsCnt % 10 == 0) {
                            Log.warn("Got " + t._resendsCnt + " resends on task #" + t._tasknum + ", class = " + t._dt.getClass().getSimpleName());
                        }
                        t.call();
                        continue;
                    }
                    t.cancel(true);
                }
            }
            long timeElapsed = System.currentTimeMillis() - currentTime;
            if (timeElapsed >= 1000L) continue;
            try {
                Thread.sleep(1000L - timeElapsed);
            }
            catch (InterruptedException e) {
            }
        }
    }
}

