/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import water.api.schemas3.FrameV3;
import water.api.schemas3.KeyV3;

public class H2oRestGsonHelper {
    public static Gson createH2oCompatibleGson() {
        return new GsonBuilder().registerTypeAdapter(KeyV3.class, (Object)new KeySerializer()).registerTypeAdapter(FrameV3.ColSpecifierV3.class, (Object)new ColSerializer()).create();
    }

    private static class ColSerializer
    implements JsonSerializer<FrameV3.ColSpecifierV3>,
    JsonDeserializer<FrameV3.ColSpecifierV3> {
        private ColSerializer() {
        }

        public JsonElement serialize(FrameV3.ColSpecifierV3 col, Type typeOfCol, JsonSerializationContext context) {
            return new JsonPrimitive(col.column_name);
        }

        public FrameV3.ColSpecifierV3 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            if (json.isJsonNull()) {
                return null;
            }
            return new FrameV3.ColSpecifierV3(json.getAsString());
        }
    }

    private static class KeySerializer
    implements JsonSerializer<KeyV3>,
    JsonDeserializer<KeyV3> {
        private KeySerializer() {
        }

        public JsonElement serialize(KeyV3 key, Type typeOfKey, JsonSerializationContext context) {
            return new JsonPrimitive(key.name);
        }

        public KeyV3 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            String type;
            if (json.isJsonNull()) {
                return null;
            }
            JsonObject jobj = json.getAsJsonObject();
            String string = type = jobj.get("type").getAsString();
            int n = -1;
            switch (string.hashCode()) {
                case 429416050: {
                    if (!string.equals("Key<Model>")) break;
                    n = 0;
                    break;
                }
                case 532200350: {
                    if (!string.equals("Key<Job>")) break;
                    n = 1;
                    break;
                }
                case -684331557: {
                    if (!string.equals("Key<Grid>")) break;
                    n = 2;
                    break;
                }
                case 231700654: {
                    if (!string.equals("Key<Frame>")) break;
                    n = 3;
                }
            }
            switch (n) {
                case 0: {
                    return (KeyV3)context.deserialize((JsonElement)jobj, KeyV3.ModelKeyV3.class);
                }
                case 1: {
                    return (KeyV3)context.deserialize((JsonElement)jobj, KeyV3.JobKeyV3.class);
                }
                case 2: {
                    return (KeyV3)context.deserialize((JsonElement)jobj, KeyV3.GridKeyV3.class);
                }
                case 3: {
                    return (KeyV3)context.deserialize((JsonElement)jobj, KeyV3.FrameKeyV3.class);
                }
            }
            throw new JsonParseException("Unable to deserialize key of type " + type);
        }
    }
}

