/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import water.DTask;
import water.H2O;
import water.H2ONode;
import water.RPC;
import water.api.Handler;
import water.api.schemas3.LogsV3;
import water.util.LinuxProcFileReader;
import water.util.Log;

public class LogsHandler
extends Handler {
    public LogsV3 fetch(int version, LogsV3 s) {
        int nodeidx = s.nodeidx;
        if (nodeidx < -1 || nodeidx >= H2O.CLOUD.size()) {
            throw new IllegalArgumentException("node does not exist");
        }
        String filename = s.name;
        if (filename != null && filename.contains(File.separator)) {
            throw new IllegalArgumentException("filename may not contain File.separator character");
        }
        GetLogTask t = new GetLogTask();
        t.name = filename;
        if (nodeidx == -1) {
            try {
                t.doIt();
            }
            catch (Exception e) {
                Log.err(e);
            }
        } else {
            Log.trace("GetLogTask starting to node " + nodeidx + "...");
            H2ONode node = H2O.CLOUD._memary[nodeidx];
            new RPC<GetLogTask>(node, t).call().get();
            Log.trace("GetLogTask completed to node " + nodeidx);
        }
        if (!t.success) {
            throw new RuntimeException("GetLogTask failed");
        }
        s.log = t.log;
        return s;
    }

    private static class GetLogTask
    extends DTask<GetLogTask> {
        public String name;
        public String log = null;
        public boolean success = false;

        public GetLogTask() {
            super((byte)119);
        }

        public void doIt() {
            String logPathFilename = "/undefined";
            try {
                if (this.name == null || this.name.equals("default")) {
                    this.name = "debug";
                }
                if (this.name.equals("stdout") || this.name.equals("stderr")) {
                    LinuxProcFileReader lpfr = new LinuxProcFileReader();
                    lpfr.read();
                    if (!lpfr.valid()) {
                        this.log = "This option only works for Linux hosts";
                    } else {
                        String pid = lpfr.getProcessID();
                        String fdFileName = "/proc/" + pid + "/fd/" + (this.name.equals("stdout") ? "1" : "2");
                        File f = new File(fdFileName);
                        logPathFilename = f.getCanonicalPath();
                        if (logPathFilename.startsWith("/dev")) {
                            this.log = "Unsupported when writing to console";
                        }
                        if (logPathFilename.startsWith("socket")) {
                            this.log = "Unsupported when writing to a socket";
                        }
                        if (logPathFilename.startsWith("pipe")) {
                            this.log = "Unsupported when writing to a pipe";
                        }
                        if (logPathFilename.equals(fdFileName)) {
                            this.log = "Unsupported when writing to a pipe";
                        }
                        Log.trace("LogPathFilename calculation: " + logPathFilename);
                    }
                } else if (this.name.equals("trace") || this.name.equals("debug") || this.name.equals("info") || this.name.equals("warn") || this.name.equals("error") || this.name.equals("fatal") || this.name.equals("httpd")) {
                    this.name = Log.getLogFileName(this.name);
                    try {
                        String logDir = Log.getLogDir();
                        logPathFilename = logDir + File.separator + this.name;
                    }
                    catch (Exception e) {
                        this.log = "H2O logging not configured.";
                    }
                } else {
                    throw new IllegalArgumentException("Illegal log file name requested (try 'default')");
                }
                if (this.log == null) {
                    File f = new File(logPathFilename);
                    if (!f.exists()) {
                        throw new IllegalArgumentException("File " + f + " does not exist");
                    }
                    if (!f.canRead()) {
                        throw new IllegalArgumentException("File " + f + " is not readable");
                    }
                    BufferedReader reader = new BufferedReader(new FileReader(f));
                    StringBuilder sb = new StringBuilder();
                    String line = reader.readLine();
                    while (line != null) {
                        sb.append(line);
                        sb.append("\n");
                        line = reader.readLine();
                    }
                    reader.close();
                    this.log = sb.toString();
                }
                this.success = true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void compute2() {
            this.doIt();
            this.tryComplete();
        }
    }
}

