/*
 * Decompiled with CFR 0.152.
 */
package water.api.schemas3;

import hex.ModelMetricsMultinomial;
import hex.ModelMetricsSupervised;
import water.Iced;
import water.api.API;
import water.api.SchemaServer;
import water.api.schemas3.ConfusionMatrixV3;
import water.api.schemas3.ModelMetricsBaseV3;
import water.api.schemas3.TwoDimTableV3;
import water.util.TwoDimTable;

public class ModelMetricsMultinomialV3<I extends ModelMetricsMultinomial, S extends ModelMetricsMultinomialV3<I, S>>
extends ModelMetricsBaseV3<I, S> {
    @API(help="The R^2 for this scoring run.", direction=API.Direction.OUTPUT)
    public double r2;
    @API(help="The hit ratio table for this scoring run.", direction=API.Direction.OUTPUT, level=API.Level.expert)
    public TwoDimTableV3 hit_ratio_table;
    @API(help="The ConfusionMatrix object for this scoring run.", direction=API.Direction.OUTPUT)
    public ConfusionMatrixV3 cm;
    @API(help="The logarithmic loss for this scoring run.", direction=API.Direction.OUTPUT)
    public double logloss;
    @API(help="The mean misclassification error per class.", direction=API.Direction.OUTPUT)
    public double mean_per_class_error;

    @Override
    public S fillFromImpl(I modelMetrics) {
        super.fillFromImpl((Iced)modelMetrics);
        this.logloss = ((ModelMetricsMultinomial)modelMetrics)._logloss;
        this.r2 = ((ModelMetricsSupervised)modelMetrics).r2();
        if (((ModelMetricsMultinomial)modelMetrics)._hit_ratios != null) {
            TwoDimTable table = ModelMetricsMultinomial.getHitRatioTable(((ModelMetricsMultinomial)modelMetrics)._hit_ratios);
            this.hit_ratio_table = (TwoDimTableV3)SchemaServer.schema(this.getSchemaVersion(), table).fillFromImpl(table);
        }
        if (null != ((ModelMetricsMultinomial)modelMetrics)._cm) {
            ((ModelMetricsMultinomial)modelMetrics)._cm.table();
            this.cm = (ConfusionMatrixV3)SchemaServer.schema(this.getSchemaVersion(), ((ModelMetricsMultinomial)modelMetrics)._cm).fillFromImpl(((ModelMetricsMultinomial)modelMetrics)._cm);
        }
        return (S)this;
    }
}

