/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.fvec.Chunk;
import water.fvec.NewChunk;
import water.util.UnsafeUtils;

public class C16Chunk
extends Chunk {
    static final long _LO_NA = Long.MIN_VALUE;
    static final long _HI_NA = 0L;

    C16Chunk(byte[] bs) {
        this._mem = bs;
        this._start = -1L;
        this.set_len(this._mem.length >> 4);
    }

    @Override
    protected final long at8_impl(int i) {
        throw new IllegalArgumentException("at8_abs but 16-byte UUID");
    }

    @Override
    protected final double atd_impl(int i) {
        throw new IllegalArgumentException("atd but 16-byte UUID");
    }

    @Override
    protected final boolean isNA_impl(int i) {
        return C16Chunk.isNA(this.loAt(i), this.hiAt(i));
    }

    public static boolean isNA(long lo, long hi) {
        return lo == Long.MIN_VALUE && hi == 0L;
    }

    private long loAt(int idx) {
        return UnsafeUtils.get8(this._mem, idx * 16);
    }

    private long hiAt(int idx) {
        return UnsafeUtils.get8(this._mem, idx * 16 + 8);
    }

    @Override
    protected long at16l_impl(int idx) {
        long lo = this.loAt(idx);
        if (lo == Long.MIN_VALUE && this.hiAt(idx) == 0L) {
            throw new IllegalArgumentException("at16l but value is missing at " + idx);
        }
        return lo;
    }

    @Override
    protected long at16h_impl(int idx) {
        long hi = this.hiAt(idx);
        if (hi == 0L && this.loAt(idx) == Long.MIN_VALUE) {
            throw new IllegalArgumentException("at16h but value is missing at " + idx);
        }
        return hi;
    }

    @Override
    boolean set_impl(int i, long lo, long hi) {
        if (C16Chunk.isNA(lo, hi)) {
            throw new IllegalArgumentException("Illegal uid value");
        }
        UnsafeUtils.set8(this._mem, i * 16, lo);
        UnsafeUtils.set8(this._mem, i * 16 + 8, hi);
        return true;
    }

    @Override
    boolean set_impl(int idx, long l) {
        return false;
    }

    @Override
    boolean set_impl(int i, double d) {
        return false;
    }

    @Override
    boolean set_impl(int i, float f) {
        return false;
    }

    @Override
    boolean setNA_impl(int idx) {
        return this.set_impl(idx, Long.MIN_VALUE, 0L);
    }

    @Override
    public NewChunk inflate_impl(NewChunk nc) {
        nc.set_len(nc.set_sparseLen(0));
        for (int i = 0; i < this._len; ++i) {
            long lo = this.loAt(i);
            long hi = this.hiAt(i);
            if (lo == Long.MIN_VALUE && hi == 0L) {
                nc.addNA();
                continue;
            }
            nc.addUUID(lo, hi);
        }
        return nc;
    }

    @Override
    protected final void initFromBytes() {
        this._start = -1L;
        this._cidx = -1;
        this.set_len(this._mem.length >> 4);
        assert (this._mem.length == this._len * 16);
    }
}

