/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.fvec.Chunk;
import water.fvec.NewChunk;
import water.util.PrettyPrint;
import water.util.UnsafeUtils;

public class C2SChunk
extends Chunk {
    protected static final int _OFF = 16;
    private transient double _scale;
    private transient long _bias;

    public double scale() {
        return this._scale;
    }

    @Override
    public boolean hasFloat() {
        return this._scale != (double)((long)this._scale);
    }

    C2SChunk(byte[] bs, long bias, double scale) {
        this._mem = bs;
        this._start = -1L;
        this.set_len(this._mem.length - 16 >> 1);
        this._bias = bias;
        this._scale = scale;
        UnsafeUtils.set8d(this._mem, 0, scale);
        UnsafeUtils.set8(this._mem, 8, bias);
    }

    @Override
    protected final long at8_impl(int i) {
        long res = UnsafeUtils.get2(this._mem, (i << 1) + 16);
        if (res == -32768L) {
            throw new IllegalArgumentException("at8_abs but value is missing");
        }
        return (long)((double)(res + this._bias) * this._scale);
    }

    @Override
    protected final double atd_impl(int i) {
        long res = UnsafeUtils.get2(this._mem, (i << 1) + 16);
        return res == -32768L ? Double.NaN : (double)(res + this._bias) * this._scale;
    }

    @Override
    protected final boolean isNA_impl(int i) {
        return (long)UnsafeUtils.get2(this._mem, (i << 1) + 16) == -32768L;
    }

    @Override
    boolean set_impl(int idx, long l) {
        long res = (long)((double)l / this._scale) - this._bias;
        double d = (double)(res + this._bias) * this._scale;
        if ((long)d != l) {
            return false;
        }
        if (-32768L >= res || res > 32767L) {
            return false;
        }
        UnsafeUtils.set2(this._mem, (idx << 1) + 16, (short)res);
        return true;
    }

    @Override
    boolean set_impl(int i, double d) {
        short s = (short)(d / this._scale - (double)this._bias);
        if ((long)s == -32768L) {
            return false;
        }
        double d2 = (double)((long)s + this._bias) * this._scale;
        if (d != d2) {
            return false;
        }
        UnsafeUtils.set2(this._mem, (i << 1) + 16, s);
        return true;
    }

    @Override
    boolean set_impl(int i, float f) {
        return false;
    }

    @Override
    boolean setNA_impl(int idx) {
        UnsafeUtils.set2(this._mem, (idx << 1) + 16, (short)Short.MIN_VALUE);
        return true;
    }

    @Override
    public NewChunk inflate_impl(NewChunk nc) {
        double dx = Math.log10(this._scale);
        assert (PrettyPrint.fitsIntoInt(dx));
        nc.set_sparseLen(0);
        nc.set_len(0);
        int len = this._len;
        for (int i = 0; i < len; ++i) {
            int res = UnsafeUtils.get2(this._mem, (i << 1) + 16);
            if ((long)res == -32768L) {
                nc.addNA();
                continue;
            }
            nc.addNum((long)res + this._bias, (int)dx);
        }
        return nc;
    }

    @Override
    public byte precision() {
        return (byte)Math.max(-Math.log10(this._scale), 0.0);
    }

    @Override
    public final void initFromBytes() {
        this._start = -1L;
        this._cidx = -1;
        this.set_len(this._mem.length - 16 >> 1);
        this._scale = UnsafeUtils.get8d(this._mem, 0);
        this._bias = UnsafeUtils.get8(this._mem, 8);
    }

    @Override
    public double[] getDoubles(double[] vals, int from, int to, double NA) {
        for (int i = from; i < to; ++i) {
            long res = UnsafeUtils.get2(this._mem, (i << 1) + 16);
            vals[i - from] = res != -32768L ? (double)(res + this._bias) * this._scale : NA;
        }
        return vals;
    }

    @Override
    public double[] getDoubles(double[] vals, int[] ids) {
        int j = 0;
        for (int i : ids) {
            long res = UnsafeUtils.get2(this._mem, (i << 1) + 16);
            vals[j++] = res != -32768L ? (double)(res + this._bias) * this._scale : Double.NaN;
        }
        return vals;
    }
}

