/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import java.util.Iterator;
import water.H2O;
import water.fvec.CXIChunk;
import water.fvec.NewChunk;
import water.util.UnsafeUtils;

public class CXDChunk
extends CXIChunk {
    protected CXDChunk(int len, int valsz, byte[] buf) {
        super(len, valsz, buf);
    }

    @Override
    protected final double getFValue(int off) {
        if (this.valsz() == 8) {
            return UnsafeUtils.get8d(this._mem, off + this.ridsz());
        }
        throw H2O.fail();
    }

    @Override
    public int asSparseDoubles(double[] vals, int[] ids, double NA) {
        if (vals.length < this._sparseLen) {
            throw new IllegalArgumentException();
        }
        int off = 6;
        int inc = 8 + this._ridsz;
        if (this._ridsz == 2) {
            int i = 0;
            while (i < this._sparseLen) {
                ids[i] = UnsafeUtils.get2(this._mem, off) & 0xFFFF;
                double d = UnsafeUtils.get8d(this._mem, off + 2);
                vals[i] = Double.isNaN(d) ? NA : d;
                ++i;
                off += inc;
            }
        } else if (this._ridsz == 4) {
            int i = 0;
            while (i < this._sparseLen) {
                ids[i] = UnsafeUtils.get4(this._mem, off);
                double d = UnsafeUtils.get8d(this._mem, off + 4);
                vals[i] = Double.isNaN(d) ? NA : d;
                ++i;
                off += inc;
            }
        } else {
            throw H2O.unimpl();
        }
        return this._sparseLen;
    }

    @Override
    public int asSparseDoubles(double[] vals, int[] ids) {
        if (vals.length < this._sparseLen) {
            throw new IllegalArgumentException();
        }
        int off = 6;
        int inc = 8 + this._ridsz;
        if (this._ridsz == 2) {
            int i = 0;
            while (i < this._sparseLen) {
                ids[i] = UnsafeUtils.get2(this._mem, off) & 0xFFFF;
                vals[i] = UnsafeUtils.get8d(this._mem, off + 2);
                ++i;
                off += inc;
            }
        } else if (this._ridsz == 4) {
            int i = 0;
            while (i < this._sparseLen) {
                ids[i] = UnsafeUtils.get4(this._mem, off);
                vals[i] = UnsafeUtils.get8d(this._mem, off + 4);
                ++i;
                off += inc;
            }
        } else {
            throw H2O.unimpl();
        }
        return this._sparseLen;
    }

    @Override
    protected long at8_impl(int idx) {
        int off = this.findOffset(idx);
        if (this.getId(off) != idx) {
            return 0L;
        }
        double d = this.getFValue(off);
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException("at8_abs but value is missing");
        }
        return (long)d;
    }

    @Override
    protected double atd_impl(int idx) {
        int off = this.findOffset(idx);
        if (this.getId(off) != idx) {
            return 0.0;
        }
        return this.getFValue(off);
    }

    @Override
    protected boolean isNA_impl(int i) {
        int off = this.findOffset(i);
        return this.getId(off) == i && Double.isNaN(this.getFValue(off));
    }

    @Override
    public NewChunk inflate_impl(NewChunk nc) {
        nc.set_len(this._len);
        nc.set_sparseLen(this._sparseLen);
        nc.alloc_doubles(this._sparseLen);
        nc.alloc_indices(this._sparseLen);
        int off = 6;
        int i = 0;
        while (i < this._sparseLen) {
            nc.indices()[i] = this.getId(off);
            nc.doubles()[i] = this.getFValue(off);
            ++i;
            off += this.ridsz() + this.valsz();
        }
        return nc;
    }

    @Override
    public Iterator<CXIChunk.Value> values() {
        return new CXIChunk.SparseIterator(new CXIChunk.Value(){

            @Override
            public final long asLong() {
                double d = CXDChunk.this.getFValue(this._off);
                if (Double.isNaN(d)) {
                    throw new IllegalArgumentException("at8_abs but value is missing");
                }
                return (long)d;
            }

            @Override
            public final double asDouble() {
                return CXDChunk.this.getFValue(this._off);
            }

            @Override
            public final boolean isNA() {
                double d = CXDChunk.this.getFValue(this._off);
                return Double.isNaN(d);
            }
        });
    }

    @Override
    public boolean hasFloat() {
        return true;
    }
}

