/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import java.util.ArrayList;
import water.Key;
import water.parser.CsvParser;
import water.parser.DefaultParserProviders;
import water.parser.ParseDataset;
import water.parser.ParseSetup;

class ARFFParser
extends CsvParser {
    private static final String TAG_ATTRIBUTE = "@ATTRIBUTE";
    private static final byte GUESS_SEP = -1;

    ARFFParser(ParseSetup ps, Key jobKey) {
        super(ps, jobKey);
    }

    static ParseSetup guessSetup(byte[] bits, byte sep, boolean singleQuotes, String[] columnNames, String[][] naStrings) {
        int nlines;
        if (columnNames != null) {
            throw new UnsupportedOperationException("ARFFParser doesn't accept columnNames.");
        }
        boolean haveData = false;
        int offset = 0;
        String[][] data = new String[][]{};
        String[] headerlines = new String[]{};
        ArrayList<String> header = new ArrayList<String>();
        if ((offset = ARFFParser.readArffHeader(offset, header, bits, singleQuotes)) < bits.length && !CsvParser.isEOL(bits[offset])) {
            haveData = true;
        }
        if (header.size() == 0) {
            throw new ParseDataset.H2OParseException("No data!");
        }
        headerlines = header.toArray(headerlines);
        int ncols = nlines = headerlines.length;
        String[] labels = new String[ncols];
        String[][] domains = new String[ncols][];
        byte[] ctypes = new byte[ncols];
        ARFFParser.processArffHeader(ncols, headerlines, labels, domains, ctypes);
        if (haveData) {
            String[] datalines = new String[]{};
            ArrayList<String> datablock = new ArrayList<String>();
            while (offset < bits.length) {
                String str;
                int lineStart = offset;
                while (offset < bits.length && !CsvParser.isEOL(bits[offset])) {
                    ++offset;
                }
                int lineEnd = offset++;
                if (offset < bits.length && bits[offset] == 10) {
                    ++offset;
                }
                if (bits[lineStart] == 35 || bits[lineStart] == 37 || lineEnd <= lineStart || (str = new String(bits, lineStart, lineEnd - lineStart).trim()).isEmpty()) continue;
                datablock.add(str);
            }
            if (datablock.size() == 0) {
                throw new ParseDataset.H2OParseException("Unexpected line.");
            }
            datalines = datablock.toArray(datalines);
            int nlines2 = Math.min(10, datalines.length);
            data = new String[nlines2][];
            if (nlines2 == 1) {
                if (sep == -1) {
                    if (datalines[0].split(",").length > 2) {
                        sep = (byte)44;
                    } else if (datalines[0].split(" ").length > 2) {
                        sep = (byte)32;
                    } else {
                        throw new ParseDataset.H2OParseException("Failed to detect separator.");
                    }
                }
                data[0] = ARFFParser.determineTokens(datalines[0], sep, singleQuotes);
                ncols = ncols > 0 ? ncols : data[0].length;
                labels = null;
            } else {
                if (sep == -1) {
                    sep = ARFFParser.guessSeparator(datalines[0], datalines[1], singleQuotes);
                    if (sep == -1 && nlines2 > 2 && (sep = ARFFParser.guessSeparator(datalines[1], datalines[2], singleQuotes)) == -1) {
                        sep = ARFFParser.guessSeparator(datalines[0], datalines[2], singleQuotes);
                    }
                    if (sep == -1) {
                        sep = (byte)32;
                    }
                }
                for (int i = 0; i < nlines2; ++i) {
                    data[i] = ARFFParser.determineTokens(datalines[i], sep, singleQuotes);
                }
            }
        }
        return new ParseSetup(DefaultParserProviders.ARFF_INFO, sep, singleQuotes, -1, ncols, labels, ctypes, domains, naStrings, data);
    }

    private static int readArffHeader(int offset, ArrayList<String> header, byte[] bits, boolean singleQuotes) {
        while (offset < bits.length) {
            int lineStart = offset;
            while (offset < bits.length && !CsvParser.isEOL(bits[offset])) {
                ++offset;
            }
            int lineEnd = offset++;
            if (offset < bits.length && bits[offset] == 10) {
                ++offset;
            }
            if (bits[lineStart] == 35 || bits[lineStart] == 37 || lineEnd <= lineStart) continue;
            if (!(bits[lineStart] != 64 || bits[lineStart + 1] != 68 && bits[lineStart + 1] != 100 || bits[lineStart + 2] != 65 && bits[lineStart + 2] != 97 || bits[lineStart + 3] != 84 && bits[lineStart + 3] != 116) && (bits[lineStart + 4] == 65 || bits[lineStart + 4] == 97)) break;
            String str = new String(bits, lineStart, lineEnd - lineStart).trim();
            String[] tok = ARFFParser.determineTokens(str, (byte)32, singleQuotes);
            if (tok.length > 0 && tok[0].equalsIgnoreCase("@RELATION") || str.isEmpty()) continue;
            header.add(str);
        }
        return offset;
    }

    static void processArffHeader(int ncols, String[] headerlines, String[] labels, String[][] domains, byte[] ctypes) {
        for (int i = 0; i < ncols; ++i) {
            String[] line = headerlines[i].split("\\s+", 2);
            if (!line[0].equalsIgnoreCase(TAG_ATTRIBUTE)) {
                throw new ParseDataset.H2OParseException("Expected line to start with @ATTRIBUTE.");
            }
            String spec = line.length == 2 ? line[1].replaceAll("\\s", " ") : "";
            int sepIdx = spec.lastIndexOf(32);
            if (sepIdx < 0) {
                throw new ParseDataset.H2OParseException("Expected @ATTRIBUTE to be followed by <attribute-name> <datatype>");
            }
            String type = spec.substring(sepIdx + 1).trim();
            domains[i] = null;
            ctypes[i] = 0;
            if (type.equalsIgnoreCase("NUMERIC") || type.equalsIgnoreCase("REAL") || type.equalsIgnoreCase("INTEGER") || type.equalsIgnoreCase("INT")) {
                ctypes[i] = 3;
            } else if (type.equalsIgnoreCase("DATE") || type.equalsIgnoreCase("TIME")) {
                ctypes[i] = 5;
            } else if (type.equalsIgnoreCase("ENUM")) {
                ctypes[i] = 4;
            } else if (type.equalsIgnoreCase("STRING")) {
                ctypes[i] = 2;
            } else if (type.equalsIgnoreCase("UUID")) {
                ctypes[i] = 1;
            } else {
                if (type.equalsIgnoreCase("RELATIONAL")) {
                    throw new UnsupportedOperationException("Relational ARFF format is not supported.");
                }
                if (type.endsWith("}")) {
                    int domainSpecStart = spec.lastIndexOf(123);
                    if (domainSpecStart < 0) {
                        throw new ParseDataset.H2OParseException("Invalid type specification.");
                    }
                    sepIdx = domainSpecStart - 1;
                    String domainSpec = spec.substring(domainSpecStart + 1, line[1].length() - 1);
                    domains[i] = domainSpec.split(",");
                    for (int j = 0; j < domains[i].length; ++j) {
                        domains[i][j] = domains[i][j].trim();
                    }
                    if (domains[i][0].length() > 0) {
                        ctypes[i] = 4;
                    }
                }
            }
            if (ctypes[i] == 0) {
                throw new ParseDataset.H2OParseException("Unexpected line, type not recognized. Attribute specification: " + type);
            }
            while (sepIdx > 0 && spec.charAt(sepIdx - 1) == ' ') {
                --sepIdx;
            }
            String label = line[1].substring(0, sepIdx);
            if (label.length() >= 2 && label.startsWith("'") && label.endsWith("'")) {
                label = label.substring(1, label.length() - 1);
            }
            labels[i] = label;
        }
    }
}

