/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.IllegalInstantException;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import water.MRTask;
import water.parser.BufferedString;
import water.util.Log;

public abstract class ParseTime {
    private static final byte[][][] MMS = new byte[][][]{new byte[][]{"jan".getBytes(), "january".getBytes()}, new byte[][]{"feb".getBytes(), "february".getBytes()}, new byte[][]{"mar".getBytes(), "march".getBytes()}, new byte[][]{"apr".getBytes(), "april".getBytes()}, new byte[][]{"may".getBytes(), "may".getBytes()}, new byte[][]{"jun".getBytes(), "june".getBytes()}, new byte[][]{"jul".getBytes(), "july".getBytes()}, new byte[][]{"aug".getBytes(), "august".getBytes()}, new byte[][]{"sep".getBytes(), "september".getBytes()}, new byte[][]{"oct".getBytes(), "october".getBytes()}, new byte[][]{"nov".getBytes(), "november".getBytes()}, new byte[][]{"dec".getBytes(), "december".getBytes()}};
    private static DateTimeZone _timezone;

    public static boolean isTime(BufferedString str) {
        return ParseTime.attemptTimeParse(str) != Long.MIN_VALUE;
    }

    public static long attemptTimeParse(BufferedString str) {
        try {
            long t0 = ParseTime.attemptYearFirstTimeParse(str);
            if (t0 != Long.MIN_VALUE) {
                return t0;
            }
            long t1 = ParseTime.attemptDayFirstTimeParse1(str);
            if (t1 != Long.MIN_VALUE) {
                return t1;
            }
            long t2 = ParseTime.attemptYearMonthTimeParse(str);
            if (t2 != Long.MIN_VALUE) {
                return t2;
            }
            long t3 = ParseTime.attemptTimeOnlyParse(str);
            if (t3 != Long.MIN_VALUE) {
                return t3;
            }
            long t4 = ParseTime.attemptDayFirstTimeParse2(str);
            if (t4 != Long.MIN_VALUE) {
                return t4;
            }
        }
        catch (IllegalFieldValueException | IllegalInstantException throwable) {
            // empty catch block
        }
        return Long.MIN_VALUE;
    }

    private static long attemptYearFirstTimeParse(BufferedString str) {
        boolean dash;
        int i;
        byte[] buf = str.getBuffer();
        int end = i + str.length();
        for (i = str.getOffset(); i < end && buf[i] == 32; ++i) {
        }
        if (i < end && buf[i] == 34) {
            ++i;
        }
        if (end - i < 6) {
            return Long.MIN_VALUE;
        }
        int yyyy = 0;
        int MM = 0;
        int dd = 0;
        yyyy = ParseTime.digit(yyyy, buf[i++]);
        yyyy = ParseTime.digit(yyyy, buf[i++]);
        yyyy = ParseTime.digit(yyyy, buf[i++]);
        yyyy = ParseTime.digit(yyyy, buf[i++]);
        boolean bl = dash = buf[i] == 45;
        if (dash) {
            // empty if block
        }
        int n = ++i;
        MM = ParseTime.digit(MM, buf[n]);
        int n2 = MM = ++i < end && buf[i] != 45 ? ParseTime.digit(MM, buf[i++]) : MM;
        if (MM < 1 || MM > 12) {
            return Long.MIN_VALUE;
        }
        if (end - i >= 2) {
            if (dash && buf[i++] != 45) {
                return Long.MIN_VALUE;
            }
            dd = ParseTime.digit(dd, buf[i++]);
            int n3 = dd = i < end && buf[i] >= 48 && buf[i] <= 57 ? ParseTime.digit(dd, buf[i++]) : dd;
            if (dd < 1 || dd > 31) {
                return Long.MIN_VALUE;
            }
        } else {
            if (!dash) {
                return Long.MIN_VALUE;
            }
            dd = 1;
        }
        if (dash) {
            while (i < end && buf[i] == 32) {
                ++i;
            }
            if (i == end) {
                return new DateTime(yyyy, MM, dd, 0, 0, 0, ParseTime.getTimezone()).getMillis();
            }
        } else if (i == end || buf[i++] != 45) {
            return Long.MIN_VALUE;
        }
        return ParseTime.parseTime(buf, i, end, yyyy, MM, dd, false);
    }

    private static long attemptDayFirstTimeParse1(BufferedString str) {
        int i;
        byte[] buf = str.getBuffer();
        int end = i + str.length();
        for (i = str.getOffset(); i < end && buf[i] == 32; ++i) {
        }
        if (i < end && buf[i] == 34) {
            ++i;
        }
        if (end - i < 5) {
            return Long.MIN_VALUE;
        }
        int yyyy = 0;
        int MM = 0;
        int dd = 0;
        if (ParseTime.isDigit(buf[i])) {
            dd = ParseTime.digit(dd, buf[i++]);
            if (ParseTime.isDigit(buf[i])) {
                dd = ParseTime.digit(dd, buf[i++]);
            }
            if (dd < 1 || dd > 31) {
                return Long.MIN_VALUE;
            }
            if (buf[i] == 45) {
                ++i;
            }
        } else {
            dd = 1;
        }
        if (!ParseTime.isChar(buf[i])) {
            return Long.MIN_VALUE;
        }
        MM = ParseTime.parseMonth(buf, i, end);
        if (MM == -1) {
            return Long.MIN_VALUE;
        }
        i += MM >> 4;
        MM &= 0xF;
        if (end - i >= 1 && buf[i] == 45) {
            ++i;
        }
        if (end - i < 2) {
            return Long.MIN_VALUE;
        }
        yyyy = ParseTime.digit(yyyy, buf[i++]);
        yyyy = ParseTime.digit(yyyy, buf[i++]);
        if (end - i >= 2 && buf[i] != 34 && buf[i] != 32 && buf[i] != 58) {
            yyyy = ParseTime.digit(yyyy, buf[i++]);
            yyyy = ParseTime.digit(yyyy, buf[i++]);
        } else {
            yyyy += yyyy >= 69 ? 1900 : 2000;
        }
        while (i < end && buf[i] == 32) {
            ++i;
        }
        if (i < end && buf[i] == 34) {
            ++i;
        }
        if (i == end) {
            return new DateTime(yyyy, MM, dd, 0, 0, 0, ParseTime.getTimezone()).getMillis();
        }
        if (buf[i] == 58) {
            ++i;
        }
        return ParseTime.parseTime(buf, i, end, yyyy, MM, dd, false);
    }

    private static long attemptDayFirstTimeParse2(BufferedString str) {
        byte sep;
        int i;
        byte[] buf = str.getBuffer();
        int end = i + str.length();
        for (i = str.getOffset(); i < end && buf[i] == 32; ++i) {
        }
        if (i < end && buf[i] == 34) {
            ++i;
        }
        if (end - i < 6) {
            return Long.MIN_VALUE;
        }
        int yyyy = 0;
        int MM = 0;
        int dd = 0;
        MM = ParseTime.digit(MM, buf[i++]);
        if (ParseTime.isDigit(buf[i])) {
            MM = ParseTime.digit(MM, buf[i++]);
        }
        if (MM < 1 || MM > 12) {
            return Long.MIN_VALUE;
        }
        if ((sep = buf[i++]) != 45 && sep != 47) {
            return Long.MIN_VALUE;
        }
        dd = ParseTime.digit(dd, buf[i++]);
        if (ParseTime.isDigit(buf[i])) {
            dd = ParseTime.digit(dd, buf[i++]);
        }
        if (dd < 1 || dd > 31) {
            return Long.MIN_VALUE;
        }
        if (sep != buf[i++]) {
            return Long.MIN_VALUE;
        }
        yyyy = ParseTime.digit(yyyy, buf[i++]);
        yyyy = ParseTime.digit(yyyy, buf[i++]);
        if (end - i >= 2 && ParseTime.isDigit(buf[i])) {
            yyyy = ParseTime.digit(yyyy, buf[i++]);
            yyyy = ParseTime.digit(yyyy, buf[i++]);
        } else {
            yyyy += yyyy >= 69 ? 1900 : 2000;
        }
        while (i < end && buf[i] == 32) {
            ++i;
        }
        if (i < end && buf[i] == 34) {
            ++i;
        }
        if (i == end) {
            return new DateTime(yyyy, MM, dd, 0, 0, 0, ParseTime.getTimezone()).getMillis();
        }
        if (buf[i] == 58) {
            ++i;
        }
        return ParseTime.parseTime(buf, i, end, yyyy, MM, dd, false);
    }

    private static long attemptYearMonthTimeParse(BufferedString str) {
        int i;
        byte[] buf = str.getBuffer();
        int end = i + str.length();
        for (i = str.getOffset(); i < end && buf[i] == 32; ++i) {
        }
        if (i < end && buf[i] == 34) {
            ++i;
        }
        if (end - i < 6) {
            return Long.MIN_VALUE;
        }
        int yyyy = 0;
        int MM = 0;
        yyyy = ParseTime.digit(yyyy, buf[i++]);
        yyyy = ParseTime.digit(yyyy, buf[i++]);
        if (buf[i++] != 45) {
            return Long.MIN_VALUE;
        }
        yyyy += yyyy >= 69 ? 1900 : 2000;
        MM = ParseTime.parseMonth(buf, i, end);
        if (MM == -1) {
            return Long.MIN_VALUE;
        }
        i += MM >> 4;
        MM &= 0xF;
        while (i < end && buf[i] == 32) {
            ++i;
        }
        if (i == end) {
            return new DateTime(yyyy, MM, 1, 0, 0, 0, ParseTime.getTimezone()).getMillis();
        }
        return Long.MIN_VALUE;
    }

    private static long attemptTimeOnlyParse(BufferedString str) {
        int i;
        byte[] buf = str.getBuffer();
        int end = i + str.length();
        for (i = str.getOffset(); i < end && buf[i] == 32; ++i) {
        }
        if (i < end && buf[i] == 34) {
            ++i;
        }
        if (end - i < 5) {
            return Long.MIN_VALUE;
        }
        long t1 = ParseTime.parseTime(buf, i, end, 1970, 1, 1, true);
        if (t1 == Long.MIN_VALUE) {
            return Long.MIN_VALUE;
        }
        return t1 + (long)ParseTime.getTimezone().getOffsetFromLocal(t1);
    }

    private static int parseMonth(byte[] buf, int i, int end) {
        int MM;
        byte[] MMM = null;
        block0: for (MM = 0; MM < MMS.length; ++MM) {
            byte[][] mss;
            block1: for (byte[] ms : mss = MMS[MM]) {
                MMM = ms;
                if (MMM == null || i + MMM.length > end) continue;
                for (int j = 0; j < MMM.length; ++j) {
                    if (MMM[j] != Character.toLowerCase(buf[i + j])) continue block1;
                }
                if (i + MMM.length == end || buf[i + MMM.length] == 45 || ParseTime.isDigit(buf[i + MMM.length])) break block0;
            }
        }
        if (MM == MMS.length) {
            return -1;
        }
        return MMM.length << 4 | ++MM;
    }

    private static long parseTime(byte[] buf, int i, int end, int yyyy, int MM, int dd, boolean timeOnly) {
        int HH = 0;
        int mm = 0;
        int ss = 0;
        int SSS = 0;
        int ndots = 0;
        HH = ParseTime.digit(HH, buf[i++]);
        int n = HH = buf[i] >= 48 && buf[i] <= 57 ? ParseTime.digit(HH, buf[i++]) : HH;
        if (HH < 0 || HH > 23) {
            return Long.MIN_VALUE;
        }
        if (buf[i] != 58 && buf[i] != 46) {
            return Long.MIN_VALUE;
        }
        if (buf[i] == 46) {
            ++ndots;
        }
        int n2 = ++i;
        mm = ParseTime.digit(mm, buf[n2]);
        int n3 = mm = buf[++i] >= 48 && buf[i] <= 57 ? ParseTime.digit(mm, buf[i++]) : mm;
        if (mm < 0 || mm > 59) {
            return Long.MIN_VALUE;
        }
        if (i + 2 >= buf.length) {
            return Long.MIN_VALUE;
        }
        if (buf[i] != 58 && buf[i] != 46) {
            return Long.MIN_VALUE;
        }
        if (buf[i] == 46) {
            ++ndots;
        }
        int n4 = ++i;
        ss = ParseTime.digit(ss, buf[n4]);
        int n5 = ss = buf[++i] >= 48 && buf[i] <= 57 ? ParseTime.digit(ss, buf[i++]) : ss;
        if (ss < 0 || ss > 59) {
            return Long.MIN_VALUE;
        }
        if (i < end && (buf[i] == 58 || buf[i] == 46)) {
            if (buf[i] == 46) {
                ++ndots;
            }
            if (++i < end) {
                SSS = ParseTime.digit(SSS, buf[i++]);
            }
            if (i < end) {
                SSS = ParseTime.digit(SSS, buf[i++]);
            }
            if (i < end) {
                SSS = ParseTime.digit(SSS, buf[i++]);
            }
            if (SSS < 0 || SSS > 999) {
                return Long.MIN_VALUE;
            }
            while (i < end && ParseTime.isDigit(buf[i])) {
                ++i;
            }
        }
        if (i < end && buf[i] == 34) {
            ++i;
        }
        if (i == end) {
            if (timeOnly && ndots == 3) {
                return Long.MIN_VALUE;
            }
            return new DateTime(yyyy, MM, dd, HH, mm, ss, ParseTime.getTimezone()).getMillis() + (long)SSS;
        }
        if (buf[i] == 32 && ++i == end) {
            return new DateTime(yyyy, MM, dd, HH, mm, ss, ParseTime.getTimezone()).getMillis() + (long)SSS;
        }
        if ((buf[i] == 65 || buf[i] == 80) && buf[i + 1] == 77) {
            if (HH < 1 || HH > 12) {
                return Long.MIN_VALUE;
            }
            if (buf[i] == 80) {
                if (HH < 12) {
                    HH += 12;
                } else if (HH == 12) {
                    HH = 0;
                }
            }
        } else {
            return Long.MIN_VALUE;
        }
        if ((i += 2) < end && buf[i] == 34) {
            ++i;
        }
        if (i < end) {
            return Long.MIN_VALUE;
        }
        return new DateTime(yyyy, MM, dd, HH, mm, ss, ParseTime.getTimezone()).getMillis() + (long)SSS;
    }

    private static int digit(int x, int c) {
        if (x < 0 || c < 48 || c > 57) {
            return -1;
        }
        return x * 10 + (c - 48);
    }

    private static boolean isDigit(byte b) {
        return b >= 48 && b <= 57;
    }

    private static boolean isChar(byte b) {
        return b >= 65 && (b <= 90 || b >= 97) && b <= 122;
    }

    public static void setTimezone(final String tz) {
        Set idSet = DateTimeZone.getAvailableIDs();
        if (idSet.contains(tz)) {
            new MRTask(){

                @Override
                protected void setupLocal() {
                    _timezone = DateTimeZone.forID((String)tz);
                }
            }.doAllNodes();
        } else {
            Log.err("Attempted to set unrecognized timezone: " + tz);
        }
    }

    public static DateTimeZone getTimezone() {
        return _timezone == null ? DateTimeZone.getDefault() : _timezone;
    }

    public static String listTimezones() {
        DateTimeFormatter offsetFormatter = new DateTimeFormatterBuilder().appendTimeZoneOffset(null, true, 2, 4).toFormatter();
        Set idSet = DateTimeZone.getAvailableIDs();
        TreeMap<String, String> tzMap = new TreeMap<String, String>();
        Iterator it = idSet.iterator();
        boolean i = false;
        long millis = System.currentTimeMillis();
        while (it.hasNext()) {
            String id = (String)it.next();
            DateTimeZone tz = DateTimeZone.forID((String)id);
            String cid = tz.getID();
            String offset = offsetFormatter.withZone(tz).print((long)tz.getStandardOffset(millis));
            String key = offset + " " + cid;
            if (id == cid) {
                if (tzMap.containsKey(key)) continue;
                tzMap.put(key, "");
                continue;
            }
            if (!tzMap.containsKey(key)) {
                tzMap.put(key, "");
            }
            tzMap.put(key, (String)tzMap.get(key) + ", " + id);
        }
        String output = "StandardOffset CanonicalID, Aliases\n";
        for (Map.Entry e : tzMap.entrySet()) {
            output = output + (String)e.getKey() + (String)e.getValue() + "\n";
        }
        return output;
    }

    public static DateTimeFormatter forStrptimePattern(String pattern) {
        if (pattern == null || pattern.length() == 0) {
            throw new IllegalArgumentException("Empty date time pattern specification");
        }
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        ParseTime.parseToBuilder(builder, pattern);
        DateTimeFormatter formatter = builder.toFormatter();
        return formatter;
    }

    private static void parseToBuilder(DateTimeFormatterBuilder builder, String pattern) {
        int length = pattern.length();
        int[] indexRef = new int[1];
        for (int i = 0; i < length; ++i) {
            indexRef[0] = i;
            String token = ParseTime.parseToken(pattern, indexRef);
            i = indexRef[0];
            int tokenLen = token.length();
            if (tokenLen == 0) break;
            char c = token.charAt(0);
            if (c == '%' && token.charAt(1) != '%') {
                c = token.charAt(1);
                switch (c) {
                    case 'a': {
                        builder.appendDayOfWeekShortText();
                        break;
                    }
                    case 'A': {
                        builder.appendDayOfWeekText();
                        break;
                    }
                    case 'b': 
                    case 'h': {
                        builder.appendMonthOfYearShortText();
                        break;
                    }
                    case 'B': {
                        builder.appendMonthOfYearText();
                        break;
                    }
                    case 'c': {
                        builder.appendDayOfWeekShortText();
                        builder.appendLiteral(' ');
                        builder.appendMonthOfYearShortText();
                        builder.appendLiteral(' ');
                        builder.appendDayOfMonth(2);
                        builder.appendLiteral(' ');
                        builder.appendHourOfDay(2);
                        builder.appendLiteral(':');
                        builder.appendMinuteOfHour(2);
                        builder.appendLiteral(':');
                        builder.appendSecondOfMinute(2);
                        builder.appendLiteral(' ');
                        builder.appendYear(4, 4);
                        break;
                    }
                    case 'C': {
                        builder.appendCenturyOfEra(1, 2);
                        break;
                    }
                    case 'd': {
                        builder.appendDayOfMonth(2);
                        break;
                    }
                    case 'D': {
                        builder.appendMonthOfYear(2);
                        builder.appendLiteral('/');
                        builder.appendDayOfMonth(2);
                        builder.appendLiteral('/');
                        builder.appendTwoDigitYear(2019);
                        break;
                    }
                    case 'e': {
                        builder.appendOptional(DateTimeFormat.forPattern((String)"' '").getParser());
                        builder.appendDayOfMonth(2);
                        break;
                    }
                    case 'F': {
                        builder.appendYear(4, 4);
                        builder.appendLiteral('-');
                        builder.appendMonthOfYear(2);
                        builder.appendLiteral('-');
                        builder.appendDayOfMonth(2);
                        break;
                    }
                    case 'G': 
                    case 'g': {
                        break;
                    }
                    case 'H': {
                        builder.appendHourOfDay(2);
                        break;
                    }
                    case 'I': {
                        builder.appendClockhourOfHalfday(2);
                        break;
                    }
                    case 'j': {
                        builder.appendDayOfYear(3);
                        break;
                    }
                    case 'k': {
                        builder.appendOptional(DateTimeFormat.forPattern((String)"' '").getParser());
                        builder.appendHourOfDay(2);
                        break;
                    }
                    case 'l': {
                        builder.appendOptional(DateTimeFormat.forPattern((String)"' '").getParser());
                        builder.appendClockhourOfHalfday(2);
                        break;
                    }
                    case 'm': {
                        builder.appendMonthOfYear(2);
                        break;
                    }
                    case 'M': {
                        builder.appendMinuteOfHour(2);
                        break;
                    }
                    case 'n': {
                        break;
                    }
                    case 'p': {
                        builder.appendHalfdayOfDayText();
                        break;
                    }
                    case 'r': {
                        builder.appendClockhourOfHalfday(2);
                        builder.appendLiteral(':');
                        builder.appendMinuteOfHour(2);
                        builder.appendLiteral(':');
                        builder.appendSecondOfMinute(2);
                        builder.appendLiteral(' ');
                        builder.appendHalfdayOfDayText();
                        break;
                    }
                    case 'R': {
                        builder.appendHourOfDay(2);
                        builder.appendLiteral(':');
                        builder.appendMinuteOfHour(2);
                        break;
                    }
                    case 'S': {
                        builder.appendSecondOfMinute(2);
                        break;
                    }
                    case 't': {
                        break;
                    }
                    case 'T': {
                        builder.appendHourOfDay(2);
                        builder.appendLiteral(':');
                        builder.appendMinuteOfHour(2);
                        builder.appendLiteral(':');
                        builder.appendSecondOfMinute(2);
                        break;
                    }
                    case 'V': {
                        break;
                    }
                    case 'x': {
                        builder.appendTwoDigitYear(2019);
                        builder.appendLiteral('/');
                        builder.appendMonthOfYear(2);
                        builder.appendLiteral('/');
                        builder.appendDayOfMonth(2);
                        break;
                    }
                    case 'y': {
                        builder.appendTwoDigitYear(2019);
                        break;
                    }
                    case 'Y': {
                        builder.appendYear(4, 4);
                        break;
                    }
                    case 'z': {
                        builder.appendTimeZoneOffset(null, "z", false, 2, 2);
                        break;
                    }
                    case 'Z': {
                        break;
                    }
                    default: {
                        builder.appendLiteral('\'');
                        builder.appendLiteral(token);
                        Log.warn(token + "is not acceptted as a parse token, treating as a literal");
                        break;
                    }
                }
                continue;
            }
            if (c == '\'') {
                String sub = token.substring(1);
                if (sub.length() <= 0) continue;
                builder.appendLiteral(new String(sub));
                continue;
            }
            throw new IllegalArgumentException("Unexpected token encountered parsing format string:" + c);
        }
    }

    private static String parseToken(String pattern, int[] indexRef) {
        StringBuilder buf = new StringBuilder();
        int i = indexRef[0];
        int length = pattern.length();
        char c = pattern.charAt(i);
        if (c == '%' && i + 1 < length && pattern.charAt(i + 1) != '%') {
            if (((c = pattern.charAt(++i)) == '0' || c == 'E') && i + 1 >= length) {
                c = pattern.charAt(++i);
            }
            buf.append('%');
            buf.append(c);
        } else {
            buf.append('\'');
            buf.append(c);
            ++i;
            while (i < length) {
                c = pattern.charAt(i);
                if (c == '%') {
                    if (i + 1 >= length || pattern.charAt(i + 1) != '%') break;
                    ++i;
                }
                buf.append(c);
                ++i;
            }
        }
        indexRef[0] = --i;
        return buf.toString();
    }
}

