/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.H2O;
import water.Key;
import water.MRTask;
import water.RPC;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.RadixCount;
import water.rapids.SingleThreadRadixOrder;
import water.rapids.SplitByMSBLocal;
import water.util.ArrayUtils;
import water.util.Log;

class RadixOrder
extends H2O.H2OCountedCompleter<RadixOrder> {
    private final Frame _DF;
    private final boolean _isLeft;
    private final int[] _whichCols;
    private final int[][] _id_maps;
    final int[] _shift;
    final int[] _bytesUsed;
    final long[] _base;

    RadixOrder(Frame DF, boolean isLeft, int[] whichCols, int[][] id_maps) {
        this._DF = DF;
        this._isLeft = isLeft;
        this._whichCols = whichCols;
        this._id_maps = id_maps;
        this._shift = new int[this._whichCols.length];
        this._bytesUsed = new int[this._whichCols.length];
        this._base = new long[this._whichCols.length];
    }

    @Override
    public void compute2() {
        long t0 = System.nanoTime();
        this.initBaseShift();
        int keySize = ArrayUtils.sum(this._bytesUsed);
        int batchSize = 0x10000000 / Math.max(keySize, 8) / 2;
        long t1 = System.nanoTime();
        System.out.println("Time to use rollup stats to determine biggestBit: " + (double)(t1 - t0) / 1.0E9);
        t0 = t1;
        if (this._whichCols.length > 0) {
            new RadixCount(this._isLeft, this._base[0], this._shift[0], this._whichCols[0], this._isLeft ? this._id_maps : (int[][])null).doAll(this._DF.vec(this._whichCols[0]));
        }
        t1 = System.nanoTime();
        System.out.println("Time of MSB count MRTask left local on each node (no reduce): " + (double)(t1 - t0) / 1.0E9);
        t0 = t1;
        Key linkTwoMRTask = Key.make();
        if (this._whichCols.length > 0) {
            new SplitByMSBLocal(this._isLeft, this._base, this._shift[0], keySize, batchSize, this._bytesUsed, this._whichCols, linkTwoMRTask, this._id_maps).doAll(this._DF.vecs(this._whichCols));
        }
        t1 = System.nanoTime();
        System.out.println("SplitByMSBLocal MRTask (all local per node, no network) took : " + (double)(t1 - t0) / 1.0E9);
        t0 = t1;
        if (this._whichCols.length > 0) {
            new SendSplitMSB(linkTwoMRTask).doAllNodes();
        }
        t1 = System.nanoTime();
        System.out.println("SendSplitMSB across all nodes took : " + (double)(t1 - t0) / 1.0E9);
        t0 = t1;
        RPC[] radixOrders = new RPC[256];
        System.out.print("Sending SingleThreadRadixOrder async RPC calls ... ");
        for (int i = 0; i < 256; ++i) {
            radixOrders[i] = new RPC<SingleThreadRadixOrder>(SplitByMSBLocal.ownerOfMSB(i), new SingleThreadRadixOrder(this._DF, this._isLeft, batchSize, keySize, i)).call();
        }
        t1 = System.nanoTime();
        System.out.println("took : " + (double)(t1 - t0) / 1.0E9);
        t0 = t1;
        System.out.print("Waiting for RPC SingleThreadRadixOrder to finish ... ");
        for (RPC rpc : radixOrders) {
            rpc.get();
        }
        System.out.println("took " + (double)(System.nanoTime() - t0) / 1.0E9);
        this.tryComplete();
    }

    private void initBaseShift() {
        for (int i = 0; i < this._whichCols.length; ++i) {
            long max;
            Vec col = this._DF.vec(this._whichCols[i]);
            if (col.isCategorical()) {
                this._base[i] = 0L;
                if (this._isLeft) {
                    assert (this._id_maps[i] != null);
                    max = ArrayUtils.maxValue(this._id_maps[i]);
                } else {
                    max = (long)col.max();
                }
            } else {
                this._base[i] = (long)col.min();
                max = (long)col.max();
            }
            long range = max - this._base[i] + 2L;
            int biggestBit = 1 + (int)Math.floor(Math.log(range) / Math.log(2.0));
            if (biggestBit < 8) {
                Log.warn("biggest bit should be >= 8 otherwise need to dip into next column (TODO)");
            }
            assert (biggestBit >= 1);
            this._shift[i] = Math.max(8, biggestBit) - 8;
            long MSBwidth = 1L << this._shift[i];
            if (this._base[i] % MSBwidth != 0L) {
                this._base[i] = MSBwidth * (this._base[i] / MSBwidth + (long)(this._base[i] < 0L ? -1 : 0));
                assert (this._base[i] % MSBwidth == 0L);
            }
            this._bytesUsed[i] = (this._shift[i] + 15) / 8;
            assert ((biggestBit - 1) / 8 + 1 == this._bytesUsed[i]);
            long chk = max - this._base[i] + 1L >> this._shift[i];
            assert (chk <= 255L);
            assert (chk >= 0L);
        }
    }

    private static class SendSplitMSB
    extends MRTask<SendSplitMSB> {
        final Key _linkTwoMRTask;

        SendSplitMSB(Key linkTwoMRTask) {
            this._linkTwoMRTask = linkTwoMRTask;
        }

        @Override
        public void setupLocal() {
            SplitByMSBLocal.MOVESHASH.get(this._linkTwoMRTask).sendSplitMSB();
            SplitByMSBLocal.MOVESHASH.remove(this._linkTwoMRTask);
        }
    }
}

