/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.Collections;
import java.util.Map;
import water.DKV;
import water.Futures;
import water.Key;
import water.MRTask;
import water.fvec.Frame;
import water.fvec.Vec;
import water.nbhm.NonBlockingHashMap;
import water.nbhm.NonBlockingHashSet;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ast.AstFunction;
import water.rapids.ast.AstRoot;
import water.rapids.ast.prims.operators.AstPlus;
import water.util.Log;

public class Session {
    private static final int sanityChecksFrequency = 1000;
    private static int sanityChecksCounter = 0;
    private String id;
    private NonBlockingHashMap<Vec, Integer> REFCNTS = new NonBlockingHashMap();
    private NonBlockingHashMap<Key, Frame> FRAMES = new NonBlockingHashMap();
    private NonBlockingHashSet<Vec> GLOBALS = new NonBlockingHashSet();
    private static volatile boolean _initialized;

    public Session() {
        this(Key.make().toString());
    }

    public Session(String id) {
        this.id = id;
        Session.cluster_init();
    }

    public String id() {
        return this.id;
    }

    public Val exec(AstRoot ast, AstFunction scope) {
        this.sanity_check_refs(null);
        Env env = new Env(this);
        env._scope = scope;
        Val val = ast.exec(env);
        assert (env.sp() == 0);
        this.sanity_check_refs(val);
        return val;
    }

    public Val end(Val returning) {
        this.sanity_check_refs(returning);
        Futures fs = new Futures();
        for (Frame fr : this.FRAMES.values()) {
            fs = this.downRefCnt(fr, fs);
            DKV.remove(fr._key, fs);
        }
        fs.blockForPending();
        this.FRAMES.clear();
        if (returning != null && returning.isFrame()) {
            Frame fr = returning.getFrame();
            Vec[] vecs = fr.vecs();
            for (int i = 0; i < vecs.length; ++i) {
                this._addRefCnt(vecs[i], -1);
                if (!this.GLOBALS.contains(vecs[i])) continue;
                fr.replace(i, vecs[i].makeCopy());
            }
        }
        this.GLOBALS.clear();
        this.sanity_check_refs(null);
        this.REFCNTS.clear();
        return returning;
    }

    public RuntimeException endQuietly(Throwable ex) {
        try {
            this.GLOBALS.clear();
            Futures fs = new Futures();
            for (Frame fr : this.FRAMES.values()) {
                for (Vec vec : fr.vecs()) {
                    Integer I = this.REFCNTS.get(vec);
                    int i = (I == null ? 0 : I) - 1;
                    if (i > 0) {
                        this.REFCNTS.put(vec, i);
                        continue;
                    }
                    this.REFCNTS.remove(vec);
                    vec.remove(fs);
                }
                DKV.remove(fr._key, fs);
            }
            fs.blockForPending();
            this.FRAMES.clear();
            this.REFCNTS.clear();
        }
        catch (Exception ex2) {
            Log.warn("Exception " + ex2 + " suppressed while cleaning up Rapids Session after already throwing " + ex);
        }
        return ex instanceof RuntimeException ? (RuntimeException)ex : new RuntimeException(ex);
    }

    private int _getRefCnt(Vec vec) {
        Integer I = this.REFCNTS.get(vec);
        assert (I == null || I > 0);
        return I == null ? 0 : I;
    }

    private int _putRefCnt(Vec vec, int i) {
        assert (i >= 0);
        if (i > 0) {
            this.REFCNTS.put(vec, i);
        } else {
            this.REFCNTS.remove(vec);
        }
        return i;
    }

    private int _addRefCnt(Vec vec, int i) {
        return this._putRefCnt(vec, this._getRefCnt(vec) + i);
    }

    private int getRefCnt(Vec vec) {
        return this._getRefCnt(vec) + (this.GLOBALS.contains(vec) ? 1 : 0);
    }

    private int addRefCnt(Vec vec, int i) {
        return this._addRefCnt(vec, i) + (this.GLOBALS.contains(vec) ? 1 : 0);
    }

    Frame addRefCnt(Frame fr, int i) {
        if (fr != null) {
            for (Vec vec : fr.vecs()) {
                this._addRefCnt(vec, i);
            }
        }
        return fr;
    }

    Frame addGlobals(Frame fr) {
        if (!this.FRAMES.containsKey(fr._key)) {
            Collections.addAll(this.GLOBALS, fr.vecs());
        }
        return fr;
    }

    public Frame track_tmp(Frame fr) {
        assert (fr._key != null);
        this.FRAMES.put(fr._key, fr);
        this.addRefCnt(fr, 1);
        DKV.put(fr);
        return fr;
    }

    public void remove(Frame fr) {
        if (fr == null) {
            return;
        }
        Futures fs = new Futures();
        if (!this.FRAMES.containsKey(fr._key)) {
            for (Vec vec : fr.vecs()) {
                this.GLOBALS.remove(vec);
                if (this.REFCNTS.get(vec) != null) continue;
                vec.remove(fs);
            }
        } else {
            fs = this.downRefCnt(fr, fs);
            this.FRAMES.remove(fr._key);
        }
        DKV.remove(fr._key, fs);
        fs.blockForPending();
    }

    Futures downRefCnt(Frame fr, Futures fs) {
        for (Vec vec : fr.vecs()) {
            if (this.addRefCnt(vec, -1) != 0) continue;
            if (fs == null) {
                fs = new Futures();
            }
            vec.remove(fs);
        }
        return fs;
    }

    public Frame assign(Key<Frame> id, Frame src) {
        if (this.FRAMES.containsKey(id)) {
            throw new IllegalArgumentException("Cannot reassign temp " + id);
        }
        Futures fs = new Futures();
        Frame fr = (Frame)DKV.getGet(id);
        if (fr != null) {
            for (Vec vec : fr.vecs()) {
                if (!this.GLOBALS.remove(vec) || this._getRefCnt(vec) != 0) continue;
                vec.remove(fs);
            }
        }
        Vec[] svecs = (Vec[])src.vecs().clone();
        for (int i = 0; i < svecs.length; ++i) {
            if (!this.GLOBALS.contains(svecs[i])) continue;
            svecs[i] = svecs[i].makeCopy();
        }
        Frame fr2 = new Frame(id, (String[])src._names.clone(), svecs);
        DKV.put(fr2, fs);
        this.addGlobals(fr2);
        fs.blockForPending();
        return fr2;
    }

    public Vec[] copyOnWrite(Frame fr, int[] cols) {
        Vec did_copy = null;
        Vec[] vecs = fr.vecs();
        for (int col : cols) {
            Vec vec = vecs[col];
            int refcnt = this.getRefCnt(vec);
            assert (refcnt > 0);
            if (refcnt <= 1) continue;
            did_copy = vec.makeCopy();
            fr.replace(col, did_copy);
        }
        if (did_copy != null && fr._key != null) {
            DKV.put(fr);
        }
        return vecs;
    }

    private void sanity_check_refs(Val returning) {
        if (sanityChecksCounter++ % 1000 >= 1000) {
            return;
        }
        NonBlockingHashMap<Vec, Integer> refcnts = new NonBlockingHashMap<Vec, Integer>(this.REFCNTS.size());
        for (Frame frame : this.FRAMES.values()) {
            Vec[] arr$ = frame.vecs();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Vec vec;
                Integer count = (Integer)refcnts.get(vec = arr$[i$]);
                refcnts.put(vec, count == null ? 1 : count + 1);
            }
        }
        if (returning != null && returning.isFrame()) {
            Vec[] arr$ = returning.getFrame().vecs();
            int n = arr$.length;
            for (int i$ = 0; i$ < n; ++i$) {
                Vec vec;
                Integer count = (Integer)refcnts.get(vec = arr$[i$]);
                refcnts.put(vec, count == null ? 1 : count + 1);
            }
        }
        for (Map.Entry entry : refcnts.entrySet()) {
            Vec vec = (Vec)entry.getKey();
            Integer count = (Integer)entry.getValue();
            Integer savedCount = this.REFCNTS.get(vec);
            if (savedCount == null) {
                throw new IllegalStateException("REFCNTS missing vec " + vec);
            }
            if (count.intValue() == savedCount.intValue()) continue;
            throw new IllegalStateException("Ref-count mismatch for vec " + vec + ": REFCNT = " + savedCount + ", should be " + count);
        }
        if (refcnts.size() != this.REFCNTS.size()) {
            for (Map.Entry entry : this.REFCNTS.entrySet()) {
                if (refcnts.containsKey(entry.getKey())) continue;
                throw new IllegalStateException("REFCNTs contains an extra vec " + entry.getKey() + ", count = " + entry.getValue());
            }
        }
    }

    static void cluster_init() {
        if (_initialized) {
            return;
        }
        new MRTask(){

            @Override
            public void setupLocal() {
                new AstPlus();
            }
        }.doAllNodes();
        _initialized = true;
    }
}

