/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.params;

import java.util.ArrayList;
import java.util.Arrays;
import water.H2O;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ast.AstParameter;
import water.util.ArrayUtils;
import water.util.SB;

public class AstNumList
extends AstParameter {
    public final double[] _bases;
    final double[] _strides;
    final long[] _cnts;
    public final boolean _isList;
    public boolean _isSort;

    public AstNumList(ArrayList<Double> bases, ArrayList<Double> strides, ArrayList<Long> counts) {
        int n = bases.size();
        this._bases = new double[n];
        this._strides = new double[n];
        this._cnts = new long[n];
        boolean isList = true;
        for (int i = 0; i < n; ++i) {
            this._bases[i] = bases.get(i);
            this._cnts[i] = counts.get(i);
            this._strides[i] = strides.get(i);
            if (this._cnts[i] == 1L) continue;
            isList = false;
        }
        this._isList = isList;
        boolean isSorted = true;
        for (int i = 1; i < n; ++i) {
            if (!(this._bases[i - 1] + (double)(this._cnts[i - 1] - 1L) * this._strides[i - 1] >= this._bases[i])) continue;
            if (this._isList) {
                isSorted = false;
                continue;
            }
            throw new IllegalArgumentException("Overlapping numeric ranges");
        }
        this._isSort = isSorted;
    }

    public AstNumList(double d) {
        this._bases = new double[]{d};
        this._strides = new double[]{1.0};
        this._cnts = new long[]{1L};
        this._isSort = true;
        this._isList = true;
    }

    public AstNumList(long lo, long hi_exclusive) {
        this._bases = new double[]{lo};
        this._strides = new double[]{1.0};
        this._cnts = new long[]{hi_exclusive - lo};
        this._isList = false;
        this._isSort = true;
    }

    public AstNumList() {
        this._bases = new double[0];
        this._strides = new double[0];
        this._cnts = new long[0];
        this._isSort = true;
        this._isList = true;
    }

    public AstNumList(double[] list) {
        this._bases = list;
        this._strides = new double[list.length];
        this._cnts = new long[list.length];
        this._isList = true;
        Arrays.fill(this._strides, 1.0);
        Arrays.fill(this._cnts, 1L);
    }

    public AstNumList(int[] list) {
        this(ArrayUtils.copyFromIntArray(list));
    }

    @Override
    public Val exec(Env env) {
        throw new IllegalArgumentException("Number list not allowed here");
    }

    @Override
    public String str() {
        SB sb = new SB().p('[');
        for (int i = 0; i < this._bases.length; ++i) {
            sb.p(this._bases[i]);
            if (this._cnts[i] != 1L) {
                sb.p(':').p(this._bases[i] + (double)this._cnts[i] * this._strides[i]);
                if (this._strides[i] != 1.0 || (double)((long)this._bases[i]) != this._bases[i]) {
                    sb.p(':').p(this._strides[i]);
                }
            }
            if (i >= this._bases.length - 1) continue;
            sb.p(',');
        }
        return sb.p(']').toString();
    }

    @Override
    public String toJavaString() {
        double[] ary = this.expand();
        if (ary == null || ary.length == 0) {
            return "\"null\"";
        }
        SB sb = new SB().p('{');
        for (int i = 0; i < ary.length - 1; ++i) {
            sb.p(ary[i]).p(',');
        }
        return sb.p('}').toString();
    }

    public double[] expand() {
        int nrows = (int)this.cnt();
        int r = 0;
        double[] vals = new double[nrows];
        for (int i = 0; i < this._bases.length; ++i) {
            if (Double.isNaN(this._bases[i])) {
                vals[r++] = Double.NaN;
                continue;
            }
            for (double d = this._bases[i]; d < this._bases[i] + (double)this._cnts[i] * this._strides[i]; d += this._strides[i]) {
                vals[r++] = d;
            }
        }
        return vals;
    }

    public AstNumList sort() {
        if (this._isSort) {
            return this;
        }
        int[] idxs = ArrayUtils.seq(0, this._bases.length);
        ArrayUtils.sort(idxs, this._bases);
        double[] bases = (double[])this._bases.clone();
        double[] strides = (double[])this._strides.clone();
        long[] cnts = (long[])this._cnts.clone();
        for (int i = 0; i < idxs.length; ++i) {
            this._bases[i] = bases[idxs[i]];
            this._strides[i] = strides[idxs[i]];
            this._cnts[i] = cnts[idxs[i]];
        }
        this._isSort = true;
        return this;
    }

    public int[] expand4() {
        int nrows = (int)this.cnt();
        int r = 0;
        int[] vals = new int[nrows];
        for (int i = 0; i < this._bases.length; ++i) {
            for (double d = this._bases[i]; d < this._bases[i] + (double)this._cnts[i] * this._strides[i]; d += this._strides[i]) {
                vals[r++] = (int)d;
            }
        }
        return vals;
    }

    int[] expand4Sort() {
        return this.sort().expand4();
    }

    public long[] expand8() {
        int nrows = (int)this.cnt();
        int r = 0;
        long[] vals = new long[nrows];
        for (int i = 0; i < this._bases.length; ++i) {
            for (double d = this._bases[i]; d < this._bases[i] + (double)this._cnts[i] * this._strides[i]; d += this._strides[i]) {
                vals[r++] = (long)d;
            }
        }
        return vals;
    }

    public long[] expand8Sort() {
        return this.sort().expand8();
    }

    public double max() {
        assert (this._isSort);
        return this._bases[this._bases.length - 1] + (double)this._cnts[this._cnts.length - 1] * this._strides[this._strides.length - 1];
    }

    public double min() {
        assert (this._isSort);
        return this._bases[0];
    }

    public long cnt() {
        return ArrayUtils.sum(this._cnts);
    }

    public boolean isDense() {
        return this._cnts.length == 1 && this._bases[0] == 0.0 && this._strides[0] == 1.0;
    }

    public boolean isEmpty() {
        return this._bases.length == 0;
    }

    public boolean has(long v) {
        int idx = this.findBase(v);
        if (idx >= 0) {
            return true;
        }
        if ((idx = -idx - 2) < 0) {
            return false;
        }
        assert (this._bases[idx] < (double)v);
        return (double)v < this._bases[idx] + (double)this._cnts[idx] * this._strides[idx] && ((double)v - this._bases[idx]) % this._strides[idx] == 0.0;
    }

    public long index(long v) {
        int bIdx = this.findBase(v);
        if (bIdx >= 0) {
            return ArrayUtils.sum(this._cnts, 0, bIdx - 1);
        }
        if ((bIdx = -bIdx - 2) < 0) {
            return -1L;
        }
        assert (this._bases[bIdx] < (double)v);
        long offset = v - (long)this._bases[bIdx];
        long stride = (long)this._strides[bIdx];
        if (offset >= this._cnts[bIdx] * stride || offset % stride != 0L) {
            return -1L;
        }
        return ArrayUtils.sum(this._cnts, 0, bIdx) + offset / stride;
    }

    private int findBase(long v) {
        assert (this._isSort);
        if (v < 0L) {
            throw H2O.unimpl();
        }
        return Arrays.binarySearch(this._bases, (double)v);
    }

    @Override
    public int[] columns(String[] names) {
        int nrows = 0;
        int r = 0;
        for (int i = 0; i < this._bases.length; ++i) {
            nrows = (int)((double)nrows + (Math.min(this._bases[i] + (double)this._cnts[i], (double)(names.length + 1)) - Math.min(this._bases[i], (double)(names.length + 1))));
        }
        int[] vals = new int[nrows];
        for (int i = 0; i < this._bases.length; ++i) {
            int lim = Math.min((int)(this._bases[i] + (double)this._cnts[i]), names.length + 1);
            int d = Math.min((int)this._bases[i], names.length + 1);
            while (d < lim) {
                vals[r++] = d++;
            }
        }
        return vals;
    }
}

