/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.mungers;

import java.util.ArrayList;
import java.util.Iterator;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValNums;

public class AstColumnsByType
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary", "type"};
    }

    @Override
    public String str() {
        return "columnsByType";
    }

    @Override
    public int nargs() {
        return 3;
    }

    @Override
    public ValNums apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        DType dtype;
        String type;
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        String string = type = stk.track(asts[2].exec(env)).getStr();
        int n = -1;
        switch (string.hashCode()) {
            case -2000413939: {
                if (!string.equals("numeric")) break;
                n = 0;
                break;
            }
            case 1537307680: {
                if (!string.equals("categorical")) break;
                n = 1;
                break;
            }
            case -891985903: {
                if (!string.equals("string")) break;
                n = 2;
                break;
            }
            case 3560141: {
                if (!string.equals("time")) break;
                n = 3;
                break;
            }
            case 3601339: {
                if (!string.equals("uuid")) break;
                n = 4;
                break;
            }
            case 97285: {
                if (!string.equals("bad")) break;
                n = 5;
            }
        }
        switch (n) {
            case 0: {
                dtype = DType.Numeric;
                break;
            }
            case 1: {
                dtype = DType.Categorical;
                break;
            }
            case 2: {
                dtype = DType.String;
                break;
            }
            case 3: {
                dtype = DType.Time;
                break;
            }
            case 4: {
                dtype = DType.UUID;
                break;
            }
            case 5: {
                dtype = DType.Bad;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown data type to filter by: " + type);
            }
        }
        Vec[] vecs = fr.vecs();
        ArrayList<Double> idxs = new ArrayList<Double>();
        for (double i = 0.0; i < (double)fr.numCols(); i += 1.0) {
            if (dtype.equals((Object)DType.Numeric) && vecs[(int)i].isNumeric()) {
                idxs.add(i);
                continue;
            }
            if (dtype.equals((Object)DType.Categorical) && vecs[(int)i].isCategorical()) {
                idxs.add(i);
                continue;
            }
            if (dtype.equals((Object)DType.String) && vecs[(int)i].isString()) {
                idxs.add(i);
                continue;
            }
            if (dtype.equals((Object)DType.Time) && vecs[(int)i].isTime()) {
                idxs.add(i);
                continue;
            }
            if (dtype.equals((Object)DType.UUID) && vecs[(int)i].isUUID()) {
                idxs.add(i);
                continue;
            }
            if (!dtype.equals((Object)DType.Bad) || !vecs[(int)i].isBad()) continue;
            idxs.add(i);
        }
        double[] include_cols = new double[idxs.size()];
        int i = 0;
        Iterator i$ = idxs.iterator();
        while (i$.hasNext()) {
            double d = (Double)i$.next();
            include_cols[i++] = (int)d;
        }
        return new ValNums(include_cols);
    }

    private static enum DType {
        Numeric,
        Categorical,
        String,
        Time,
        UUID,
        Bad;

    }
}

