/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.string;

import java.util.Locale;
import water.MRTask;
import water.fvec.C0DChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;

public class AstReplaceFirst
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary", "pattern", "replacement", "ignore_case"};
    }

    @Override
    public int nargs() {
        return 5;
    }

    @Override
    public String str() {
        return "replacefirst";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        String pattern = asts[2].exec(env).getStr();
        String replacement = asts[3].exec(env).getStr();
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        boolean ignoreCase = asts[4].exec(env).getNum() == 1.0;
        for (Vec v : fr.vecs()) {
            if (v.isCategorical() || v.isString()) continue;
            throw new IllegalArgumentException("replacefirst() requires a string or categorical column. Received " + fr.anyVec().get_type_str() + ". Please convert column to a string or categorical first.");
        }
        Vec[] nvs = new Vec[fr.numCols()];
        int i = 0;
        for (Vec v : fr.vecs()) {
            nvs[i] = v.isCategorical() ? this.replaceFirstCategoricalCol(v, pattern, replacement, ignoreCase) : this.replaceFirstStringCol(v, pattern, replacement, ignoreCase);
            ++i;
        }
        return new ValFrame(new Frame(nvs));
    }

    private Vec replaceFirstCategoricalCol(Vec vec, String pattern, String replacement, boolean ignoreCase) {
        String[] doms = (String[])vec.domain().clone();
        for (int i = 0; i < doms.length; ++i) {
            doms[i] = ignoreCase ? doms[i].toLowerCase(Locale.ENGLISH).replaceFirst(pattern, replacement) : doms[i].replaceFirst(pattern, replacement);
        }
        return vec.makeCopy(doms);
    }

    private Vec replaceFirstStringCol(Vec vec, String pat, String rep, boolean ic) {
        final String pattern = pat;
        final String replacement = rep;
        final boolean ignoreCase = ic;
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk chk, NewChunk newChk) {
                if (chk instanceof C0DChunk) {
                    for (int i = 0; i < chk.len(); ++i) {
                        newChk.addNA();
                    }
                } else {
                    BufferedString tmpStr = new BufferedString();
                    for (int i = 0; i < chk._len; ++i) {
                        if (chk.isNA(i)) {
                            newChk.addNA();
                            continue;
                        }
                        if (ignoreCase) {
                            newChk.addStr(chk.atStr(tmpStr, i).toString().toLowerCase(Locale.ENGLISH).replaceFirst(pattern, replacement));
                            continue;
                        }
                        newChk.addStr(chk.atStr(tmpStr, i).toString().replaceFirst(pattern, replacement));
                    }
                }
            }
        }.doAll(new byte[]{2}, vec)).outputFrame().anyVec();
    }
}

