/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import water.H2O;
import water.Iced;
import water.util.Log;

public class ReflectionUtils {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> Class<T> findActualClassParameter(Class clz, int parm) {
        Class parm_class = null;
        if (!(clz.getGenericSuperclass() instanceof ParameterizedType)) return Iced.class;
        Type[] handler_type_parms = ((ParameterizedType)clz.getGenericSuperclass()).getActualTypeArguments();
        if (handler_type_parms[parm] instanceof Class) {
            return (Class)handler_type_parms[parm];
        }
        if (handler_type_parms[parm] instanceof TypeVariable) {
            TypeVariable v = (TypeVariable)handler_type_parms[parm];
            Type t = v.getBounds()[0];
            if (t instanceof Class) {
                return (Class)t;
            }
            if (!(t instanceof ParameterizedType)) return parm_class;
            return (Class)((ParameterizedType)t).getRawType();
        }
        if (handler_type_parms[parm] instanceof ParameterizedType) {
            return (Class)((ParameterizedType)handler_type_parms[parm]).getRawType();
        }
        String msg = "Iced parameter for handler: " + clz + " uses a type parameterization scheme that we don't yet handle: " + handler_type_parms[parm];
        Log.warn(msg);
        throw H2O.fail(msg);
    }

    public static Class findMethodParameterClass(Method method, int parm) {
        Class<?>[] clzes = method.getParameterTypes();
        if (clzes.length <= parm) {
            throw H2O.fail("Asked for the class of parameter number: " + parm + " of method: " + method + ", which only has: " + clzes.length + " parameters.");
        }
        return clzes[parm];
    }

    public static Class findMethodOutputClass(Method method) {
        return method.getReturnType();
    }

    public static Class findActualFieldClass(Class clz, Field f) {
        Type generic_type = f.getGenericType();
        if (!(generic_type instanceof TypeVariable)) {
            return f.getType();
        }
        TypeVariable<Class<T>>[] tvs = clz.getSuperclass().getTypeParameters();
        TypeVariable tv = (TypeVariable)generic_type;
        String type_param_name = tv.getName();
        int which_tv = -1;
        for (int i = 0; i < tvs.length; ++i) {
            if (!type_param_name.equals(tvs[i].getName())) continue;
            which_tv = i;
        }
        if (-1 == which_tv) {
            return f.getType();
        }
        ParameterizedType generic_super = (ParameterizedType)clz.getGenericSuperclass();
        if (generic_super.getActualTypeArguments()[which_tv] instanceof Class) {
            return (Class)generic_super.getActualTypeArguments()[which_tv];
        }
        return ReflectionUtils.findActualFieldClass(clz.getSuperclass(), f);
    }

    public static double asDouble(Object o) {
        if (o == null) {
            return Double.NaN;
        }
        if (o instanceof Integer) {
            return ((Integer)o).intValue();
        }
        if (o instanceof Long) {
            return ((Long)o).longValue();
        }
        if (o instanceof Float) {
            return ((Float)o).floatValue();
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Enum) {
            return ((Enum)o).ordinal();
        }
        System.out.println("Do not know how to convert a " + o.getClass() + " to a double");
        throw H2O.fail();
    }

    public static Field findNamedField(Object o, String field_name) {
        Class<?> clz = o.getClass();
        Field f = null;
        while (true) {
            try {
                f = clz.getDeclaredField(field_name);
                f.setAccessible(true);
                return f;
            }
            catch (NoSuchFieldException e) {
                if ((clz = clz.getSuperclass()) != Object.class) continue;
                return null;
            }
            break;
        }
    }
}

