/*
 * Decompiled with CFR 0.152.
 */
package water.api.schemas3;

import water.AutoBuffer;
import water.H2O;
import water.Iced;
import water.IcedWrapper;
import water.api.API;
import water.api.schemas3.SchemaV3;
import water.util.TwoDimTable;

public class TwoDimTableV3
extends SchemaV3<TwoDimTable, TwoDimTableV3> {
    @API(help="Table Name", direction=API.Direction.OUTPUT)
    public String name;
    @API(help="Table Description", direction=API.Direction.OUTPUT)
    public String description;
    @API(help="Column Specification", direction=API.Direction.OUTPUT)
    public ColumnSpecsBase[] columns;
    @API(help="Number of Rows", direction=API.Direction.OUTPUT)
    public int rowcount;
    @API(help="Table Data (col-major)", direction=API.Direction.OUTPUT)
    public IcedWrapper[][] data;

    public TwoDimTableV3() {
    }

    public TwoDimTableV3(TwoDimTable impl) {
        super(impl);
    }

    @Override
    public TwoDimTableV3 fillFromImpl(TwoDimTable t) {
        int cols;
        int rows;
        this.name = t.getTableHeader();
        this.description = t.getTableDescription();
        this.rowcount = rows = t.getRowDim();
        boolean have_row_header_cols = t.getColHeaderForRowHeaders() != null;
        for (int r = 0; r < rows && have_row_header_cols; have_row_header_cols &= t.getRowHeaders()[r] != null, ++r) {
        }
        if (have_row_header_cols) {
            cols = t.getColDim() + 1;
            this.columns = new ColumnSpecsBase[cols];
            this.columns[0] = new ColumnSpecsBase();
            this.columns[0].name = this.pythonify(t.getColHeaderForRowHeaders());
            this.columns[0].type = "string";
            this.columns[0].format = "%s";
            this.columns[0].description = t.getColHeaderForRowHeaders();
            for (int c = 1; c < cols; ++c) {
                this.columns[c] = new ColumnSpecsBase();
                this.columns[c].name = this.pythonify(t.getColHeaders()[c - 1]);
                this.columns[c].type = t.getColTypes()[c - 1];
                this.columns[c].format = t.getColFormats()[c - 1];
                this.columns[c].description = t.getColHeaders()[c - 1];
            }
            this.data = new IcedWrapper[cols][rows];
            this.data[0] = new IcedWrapper[t.getRowDim()];
            for (int r = 0; r < t.getRowDim(); ++r) {
                this.data[0][r] = new IcedWrapper(t.getRowHeaders()[r]);
            }
            IcedWrapper[][] cellValues = t.getCellValues();
            for (int c = 1; c < cols; ++c) {
                this.data[c] = new IcedWrapper[rows];
                for (int r = 0; r < rows; ++r) {
                    this.data[c][r] = cellValues[r][c - 1];
                }
            }
        } else {
            cols = t.getColDim();
            this.columns = new ColumnSpecsBase[cols];
            for (int c = 0; c < cols; ++c) {
                this.columns[c] = new ColumnSpecsBase();
                this.columns[c].name = this.pythonify(t.getColHeaders()[c]);
                this.columns[c].type = t.getColTypes()[c];
                this.columns[c].format = t.getColFormats()[c];
                this.columns[c].description = t.getColHeaders()[c];
            }
            this.data = new IcedWrapper[cols][rows];
            IcedWrapper[][] cellValues = t.getCellValues();
            for (int c = 0; c < cols; ++c) {
                this.data[c] = new IcedWrapper[rows];
                for (int r = 0; r < rows; ++r) {
                    this.data[c][r] = cellValues[r][c];
                }
            }
        }
        return this;
    }

    private String pythonify(String n) {
        if (n == null || this.name.toLowerCase().contains("confusion")) {
            return n;
        }
        StringBuilder sb = new StringBuilder();
        String[] modified = n.split("[\\s_]+");
        for (int i = 0; i < modified.length; ++i) {
            if (i != 0) {
                sb.append("_");
            }
            String s = modified[i];
            sb.append(s.toLowerCase());
        }
        String newString = sb.toString().replaceAll("[^\\w]", "");
        return newString;
    }

    @Override
    public TwoDimTable fillImpl(TwoDimTable impl) {
        int rows = this.data[0].length;
        assert (rows == this.rowcount);
        int cols = this.data.length + 1;
        String tableHeader = this.name;
        String tableDescription = this.description;
        String colHeaderForRowHeaders = this.columns[0].name;
        String[] rowHeaders = new String[rows];
        for (int r = 0; r < rows; ++r) {
            rowHeaders[r] = (String)this.data[0][r].get();
        }
        String[] colHeaders = new String[cols];
        colHeaders[0] = "";
        for (int c = 1; c < cols; ++c) {
            colHeaders[c] = this.columns[c].description;
        }
        String[] colTypes = new String[cols];
        colTypes[0] = "";
        for (int c = 1; c < cols; ++c) {
            colTypes[c] = this.columns[c].type;
        }
        String[] colFormats = new String[cols];
        colFormats[0] = "%s";
        for (int c = 1; c < cols; ++c) {
            colFormats[c] = this.columns[c].format;
        }
        String[][] strCellValues = new String[rows][cols];
        double[][] dblCellValues = new double[rows][cols];
        for (int r = 0; r < this.data[0].length; ++r) {
            for (int c = 0; c < this.data.length; ++c) {
                try {
                    if (this.columns[c].format.equals("string")) {
                        strCellValues[r][c] = (String)this.data[c][r].get();
                        continue;
                    }
                    if (this.columns[c].format.equals("double")) {
                        dblCellValues[r][c] = (Double)this.data[c][r].get();
                        continue;
                    }
                    if (this.columns[c].format.equals("float")) {
                        dblCellValues[r][c] = ((Float)this.data[c][r].get()).floatValue();
                        continue;
                    }
                    if (this.columns[c].format.equals("int")) {
                        dblCellValues[r][c] = ((Integer)this.data[c][r].get()).intValue();
                        continue;
                    }
                    if (this.columns[c].format.equals("long")) {
                        dblCellValues[r][c] = ((Long)this.data[c][r].get()).longValue();
                        continue;
                    }
                    throw H2O.fail();
                }
                catch (ClassCastException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return new TwoDimTable(tableHeader, tableDescription, rowHeaders, colHeaders, colTypes, colFormats, colHeaderForRowHeaders, strCellValues, dblCellValues);
    }

    public final AutoBuffer writeJSON_impl(AutoBuffer ab) {
        int i;
        ab.putJSONStr("name", this.name);
        ab.put1(44);
        ab.putJSONStr("description", this.description);
        ab.put1(44);
        ab.putJSONStr("columns").put1(58);
        ab.put1(91);
        if (this.columns != null) {
            for (i = 0; i < this.columns.length; ++i) {
                this.columns[i].writeJSON(ab);
                if (i >= this.columns.length - 1) continue;
                ab.put1(44);
            }
        }
        ab.put1(93);
        ab.put1(44);
        ab.putJSON4("rowcount", this.rowcount);
        ab.put1(44);
        ab.putJSONStr("data").put1(58);
        ab.put1(91);
        if (this.data != null) {
            for (i = 0; i < this.data.length; ++i) {
                ab.put1(91);
                for (int j = 0; j < this.data[i].length; ++j) {
                    if (this.data[i][j] == null || this.data[i][j].get() == null) {
                        ab.putJNULL();
                    } else {
                        this.data[i][j].writeUnwrappedJSON(ab);
                    }
                    if (j >= this.data[i].length - 1) continue;
                    ab.put1(44);
                }
                ab.put1(93);
                if (i >= this.data.length - 1) continue;
                ab.put1(44);
            }
        }
        ab.put1(93);
        return ab;
    }

    public static class ColumnSpecsBase
    extends SchemaV3<Iced, ColumnSpecsBase> {
        @API(help="Column Name", direction=API.Direction.OUTPUT)
        String name;
        @API(help="Column Type", direction=API.Direction.OUTPUT)
        String type;
        @API(help="Column Format (printf)", direction=API.Direction.OUTPUT)
        String format;
        @API(help="Column Description", direction=API.Direction.OUTPUT)
        String description;
    }
}

