/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import water.parser.BufferedString;
import water.util.ArrayUtils;
import water.util.StringUtils;

public class PackedDomains {
    private static final byte[] ZEROES = new byte[]{0, 0, 0, 0};

    public static int sizeOf(byte[] domain) {
        return ArrayUtils.encodeAsInt(domain, 0);
    }

    public static String[] unpackToStrings(byte[] domain) {
        int n = PackedDomains.sizeOf(domain);
        String[] out = new String[n];
        int p = 4;
        for (int i = 0; i < n; ++i) {
            int p0 = p;
            while (domain[p] != 0 && p++ < domain.length) {
            }
            out[i] = StringUtils.toString(domain, p0, p - p0);
            ++p;
        }
        return out;
    }

    static byte[] pack(String ... source) {
        BufferedString[] bss = new BufferedString[source.length];
        for (int i = 0; i < source.length; ++i) {
            bss[i] = new BufferedString(source[i]);
        }
        return PackedDomains.pack(bss);
    }

    public static byte[] pack(BufferedString[] source) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(ZEROES);
            for (BufferedString bs : source) {
                out.write(bs.getBuffer(), bs.getOffset(), bs.length() - bs.getOffset());
                out.write(ZEROES, 0, 1);
            }
        }
        catch (IOException ignore) {
            // empty catch block
        }
        byte[] bytes = out.toByteArray();
        ArrayUtils.decodeAsInt(source.length, bytes, 0);
        return bytes;
    }

    private static void dump(InputStream from, OutputStream to) {
        try {
            int b;
            while ((b = from.read()) >= 0) {
                to.write(b);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void dumpWord(InputStream from, OutputStream to) {
        try {
            int b;
            while ((b = from.read()) > 0) {
                to.write(b);
            }
            to.write(0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static byte[] merge(byte[] as, byte[] bs) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream ia = new ByteArrayInputStream(as, 4, as.length);
        ByteArrayInputStream ib = new ByteArrayInputStream(bs, 4, bs.length);
        try {
            out.write(ZEROES);
            ((InputStream)ia).mark(0);
            ((InputStream)ib).mark(0);
            while (((InputStream)ia).available() > 0 || ((InputStream)ib).available() > 0) {
                int b;
                if (((InputStream)ia).available() == 0) {
                    PackedDomains.dump(ib, out);
                    continue;
                }
                if (((InputStream)ib).available() == 0) {
                    PackedDomains.dump(ia, out);
                    continue;
                }
                int a = ((InputStream)ia).read();
                if (a == (b = ((InputStream)ib).read())) {
                    out.write(a);
                    if (a != 0) continue;
                    ((InputStream)ia).mark(0);
                    ((InputStream)ib).mark(0);
                    continue;
                }
                if (a < b) {
                    out.write(a);
                    if (a != 0) {
                        PackedDomains.dumpWord(ia, out);
                    }
                    ((InputStream)ia).mark(0);
                    ((InputStream)ib).reset();
                    continue;
                }
                out.write(b);
                if (b != 0) {
                    PackedDomains.dumpWord(ib, out);
                }
                ((InputStream)ib).mark(0);
                ((InputStream)ia).reset();
            }
        }
        catch (IOException ignore) {
            // empty catch block
        }
        byte[] bytes = out.toByteArray();
        int n = 0;
        for (byte b : bytes) {
            if (b != 0) continue;
            ++n;
        }
        ArrayUtils.decodeAsInt(n - 4, bytes, 0);
        return bytes;
    }
}

