/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.reducers;

import java.io.Serializable;
import java.util.PriorityQueue;
import water.MRTask;
import water.fvec.C8Chunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;

public class AstTopN
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"frame", "col", "nPercent", "getBottomN"};
    }

    @Override
    public String str() {
        return "topn";
    }

    @Override
    public int nargs() {
        return 5;
    }

    @Override
    public String example() {
        return "(topn frame col nPercent getBottomN)";
    }

    @Override
    public String description() {
        return "Return the top N percent rows for a numerical column as a frame with two columns.  The first column will contain the original row indices of the chosen values.  The second column contains the top N rowvalues.  If getBottomN is 1, we will return the bottom N percent.  If getBottomN is 0, we will returnthe top N percent of rows";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame frOriginal = stk.track(asts[1].exec(env)).getFrame();
        int colIndex = (int)stk.track(asts[2].exec(env)).getNum();
        double nPercent = stk.track(asts[3].exec(env)).getNum();
        int getBottomN = (int)stk.track(asts[4].exec(env)).getNum();
        int totColumns = frOriginal.numCols();
        long numRows = Math.round(nPercent * 0.01 * (double)frOriginal.numRows());
        String[] finalColumnNames = new String[]{"Original_Row_Indices", frOriginal.name(colIndex)};
        GrabTopNPQ grabTask = new GrabTopNPQ(finalColumnNames, numRows, getBottomN == 0);
        grabTask.doAll(frOriginal.vec(colIndex));
        return new ValFrame(grabTask._sortedOut);
    }

    public class RowValue<E extends Comparable<E>>
    implements Comparable<RowValue<E>>,
    Serializable {
        private Long _rowIndex;
        private E _value;
        boolean _increasing;
        final /* synthetic */ AstTopN this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public RowValue(Long rowIndex, E value, boolean increasing) {
            this.this$0 = (AstTopN)n;
            this._rowIndex = rowIndex;
            this._value = value;
            this._increasing = increasing;
        }

        public E getValue() {
            return this._value;
        }

        public Long getRow() {
            return this._rowIndex;
        }

        @Override
        public int compareTo(RowValue<E> other) {
            return this.getValue().compareTo(other.getValue()) * (this._increasing ? 1 : -1);
        }
    }

    public class GrabTopNPQ<E extends Comparable<E>>
    extends MRTask<GrabTopNPQ<E>> {
        final String[] _columnName;
        PriorityQueue _sortQueue;
        Frame _sortedOut;
        final int _rowSize;
        final boolean _increasing;
        boolean _csLong = false;

        private GrabTopNPQ(String[] columnName, long rowSize, boolean increasing) {
            this._columnName = columnName;
            this._rowSize = (int)rowSize;
            this._increasing = increasing;
        }

        @Override
        public void map(Chunk cs) {
            this._sortQueue = new PriorityQueue();
            this._csLong = cs instanceof C8Chunk;
            Long startRow = cs.start();
            for (int rowIndex = 0; rowIndex < cs._len; ++rowIndex) {
                long absRowIndex = (long)rowIndex + startRow;
                if (cs.isNA(rowIndex)) continue;
                this.addOneValue(cs, rowIndex, absRowIndex, this._sortQueue);
            }
        }

        @Override
        public void reduce(GrabTopNPQ<E> other) {
            this._sortQueue.addAll(other._sortQueue);
            int sizesToReduce = this._sortQueue.size() - this._rowSize;
            if (sizesToReduce > 0) {
                for (int index = 0; index < sizesToReduce; ++index) {
                    this._sortQueue.poll();
                }
            }
        }

        @Override
        public void postGlobal() {
            int index;
            Vec[] xvecs = new Vec[2];
            long actualRowOutput = StrictMath.min(this._rowSize, this._sortQueue.size());
            for (index = 0; index < xvecs.length; ++index) {
                xvecs[index] = Vec.makeZero(actualRowOutput);
            }
            index = 0;
            while ((long)index < actualRowOutput) {
                RowValue transport = (RowValue)this._sortQueue.poll();
                xvecs[0].set((long)index, transport.getRow());
                xvecs[1].set((long)index, this._csLong ? (double)((Long)transport.getValue()).longValue() : (Double)transport.getValue());
                ++index;
            }
            this._sortedOut = new Frame(this._columnName, xvecs);
        }

        public void addOneValue(Chunk cs, int rowIndex, long absRowIndex, PriorityQueue sortHeap) {
            RowValue currPair = null;
            if (this._csLong) {
                long a = cs.at8(rowIndex);
                currPair = new RowValue(AstTopN.this, Long.valueOf(absRowIndex), (Comparable)Long.valueOf(a), this._increasing);
            } else {
                double a = cs.atd(rowIndex);
                currPair = new RowValue(AstTopN.this, Long.valueOf(absRowIndex), (Comparable)Double.valueOf(a), this._increasing);
            }
            sortHeap.offer(currPair);
            if (sortHeap.size() > this._rowSize) {
                sortHeap.poll();
            }
        }
    }
}

