/*
 * Decompiled with CFR 0.152.
 */
package water.udf;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import water.fvec.Chunk;
import water.fvec.RawChunk;
import water.fvec.Vec;
import water.udf.Column;
import water.udf.DependentChunk;
import water.udf.FunColumnBase;
import water.udf.TypedChunk;
import water.util.Java7;
import water.util.fp.Foldable;

public class FoldingColumn<X, Y>
extends FunColumnBase<Y> {
    private final Foldable<X, Y> f;
    private final Column<X>[] columns;

    @Override
    public int rowLayout() {
        return this.columns.length > 0 ? this.columns[0].rowLayout() : 0;
    }

    public FoldingColumn() {
        this.f = null;
        this.columns = null;
    }

    public FoldingColumn(Foldable<X, Y> f, Column<X> ... columns) {
        super(columns.length == 0 ? null : columns[0]);
        assert (columns.length > 0) : "Require at least one column for folding";
        this.f = f;
        this.columns = columns;
        if (columns.length > 1) {
            Column<X> c0 = columns[0];
            for (int i = 1; i < columns.length; ++i) {
                Column<X> c = columns[i];
                assert (c0.isCompatibleWith(c)) : "Columns must be compatible; " + c0 + " vs #" + i + ": " + c;
            }
        }
    }

    public FoldingColumn(Foldable<X, Y> f, Iterable<Column<X>> columns) {
        super(columns.iterator().next());
        this.f = f;
        this.columns = (Column[])Lists.newArrayList(columns).toArray();
    }

    @Override
    public Y get(long idx) {
        Y y = this.f.initial();
        for (Column<X> col : this.columns) {
            y = this.f.apply(y, col.apply(idx));
        }
        return y;
    }

    @Override
    public TypedChunk<Y> chunkAt(int i) {
        LinkedList chunks = new LinkedList();
        for (Column<X> c : this.columns) {
            chunks.add(c.chunkAt(i));
        }
        return new FunChunk(chunks);
    }

    @Override
    public boolean isNA(long idx) {
        for (Column<X> col : this.columns) {
            if (!col.isNA(idx)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof FoldingColumn) {
            FoldingColumn other = (FoldingColumn)o;
            return Java7.Objects.equals(this.f, other.f) && Arrays.equals(this.columns, other.columns);
        }
        return false;
    }

    public int hashCode() {
        return 61 * Arrays.hashCode(this.columns) + Java7.Objects.hashCode(this.f);
    }

    private class FunChunk
    extends DependentChunk<Y> {
        private final List<TypedChunk<X>> chunks;
        private RawChunk myChunk;

        public FunChunk(List<TypedChunk<X>> chunks) {
            super(chunks.get(0));
            this.myChunk = new RawChunk(this);
            this.chunks = chunks;
        }

        @Override
        public Vec vec() {
            return FoldingColumn.this.vec();
        }

        @Override
        public Chunk rawChunk() {
            return this.myChunk;
        }

        @Override
        public boolean isNA(int i) {
            for (TypedChunk c : this.chunks) {
                if (!c.isNA(i)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Y get(int idx) {
            Object y = FoldingColumn.this.f.initial();
            for (TypedChunk c : this.chunks) {
                y = FoldingColumn.this.f.apply(y, c.get(idx));
            }
            return y;
        }
    }
}

