/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import water.AutoBuffer;
import water.Freezable;
import water.H2O;
import water.Iced;

public abstract class IcedHashMapBase<K, V>
extends Iced
implements Map<K, V>,
Cloneable,
Serializable {
    private volatile transient boolean _write_lock;

    protected abstract Map<K, V> map();

    @Override
    public int size() {
        return this.map().size();
    }

    @Override
    public boolean isEmpty() {
        return this.map().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map().containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map().get(key);
    }

    @Override
    public V put(K key, V value) {
        assert (!this._write_lock);
        return this.map().put(key, value);
    }

    @Override
    public V remove(Object key) {
        assert (!this._write_lock);
        return this.map().remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        assert (!this._write_lock);
        this.map().putAll(m);
    }

    @Override
    public void clear() {
        assert (!this._write_lock);
        this.map().clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map().keySet();
    }

    @Override
    public Collection<V> values() {
        return this.map().values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map().entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.map().equals(o);
    }

    @Override
    public int hashCode() {
        return this.map().hashCode();
    }

    private boolean isStringKey(int mode) {
        return mode == 1 || mode == 2 || mode == 5;
    }

    public final AutoBuffer write_impl(AutoBuffer ab) {
        this._write_lock = true;
        try {
            int mode;
            if (this.map().size() == 0) {
                AutoBuffer autoBuffer = ab.put1(0);
                return autoBuffer;
            }
            Map.Entry<K, V> entry = this.map().entrySet().iterator().next();
            K key = entry.getKey();
            V val = entry.getValue();
            assert (key != null && val != null);
            if (key instanceof String) {
                if (val instanceof String) {
                    mode = 1;
                } else {
                    assert (val instanceof Freezable || val instanceof Freezable[]) : "incompatible class " + val.getClass();
                    mode = val instanceof Freezable ? 2 : 5;
                }
            } else {
                assert (key instanceof Iced);
                if (val instanceof String) {
                    mode = 3;
                } else {
                    assert (val instanceof Freezable || val instanceof Freezable[]);
                    mode = val instanceof Freezable ? 4 : 6;
                }
            }
            ab.put1(mode);
            this.writeMap(ab, mode);
            AutoBuffer autoBuffer = this.isStringKey(mode) ? ab.putStr(null) : ab.put(null);
            return autoBuffer;
        }
        catch (Throwable t) {
            System.err.println("Iced hash map serialization failed! " + t.toString() + ", msg = " + t.getMessage());
            t.printStackTrace();
            throw H2O.fail("Iced hash map serialization failed!" + t.toString() + ", msg = " + t.getMessage());
        }
        finally {
            this._write_lock = false;
        }
    }

    protected abstract Map<K, V> init();

    protected void writeMap(AutoBuffer ab, int mode) {
        for (Map.Entry<K, V> e : this.map().entrySet()) {
            K key = e.getKey();
            assert (key != null);
            V val = e.getValue();
            assert (val != null);
            if (mode == 1 || mode == 2 || mode == 5) {
                ab.putStr((String)key);
            } else {
                ab.put((Freezable)key);
            }
            if (mode == 1 || mode == 3) {
                ab.putStr((String)val);
                continue;
            }
            if (mode == 5 || mode == 6) {
                ab.put4(((Freezable[])val).length);
                for (Freezable v : (Freezable[])val) {
                    ab.put(v);
                }
                continue;
            }
            ab.put((Freezable)val);
        }
    }

    public final IcedHashMapBase read_impl(AutoBuffer ab) {
        try {
            String key;
            assert (this.map() == null || this.map().isEmpty());
            Map<String, Object> map = this.init();
            byte mode = ab.get1();
            if (mode == 0) {
                return this;
            }
            while ((key = this.isStringKey(mode) ? ab.getStr() : ab.get()) != null) {
                if (mode == 5 || mode == 6) {
                    Freezable[] vals = new Freezable[ab.get4()];
                    for (int i = 0; i < vals.length; ++i) {
                        vals[i] = ab.get();
                    }
                    map.put(key, vals);
                    continue;
                }
                String val = mode == 1 || mode == 3 ? ab.getStr() : ab.get();
                map.put(key, val);
            }
            return this;
        }
        catch (Throwable t) {
            t.printStackTrace();
            if (null == t.getCause()) {
                throw H2O.fail("IcedHashMap deserialization failed! + " + t.toString() + ", msg = " + t.getMessage() + ", cause: null");
            }
            throw H2O.fail("IcedHashMap deserialization failed! + " + t.toString() + ", msg = " + t.getMessage() + ", cause: " + t.getCause().toString() + ", cause msg: " + t.getCause().getMessage() + ", cause stacktrace: " + Arrays.toString(t.getCause().getStackTrace()));
        }
    }

    public final IcedHashMapBase readJSON_impl(AutoBuffer ab) {
        throw H2O.unimpl();
    }

    public final AutoBuffer writeJSON_impl(AutoBuffer ab) {
        boolean first = true;
        for (Map.Entry<K, V> entry : this.map().entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            assert (entry.getKey() instanceof String);
            assert (value instanceof String || value instanceof String[] || value instanceof Integer || value instanceof Freezable || value instanceof Freezable[]);
            if (first) {
                first = false;
            } else {
                ab.put1(44).put1(32);
            }
            ab.putJSONName((String)key);
            ab.put1(58);
            if (value instanceof String) {
                ab.putJSONName((String)value);
                continue;
            }
            if (value instanceof String[]) {
                ab.putJSONAStr((String[])value);
                continue;
            }
            if (value instanceof Integer) {
                ab.putJSON4((Integer)value);
                continue;
            }
            if (value instanceof Freezable) {
                ab.putJSON((Freezable)value);
                continue;
            }
            if (!(value instanceof Freezable[])) continue;
            ab.putJSONA((Freezable[])value);
        }
        return ab;
    }
}

